/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.Type1;
import edu.cmu.tetrad.session.Type2;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSessionEvent
extends TestCase {
    private Session session;

    public TestSessionEvent(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.session = new Session("Test");
    }

    public void testAddNodeEvent() {
        SessionNode node = new SessionNode(Type1.class);
        SessionEvent event = new SessionEvent(this.session, node, 0);
        TestSessionEvent.assertTrue(node == event.getNode());
        TestSessionEvent.assertEquals(0, event.getType());
    }

    public void testRemoveNodeEvent() {
        SessionNode node = new SessionNode(Type1.class);
        SessionEvent event = new SessionEvent(this.session, node, 1);
        TestSessionEvent.assertTrue(node == event.getNode());
        TestSessionEvent.assertEquals(1, event.getType());
    }

    public void testModelCreatedEvent() {
        SessionNode node = new SessionNode(Type1.class);
        SessionEvent event = new SessionEvent(this.session, node, 4);
        TestSessionEvent.assertTrue(node == event.getNode());
        TestSessionEvent.assertEquals(4, event.getType());
    }

    public void testModelDestroyedEvent() {
        SessionNode node = new SessionNode(Type1.class);
        SessionEvent event = new SessionEvent(this.session, node, 5);
        TestSessionEvent.assertTrue(node == event.getNode());
        TestSessionEvent.assertEquals(5, event.getType());
    }

    public void testModelUnclearEvent() {
        SessionNode node = new SessionNode(Type1.class);
        SessionEvent event = new SessionEvent(this.session, node, 6);
        TestSessionEvent.assertTrue(node == event.getNode());
        TestSessionEvent.assertEquals(6, event.getType());
    }

    public void testParentAddedEvent() {
        SessionNode child = new SessionNode(Type1.class);
        SessionNode parent = new SessionNode(Type2.class);
        SessionEvent event = new SessionEvent(this.session, parent, child, 2);
        TestSessionEvent.assertTrue(child == event.getChild());
        TestSessionEvent.assertTrue(parent == event.getParent());
        TestSessionEvent.assertEquals(2, event.getType());
    }

    public void testParentRemovedEvent() {
        SessionNode child = new SessionNode(Type1.class);
        SessionNode parent = new SessionNode(Type2.class);
        SessionEvent event = new SessionEvent(this.session, parent, child, 3);
        TestSessionEvent.assertTrue(child == event.getChild());
        TestSessionEvent.assertTrue(parent == event.getParent());
        TestSessionEvent.assertEquals(3, event.getType());
    }

    public static Test suite() {
        return new TestSuite(TestSessionEvent.class);
    }
}

