/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionListener;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.SessionSupport;
import edu.cmu.tetrad.session.Type1;
import edu.cmu.tetrad.session.Type2;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSessionSupport
extends TestCase {
    private SessionSupport sessionSupport;
    private Session session;
    private SessionNode node1;
    private SessionNode node2;
    private boolean event1Received;
    private boolean event2Received;

    public TestSessionSupport(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.node1 = new SessionNode(Type1.class);
        this.node2 = new SessionNode(Type2.class);
        this.session = new Session("Test");
        this.sessionSupport = new SessionSupport(this.session);
    }

    public void testSingleListener() {
        SessionListener l1 = new SessionListener(){

            @Override
            public void nodeAdded(SessionEvent event) {
                Assert.assertTrue(event.getType() == 0);
                Assert.assertTrue(TestSessionSupport.this.getNode1() == event.getNode());
                Assert.assertNull(event.getParent());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void nodeRemoved(SessionEvent event) {
                Assert.assertTrue(event.getType() == 1);
                Assert.assertTrue(TestSessionSupport.this.getNode1() == event.getNode());
                Assert.assertNull(event.getParent());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void parentAdded(SessionEvent event) {
                Assert.assertTrue(event.getType() == 2);
                Assert.assertTrue(TestSessionSupport.this.getNode1() == event.getParent());
                Assert.assertTrue(TestSessionSupport.this.getNode2() == event.getChild());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void parentRemoved(SessionEvent event) {
                Assert.assertTrue(event.getType() == 3);
                Assert.assertTrue(TestSessionSupport.this.getNode1() == event.getParent());
                Assert.assertTrue(TestSessionSupport.this.getNode2() == event.getChild());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void modelCreated(SessionEvent event) {
                Assert.assertTrue(event.getType() == 4);
                Assert.assertTrue(TestSessionSupport.this.getNode1() == event.getNode());
                Assert.assertNull(event.getParent());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void modelDestroyed(SessionEvent event) {
                Assert.assertTrue(event.getType() == 5);
                Assert.assertTrue(TestSessionSupport.this.getNode1() == event.getNode());
                Assert.assertNull(event.getParent());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void modelUnclear(SessionEvent event) {
                Assert.assertTrue(event.getType() == 6);
                Assert.assertTrue(TestSessionSupport.this.getNode1() == event.getNode());
                Assert.assertNull(event.getParent());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void executionStarted(SessionEvent event) {
                Assert.assertTrue(event.getType() == 7);
                Assert.assertNull(event.getParent());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void repetitionChanged(SessionEvent event) {
                Assert.assertTrue(event.getType() == 8);
                Assert.assertNull(event.getParent());
                TestSessionSupport.this.setEvent1Received(true);
            }

            @Override
            public void addingEdge(SessionEvent event) {
                Assert.assertTrue(event.getType() == 9);
                Assert.assertNull(event.getParent());
                TestSessionSupport.this.setEvent1Received(true);
            }
        };
        this.sessionSupport.addSessionListener(l1);
        this.setEvent1Received(false);
        this.sessionSupport.fireNodeAdded(this.node1);
        TestSessionSupport.assertTrue(this.isEvent1Received());
        this.setEvent1Received(false);
        this.sessionSupport.fireNodeRemoved(this.node1);
        TestSessionSupport.assertTrue(this.isEvent1Received());
        this.setEvent1Received(false);
        this.sessionSupport.fireParentAdded(this.node1, this.node2);
        TestSessionSupport.assertTrue(this.isEvent1Received());
        this.setEvent1Received(false);
        this.sessionSupport.fireParentRemoved(this.node1, this.node2);
        TestSessionSupport.assertTrue(this.isEvent1Received());
        this.setEvent1Received(false);
        this.sessionSupport.fireModelCreated(this.node1);
        TestSessionSupport.assertTrue(this.isEvent1Received());
        this.setEvent1Received(false);
        this.sessionSupport.fireModelDestroyed(this.node1);
        TestSessionSupport.assertTrue(this.isEvent1Received());
        this.sessionSupport.removeSessionListener(l1);
        this.setEvent1Received(false);
        this.sessionSupport.fireNodeAdded(this.node1);
        TestSessionSupport.assertTrue(!this.isEvent1Received());
    }

    public void testMultipleListeners() {
        SessionAdapter l1 = new SessionAdapter(){

            @Override
            public void nodeAdded(SessionEvent event) {
                System.out.println("HERE");
                TestSessionSupport.this.setEvent1Received(true);
            }
        };
        SessionAdapter l2 = new SessionAdapter(){

            @Override
            public void nodeAdded(SessionEvent event) {
                TestSessionSupport.this.setEvent2Received(true);
            }
        };
        this.sessionSupport.addSessionListener(l1);
        this.sessionSupport.addSessionListener(l2);
        this.setEvent1Received(false);
        this.setEvent2Received(false);
        this.sessionSupport.fireNodeAdded(this.node1);
        TestSessionSupport.assertTrue(this.isEvent1Received());
        TestSessionSupport.assertTrue(this.isEvent2Received());
        this.sessionSupport.removeSessionListener(l1);
        this.setEvent1Received(false);
        this.setEvent2Received(false);
        this.sessionSupport.fireNodeAdded(this.node1);
        TestSessionSupport.assertTrue(!this.isEvent1Received());
        TestSessionSupport.assertTrue(this.isEvent2Received());
    }

    public boolean isEvent1Received() {
        return this.event1Received;
    }

    public void setEvent1Received(boolean event1Received) {
        this.event1Received = event1Received;
    }

    public boolean isEvent2Received() {
        return this.event2Received;
    }

    public void setEvent2Received(boolean event2Received) {
        this.event2Received = event2Received;
    }

    public SessionNode getNode1() {
        return this.node1;
    }

    public SessionNode getNode2() {
        return this.node2;
    }

    public static Test suite() {
        return new TestSuite(TestSessionSupport.class);
    }
}

