/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.SimulationStudy;
import edu.cmu.tetrad.session.Type11;
import edu.cmu.tetrad.session.Type12;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSimulationStudy
extends TestCase {
    private List nodes;
    private int[] creations;

    public TestSimulationStudy(String name) {
        super(name);
    }

    public void testPlaceholder() {
    }

    public void rtestExecutionPath() {
        Session session = new Session("Test");
        SessionNode node1 = new SessionNode(null, "Node1", Type11.class);
        SessionNode node2 = new SessionNode(null, "Node2", Type12.class);
        SessionNode node3 = new SessionNode(null, "Node3", Type12.class);
        SessionNode node4 = new SessionNode(null, "Node4", Type12.class);
        SessionNode node5 = new SessionNode(null, "Node5", Type12.class);
        SessionNode node6 = new SessionNode(null, "Node6", Type12.class);
        SessionNode node7 = new SessionNode(null, "Node7", Type12.class);
        SessionNode node8 = new SessionNode(null, "Node8", Type12.class);
        session.addNode(node1);
        session.addNode(node2);
        session.addNode(node3);
        session.addNode(node4);
        session.addNode(node5);
        session.addNode(node6);
        session.addNode(node7);
        session.addNode(node8);
        node1.addChild(node2);
        node2.addChild(node3);
        node2.addChild(node4);
        node3.addChild(node5);
        node3.addChild(node6);
        node4.addChild(node7);
        node4.addChild(node8);
        this.nodes = new ArrayList();
        this.nodes.add(node1);
        this.nodes.add(node2);
        this.nodes.add(node3);
        this.nodes.add(node4);
        this.nodes.add(node5);
        this.nodes.add(node6);
        this.nodes.add(node7);
        this.nodes.add(node8);
        this.initCreations(this.nodes);
        SimulationStudy simulationStudy = new SimulationStudy(session);
        session.addSessionListener(new SessionAdapter(){

            @Override
            public void modelCreated(SessionEvent e) {
                SessionNode node = e.getNode();
                TestSimulationStudy.this.incrementCreationCount(node);
            }
        });
        simulationStudy.setRepetition(node2, 2);
        simulationStudy.setRepetition(node4, 3);
        simulationStudy.setRepetition(node5, 7);
        boolean overwrite = true;
        simulationStudy.execute(node1, overwrite);
        TestSimulationStudy.assertEquals(2, this.getCreationCount(node2));
        TestSimulationStudy.assertEquals(6, this.getCreationCount(node4));
        TestSimulationStudy.assertEquals(14, this.getCreationCount(node5));
        TestSimulationStudy.assertEquals(6, this.getCreationCount(node8));
        TestSimulationStudy.assertEquals(2, this.getCreationCount(node3));
        TestSimulationStudy.assertEquals(1, this.getCreationCount(node1));
    }

    public synchronized void incrementCreationCount(SessionNode node) {
        System.out.println("Incrementing: " + node);
        int n = this.nodes.indexOf(node);
        this.creations[n] = this.creations[n] + 1;
    }

    public synchronized int getCreationCount(SessionNode node) {
        return this.creations[this.nodes.indexOf(node)];
    }

    public void initCreations(List nodes) {
        this.nodes = new ArrayList(nodes);
        this.creations = new int[nodes.size()];
    }

    public static Test suite() {
        return new TestSuite(TestSimulationStudy.class);
    }
}

