/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.test;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Discretizer;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestDiscretizer
extends TestCase {
    public TestDiscretizer(String name) {
        super(name);
    }

    public static void testBreakpointCalculation() {
        double[] data = new double[]{13.0, 1.2, 2.2, 4.5, 12.005, 5.5, 10.1, 7.5, 3.4};
        double[] breakpoints = Discretizer.getEqualFrequencyBreakPoints(data, 3);
        TestDiscretizer.assertTrue(breakpoints.length == 2);
        TestDiscretizer.assertEquals(4.5, breakpoints[0]);
        TestDiscretizer.assertEquals(10.1, breakpoints[1]);
        Discretizer.Discretization dis = Discretizer.discretize(data, breakpoints, "after", Arrays.asList("0", "1", "2"));
        System.out.println(dis);
        breakpoints = Discretizer.getEqualFrequencyBreakPoints(data, 4);
        TestDiscretizer.assertTrue(breakpoints.length == 3);
        TestDiscretizer.assertEquals(3.4, breakpoints[0]);
        TestDiscretizer.assertEquals(5.5, breakpoints[1]);
        TestDiscretizer.assertEquals(10.1, breakpoints[2]);
    }

    public static void testManualDiscretize() {
        ContinuousVariable x = new ContinuousVariable("X");
        List<Node> nodes = Collections.singletonList(x);
        ColtDataSet data = new ColtDataSet(9, nodes);
        data.setDouble(0, 0, 13.0);
        data.setDouble(1, 0, 1.2);
        data.setDouble(2, 0, 2.2);
        data.setDouble(3, 0, 4.5);
        data.setDouble(4, 0, 12.005);
        data.setDouble(5, 0, 5.5);
        data.setDouble(6, 0, 10.1);
        data.setDouble(7, 0, 7.5);
        data.setDouble(8, 0, 3.4);
        System.out.println(data);
        Discretizer discretizer = new Discretizer(data);
        discretizer.setVariablesCopied(true);
        discretizer.equalCounts(x, 3);
        DataSet discretized = discretizer.discretize();
        System.out.println(discretized);
        TestDiscretizer.assertEquals(discretized.getInt(0, 0), 2);
        TestDiscretizer.assertEquals(discretized.getInt(1, 0), 0);
        TestDiscretizer.assertEquals(discretized.getInt(2, 0), 0);
        TestDiscretizer.assertEquals(discretized.getInt(3, 0), 1);
        TestDiscretizer.assertEquals(discretized.getInt(4, 0), 2);
        TestDiscretizer.assertEquals(discretized.getInt(5, 0), 1);
        TestDiscretizer.assertEquals(discretized.getInt(6, 0), 2);
        TestDiscretizer.assertEquals(discretized.getInt(7, 0), 1);
        TestDiscretizer.assertEquals(discretized.getInt(8, 0), 0);
    }

    public void testManualDiscretize2() {
        Dag graph = GraphUtils.randomDag(5, 0, 5, 3, 3, 3, false);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateData(100, false);
        List<Node> nodes = data.getVariables();
        Discretizer discretizer = new Discretizer(data);
        discretizer.setVariablesCopied(true);
        discretizer.equalCounts(nodes.get(0), 3);
        discretizer.equalIntervals(nodes.get(1), 2);
        discretizer.equalCounts(nodes.get(2), 5);
        discretizer.equalIntervals(nodes.get(3), 8);
        discretizer.equalCounts(nodes.get(4), 4);
        DataSet discretized = discretizer.discretize();
        System.out.println(discretized);
        TestDiscretizer.assertEquals(this.maxInColumn(discretized, 0), 2);
        TestDiscretizer.assertEquals(this.maxInColumn(discretized, 1), 1);
        TestDiscretizer.assertEquals(this.maxInColumn(discretized, 2), 4);
        TestDiscretizer.assertEquals(this.maxInColumn(discretized, 3), 7);
        TestDiscretizer.assertEquals(this.maxInColumn(discretized, 4), 3);
    }

    public void testManualDiscretize3() {
        Dag graph = GraphUtils.randomDag(5, 0, 5, 3, 3, 3, false);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateData(100, false);
        List<Node> nodes = data.getVariables();
        Discretizer discretizer = new Discretizer(data);
        discretizer.setVariablesCopied(true);
        discretizer.setVariablesCopied(true);
        discretizer.equalCounts(nodes.get(0), 3);
        DataSet discretized = discretizer.discretize();
        System.out.println(discretized);
        TestDiscretizer.assertTrue(discretized.getVariable(0) instanceof DiscreteVariable);
        TestDiscretizer.assertTrue(discretized.getVariable(1) instanceof ContinuousVariable);
        TestDiscretizer.assertTrue(discretized.getVariable(2) instanceof ContinuousVariable);
        TestDiscretizer.assertTrue(discretized.getVariable(3) instanceof ContinuousVariable);
        TestDiscretizer.assertTrue(discretized.getVariable(4) instanceof ContinuousVariable);
    }

    private int maxInColumn(DataSet dataSet, int column) {
        int max = -1;
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            int value = dataSet.getInt(i, column);
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public void testContinuous() {
        double[] data = new double[]{1.0, 2.0, 2.5, 3.0, 4.0, 5.0};
        double[] cutoffs = new double[]{2.5, 3.2};
        List<String> categories = Arrays.asList("lo", "med", "hi");
        Discretizer.Discretization discretization = Discretizer.discretize(data, cutoffs, "after", categories);
        System.out.println(discretization);
        List<String> discretizedCategories = discretization.getVariable().getCategories();
        int[] discretizedData = discretization.getData();
        TestDiscretizer.assertEquals("lo", discretizedCategories.get(discretizedData[0]));
        TestDiscretizer.assertEquals("lo", discretizedCategories.get(discretizedData[1]));
        TestDiscretizer.assertEquals("med", discretizedCategories.get(discretizedData[2]));
        TestDiscretizer.assertEquals("med", discretizedCategories.get(discretizedData[3]));
        TestDiscretizer.assertEquals("hi", discretizedCategories.get(discretizedData[4]));
        TestDiscretizer.assertEquals("hi", discretizedCategories.get(discretizedData[5]));
    }

    public static Test suite() {
        return new TestSuite(TestDiscretizer.class);
    }
}

