/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.TetradLoggerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultTetradLoggerConfig
implements TetradLoggerConfig {
    static final long serialVersionUID = 23L;
    private List<TetradLoggerConfig.Event> events;
    private Set<String> active = new HashSet<String>();

    public DefaultTetradLoggerConfig(List<TetradLoggerConfig.Event> events) {
        if (events == null) {
            throw new NullPointerException("The given list of events must not be null");
        }
        this.events = new ArrayList<TetradLoggerConfig.Event>(events);
    }

    public DefaultTetradLoggerConfig(String ... events) {
        this.events = new ArrayList<TetradLoggerConfig.Event>(events.length);
        for (String event : events) {
            this.events.add(new DefaultEvent(event, "No Description"));
        }
    }

    @Override
    public TetradLoggerConfig copy() {
        DefaultTetradLoggerConfig copy = new DefaultTetradLoggerConfig(new String[0]);
        copy.events = new ArrayList<TetradLoggerConfig.Event>(this.events);
        copy.active = new HashSet<String>(this.active);
        return copy;
    }

    public static DefaultTetradLoggerConfig serializableInstance() {
        return new DefaultTetradLoggerConfig(new String[0]);
    }

    @Override
    public boolean isEventActive(String id) {
        return this.active.contains(id);
    }

    @Override
    public boolean isActive() {
        return !this.active.isEmpty();
    }

    @Override
    public List<TetradLoggerConfig.Event> getSupportedEvents() {
        return Collections.unmodifiableList(this.events);
    }

    @Override
    public void setEventActive(String id, boolean active) {
        if (!this.contains(id)) {
            throw new IllegalArgumentException("There is no event known under the given id: " + id);
        }
        if (active) {
            this.active.add(id);
        } else {
            this.active.remove(id);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nDefaultTetradLoggerConfig: events as follows:");
        for (TetradLoggerConfig.Event event : this.events) {
            buf.append("\n" + event + (this.active.contains(event.getId()) ? " (active)" : ""));
        }
        return buf.toString();
    }

    private boolean contains(String id) {
        for (TetradLoggerConfig.Event event : this.events) {
            if (!id.equals(event.getId())) continue;
            return true;
        }
        return false;
    }

    public static class DefaultEvent
    implements TetradLoggerConfig.Event {
        static final long serialVersionUID = 23L;
        private String id;
        private String description;

        public DefaultEvent(String id, String description) {
            if (id == null) {
                throw new NullPointerException("The given id must not be null");
            }
            if (description == null) {
                throw new NullPointerException("The given description must not be null");
            }
            this.id = id;
            this.description = description;
        }

        public static DefaultEvent serializableInstance() {
            return new DefaultEvent("", "");
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "Event(" + this.id + ", " + this.description + ")";
        }
    }
}

