/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Statistic;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.Property;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.jet.math.Functions;
import edu.cmu.tetrad.search.fastica.math.Matrix;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class MatrixUtils {
    public static boolean equals(double[][] ma, double[][] mb) {
        return new DenseDoubleMatrix2D(ma).equals(new DenseDoubleMatrix2D(mb));
    }

    public static boolean equals(double[] va, double[] vb) {
        return new DenseDoubleMatrix1D(va).equals(new DenseDoubleMatrix1D(vb));
    }

    public static boolean equals(double[][] ma, double[][] mb, double tolerance) {
        return new Property(tolerance).equals((DoubleMatrix2D)new DenseDoubleMatrix2D(ma), new DenseDoubleMatrix2D(mb));
    }

    public static boolean equals(double[] va, double[] vb, double tolerance) {
        return new Property(tolerance).equals((DoubleMatrix1D)new DenseDoubleMatrix1D(va), new DenseDoubleMatrix1D(vb));
    }

    public static boolean isSquare(double[][] m) {
        return new Property(0.0).isSquare(new DenseDoubleMatrix2D(m));
    }

    public static boolean isSquareC(DoubleMatrix2D m) {
        return new Property(0.0).isSquare(m);
    }

    public static boolean isSymmetric(double[][] m, double tolerance) {
        return new Property(tolerance).isSymmetric(new DenseDoubleMatrix2D(m));
    }

    public static boolean isSymmetricC(DoubleMatrix2D m, double tolerance) {
        return new Property(tolerance).isSymmetric(m);
    }

    public static double determinant(double[][] m) {
        return new Algebra().det(new DenseDoubleMatrix2D(m));
    }

    public static double determinant(DoubleMatrix2D m) {
        return new Algebra(1.0E-5).det(m);
    }

    public static double[][] submatrix(double[][] m, int rem) {
        int[] indices = new int[m.length];
        int j = -1;
        for (int i = 0; i < m.length; ++i) {
            if (++j == rem) {
                // empty if block
            }
            indices[i] = ++j;
        }
        return new DenseDoubleMatrix2D(m).viewSelection(indices, indices).toArray();
    }

    public static double[][] inverse(double[][] m) {
        Algebra algebra = new Algebra();
        DenseDoubleMatrix2D mm = new DenseDoubleMatrix2D(m);
        return algebra.inverse(mm).toArray();
    }

    public static DoubleMatrix2D inverseC(DoubleMatrix2D m) {
        return new Algebra().inverse(m);
    }

    public static DoubleMatrix2D ginverse(DoubleMatrix2D x) {
        if (x.columns() == 0) {
            return new DenseDoubleMatrix2D(0, 0);
        }
        Algebra algebra = new Algebra();
        SingularValueDecomposition svd = new SingularValueDecomposition(x);
        DoubleMatrix2D U = svd.getU();
        DoubleMatrix2D V = svd.getV();
        DoubleMatrix2D S = svd.getS();
        S.assign(new DoubleFunction(){

            @Override
            public double apply(double v) {
                return v == 0.0 ? 0.0 : 1.0 / v;
            }
        });
        return new Algebra().mult(V, algebra.mult(S, algebra.transpose(U)));
    }

    public static double[][] product(double[][] ma, double[][] mb) {
        DenseDoubleMatrix2D d = new DenseDoubleMatrix2D(ma);
        DenseDoubleMatrix2D e = new DenseDoubleMatrix2D(mb);
        return new Algebra().mult((DoubleMatrix2D)d, e).toArray();
    }

    public static DoubleMatrix2D productC(DoubleMatrix2D ma, DoubleMatrix2D mb) {
        return new Algebra().mult(ma, mb);
    }

    public static double[] product(double[] ma, double[][] mb) {
        return new Algebra().mult(new DenseDoubleMatrix2D(mb).viewDice(), (DoubleMatrix1D)new DenseDoubleMatrix1D(ma)).toArray();
    }

    public static DoubleMatrix1D product(DoubleMatrix1D ma, DoubleMatrix2D mb) {
        return new Algebra().mult(mb.viewDice(), ma);
    }

    public static double[] product(double[][] ma, double[] mb) {
        return new Algebra().mult((DoubleMatrix2D)new DenseDoubleMatrix2D(ma), (DoubleMatrix1D)new DenseDoubleMatrix1D(mb)).toArray();
    }

    public static double[][] outerProduct(double[] ma, double[] mb) {
        return new Algebra().multOuter(new DenseDoubleMatrix1D(ma), new DenseDoubleMatrix1D(mb), null).toArray();
    }

    public static double innerProduct(double[] ma, double[] mb) {
        return new Algebra().mult(new DenseDoubleMatrix1D(ma), (DoubleMatrix1D)new DenseDoubleMatrix1D(mb));
    }

    public static double innerProduct(DoubleMatrix1D ma, DoubleMatrix1D mb) {
        return new Algebra().mult(ma, mb);
    }

    public static double[][] transpose(double[][] m) {
        return new DenseDoubleMatrix2D(m).viewDice().toArray();
    }

    public static DoubleMatrix2D transposeC(DoubleMatrix2D m) {
        return new Algebra().transpose(m);
    }

    public static double trace(double[][] m) {
        return new Algebra().trace(new DenseDoubleMatrix2D(m));
    }

    public static double trace(DoubleMatrix2D m) {
        return new Algebra().trace(m);
    }

    public static double zSum(double[][] m) {
        return new DenseDoubleMatrix2D(m).zSum();
    }

    public static double[][] identity(int size) {
        return DoubleFactory2D.dense.identity(size).toArray();
    }

    public static DoubleMatrix2D identityC(int size) {
        return DoubleFactory2D.dense.identity(size);
    }

    public static double[][] sum(double[][] ma, double[][] mb) {
        DenseDoubleMatrix2D _ma = new DenseDoubleMatrix2D(ma);
        DenseDoubleMatrix2D _mb = new DenseDoubleMatrix2D(mb);
        ((DoubleMatrix2D)_ma).assign(_mb, Functions.plus);
        return _ma.toArray();
    }

    public static DoubleMatrix2D sumC(DoubleMatrix2D ma, DoubleMatrix2D mb) {
        DoubleMatrix2D mc = ma.copy();
        return mc.assign(mb, Functions.plus);
    }

    public static double[] sum(double[] ma, double[] mb) {
        DenseDoubleMatrix1D _ma = new DenseDoubleMatrix1D(ma);
        DenseDoubleMatrix1D _mb = new DenseDoubleMatrix1D(mb);
        ((DoubleMatrix1D)_ma).assign(_mb, Functions.plus);
        return _ma.toArray();
    }

    public static double[][] subtract(double[][] ma, double[][] mb) {
        DenseDoubleMatrix2D _ma = new DenseDoubleMatrix2D(ma);
        DenseDoubleMatrix2D _mb = new DenseDoubleMatrix2D(mb);
        ((DoubleMatrix2D)_ma).assign(_mb, Functions.minus);
        return _ma.toArray();
    }

    public static DoubleMatrix2D subtractC(DoubleMatrix2D ma, DoubleMatrix2D mb) {
        return ma.assign(mb, Functions.minus);
    }

    public static double[] subtract(double[] ma, double[] mb) {
        DenseDoubleMatrix1D _ma = new DenseDoubleMatrix1D(ma);
        DenseDoubleMatrix1D _mb = new DenseDoubleMatrix1D(mb);
        ((DoubleMatrix1D)_ma).assign(_mb, Functions.minus);
        return _ma.toArray();
    }

    public static double[][] directProduct(double[][] ma, double[][] mb) {
        int arow = ma.length;
        int brow = mb.length;
        int acol = ma[0].length;
        int bcol = mb[0].length;
        double[][] product = new double[arow * brow][acol * bcol];
        for (int i1 = 0; i1 < arow; ++i1) {
            for (int j1 = 0; j1 < acol; ++j1) {
                for (int i2 = 0; i2 < brow; ++i2) {
                    for (int j2 = 0; j2 < bcol; ++j2) {
                        int i = i1 * brow + i2;
                        int j = j1 * bcol + j2;
                        product[i][j] = ma[i1][j1] * mb[i2][j2];
                    }
                }
            }
        }
        return product;
    }

    public static double[][] scalarProduct(double scalar, double[][] m) {
        DenseDoubleMatrix2D _m = new DenseDoubleMatrix2D(m);
        ((DoubleMatrix2D)_m).assign(Functions.mult(scalar));
        return _m.toArray();
    }

    public static double[] scalarProduct(double scalar, double[] m) {
        DenseDoubleMatrix1D _m = new DenseDoubleMatrix1D(m);
        ((DoubleMatrix1D)_m).assign(Functions.mult(scalar));
        return _m.toArray();
    }

    public static double[] concatenate(double[][] vectors) {
        int numVectors = vectors.length;
        int length = vectors[0].length;
        double[] concat = new double[numVectors * length];
        for (int i = 0; i < vectors.length; ++i) {
            System.arraycopy(vectors[i], 0, concat, i * length, length);
        }
        return concat;
    }

    public static double[][] asRow(double[] v) {
        double[][] arr = new double[1][v.length];
        System.arraycopy(v, 0, arr[0], 0, v.length);
        return arr;
    }

    public static double[][] asCol(double[] v) {
        double[][] arr = new double[v.length][1];
        for (int i = 0; i < v.length; ++i) {
            arr[i][0] = v[i];
        }
        return arr;
    }

    public static DoubleMatrix2D impliedCovarC(DoubleMatrix2D edgeCoef, DoubleMatrix2D errCovar) {
        if (MatrixUtils.containsNaN(edgeCoef)) {
            throw new IllegalArgumentException("Edge coefficient matrix must not contain undefined values. Probably the search put them there");
        }
        if (MatrixUtils.containsNaN(errCovar)) {
            throw new IllegalArgumentException("Error covariance matrix must not contain undefined values. Probably the search put them there.");
        }
        DoubleMatrix2D m1 = DoubleFactory2D.dense.identity(edgeCoef.rows());
        m1.assign(edgeCoef, Functions.minus);
        DoubleMatrix2D m3 = MatrixUtils.ginverse(m1);
        DoubleMatrix2D m4 = new Algebra().transpose(m3);
        DoubleMatrix2D m5 = new Algebra().mult(m3, errCovar);
        DoubleMatrix2D m6 = new Algebra().mult(m5, m4);
        for (int i = 0; i < m6.rows(); ++i) {
            for (int j = i + 1; j < m6.columns(); ++j) {
                m6.set(i, j, m6.get(j, i));
            }
        }
        return m6;
    }

    public static boolean containsNaN(DoubleMatrix2D m) {
        for (int i = 0; i < m.rows(); ++i) {
            for (int j = 0; j < m.columns(); ++j) {
                if (!Double.isNaN(m.get(i, j))) continue;
                return true;
            }
        }
        return false;
    }

    public static double[][] vech(double[][] m) {
        if (!MatrixUtils.isSymmetric(m, 1.0E-5)) {
            throw new IllegalArgumentException("m must be a symmetric matrix.");
        }
        int order = m.length;
        int vechSize = MatrixUtils.sum0ToN(order);
        double[] vech = new double[vechSize];
        int index = -1;
        for (int i = 0; i < order; ++i) {
            for (int j = i; j < order; ++j) {
                vech[++index] = m[i][j];
            }
        }
        return MatrixUtils.asCol(vech);
    }

    public static double[][] invVech(double[] vech) {
        int order = MatrixUtils.vechOrder(vech);
        double[][] m = new double[order][order];
        int index = -1;
        for (int i = 0; i < order; ++i) {
            for (int j = i; j < order; ++j) {
                m[i][j] = vech[++index];
                m[j][i] = vech[index];
            }
        }
        return m;
    }

    public static double[][] vec(double[][] m) {
        assert (MatrixUtils.isSquare(m));
        int order = m.length;
        int vecSize = order * order;
        double[] vec = new double[vecSize];
        int index = -1;
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                vec[++index] = m[i][j];
            }
        }
        return MatrixUtils.asCol(vec);
    }

    public static int sum0ToN(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument must be >= 0: " + n);
        }
        return n * (n + 1) / 2;
    }

    public static double[][] vechToVecLeft(int n) {
        int row = n * n;
        int col = MatrixUtils.sum0ToN(n);
        double[][] m = new double[row][col];
        int index = -1;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                int _row = i * n + j;
                int _col = ++index;
                m[_row][_col] = 1.0;
                _row = j * n + i;
                _col = index;
                m[_row][_col] = 1.0;
            }
        }
        return m;
    }

    public static boolean hasDimensions(double[][] m, int i, int j) {
        DenseDoubleMatrix2D _m = new DenseDoubleMatrix2D(m);
        return _m.rows() == i && _m.columns() == j;
    }

    public static double[][] zeros(int rows, int cols) {
        DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, cols);
        m.assign(0.0);
        return m.toArray();
    }

    public static boolean isPositiveDefinite(DoubleMatrix2D matrix) {
        return new CholeskyDecomposition(matrix).isSymmetricPositiveDefinite();
    }

    public static double[][] cholesky(double[][] covar) {
        return new CholeskyDecomposition(new DenseDoubleMatrix2D(covar)).getL().toArray();
    }

    public static DoubleMatrix2D choleskyC(DoubleMatrix2D covar) {
        return new CholeskyDecomposition(covar).getL();
    }

    public static void pasteCol(double[][] m1, int m1Col, double[][] m2, int m2Col) {
        if (m1.length != m2.length) {
            throw new IllegalArgumentException("Matrix must have the same number of rows.");
        }
        for (int j = 0; j < m1.length; ++j) {
            m2[j][m2Col] = m1[j][m1Col];
        }
    }

    public static DoubleMatrix2D convertCovToCorr(DoubleMatrix2D m) {
        return Statistic.correlation(m.copy());
    }

    public static double[][] convertLowerTriangleToSymmetric(double[][] arr) {
        int size = arr.length;
        double[][] m = new double[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j <= i; ++j) {
                m[i][j] = arr[i][j];
                m[j][i] = arr[i][j];
            }
        }
        return m;
    }

    public static String toString(double[][] m) {
        DecimalFormat nf = new DecimalFormat(" 0.0000;-0.0000");
        return MatrixUtils.toString(m, nf);
    }

    public static String toString(double[][] m, NumberFormat nf) {
        String result;
        if (nf == null) {
            throw new NullPointerException("NumberFormat must not be null.");
        }
        if (m == null) {
            result = MatrixUtils.nullMessage();
        } else {
            StringBuilder buf = new StringBuilder();
            for (double[] aM : m) {
                buf.append("\n");
                for (double anAM : aM) {
                    buf.append(nf.format(anAM)).append("\t");
                }
            }
            result = buf.toString();
        }
        return result;
    }

    public static String toString(int[] m) {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        for (int aM : m) {
            buf.append(aM).append("\t");
        }
        return buf.toString();
    }

    public static String toString(int[][] m) {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                buf.append("[").append(i).append(",").append(j).append("]").append(m[i][j]).append("\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String toString(boolean[][] m) {
        String result;
        if (m == null) {
            result = MatrixUtils.nullMessage();
        } else {
            StringBuilder buf = new StringBuilder();
            for (boolean[] aM : m) {
                buf.append("\n");
                buf.append("\t");
                for (boolean anAM : aM) {
                    buf.append(anAM).append("\t");
                }
            }
            result = buf.toString();
        }
        return result;
    }

    private static String nullMessage() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        buf.append("\t");
        buf.append("<Matrix is null>");
        return buf.toString();
    }

    private static int vechOrder(double[] vech) {
        int difference = vech.length;
        int order = 0;
        while (difference > 0) {
            if ((difference -= ++order) >= 0) continue;
            throw new IllegalArgumentException("Illegal length for vech: " + vech.length);
        }
        return order;
    }

    public static DoubleMatrix1D linearCombination(DoubleMatrix1D a, double aw, DoubleMatrix1D b, double bw) {
        DenseDoubleMatrix1D resultMatrix = new DenseDoubleMatrix1D(a.size());
        for (int i = 0; i < a.size(); ++i) {
            resultMatrix.set(i, aw * a.get(i) + bw * b.get(i));
        }
        return resultMatrix;
    }

    public static DoubleMatrix1D linearCombination(DoubleMatrix1D[] vecs, double[] weights) {
        DenseDoubleMatrix1D resultMatrix = new DenseDoubleMatrix1D(vecs[0].size());
        for (int i = 0; i < vecs[0].size(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < vecs.length; ++j) {
                sum += vecs[j].get(i) * weights[j];
            }
            resultMatrix.set(i, sum);
        }
        return resultMatrix;
    }

    public static DoubleMatrix2D linearCombination(DoubleMatrix2D a, double aw, DoubleMatrix2D b, double bw) {
        for (int i = 0; i < a.rows(); ++i) {
        }
        DenseDoubleMatrix2D resultMatrix = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                resultMatrix.set(i, j, aw * a.get(i, j) + bw * b.get(i, j));
                if (i != j) continue;
            }
        }
        return resultMatrix;
    }

    public static double[] convert(DoubleMatrix1D vector) {
        int n = vector.size();
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = vector.get(i);
        }
        return v;
    }

    public static double[][] convert(DoubleMatrix2D inVectors) {
        if (inVectors == null) {
            return null;
        }
        int m = inVectors.rows();
        int n = inVectors.columns();
        double[][] inV = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                inV[i][j] = inVectors.get(i, j);
            }
        }
        return inV;
    }

    public static DoubleMatrix2D convertToColt(double[][] vectors) {
        int m = Matrix.getNumOfRows(vectors);
        int n = Matrix.getNumOfColumns(vectors);
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                mat.set(i, j, vectors[i][j]);
            }
        }
        return mat;
    }

    public static DoubleMatrix2D identityMatrix(int n) {
        DenseDoubleMatrix2D I = new DenseDoubleMatrix2D(n, n);
        ((DoubleMatrix2D)I).assign(0.0);
        for (int i = 0; i < n; ++i) {
            I.set(i, i, 1.0);
        }
        return I;
    }

    public static DoubleMatrix2D inverse(DoubleMatrix2D mat) {
        Algebra alg = new Algebra();
        return alg.inverse(mat);
    }

    public static DoubleMatrix2D normalizeDiagonal(DoubleMatrix2D matrix) {
        DenseDoubleMatrix2D resultMatrix = new DenseDoubleMatrix2D(MatrixUtils.convert(matrix));
        for (int i = 0; i < resultMatrix.rows(); ++i) {
            double factor = 1.0 / resultMatrix.get(i, i);
            for (int j = 0; j < resultMatrix.columns(); ++j) {
                resultMatrix.set(i, j, factor * resultMatrix.get(i, j));
            }
        }
        return resultMatrix;
    }

    public static boolean equals(DoubleMatrix2D m1, DoubleMatrix2D m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.rows() != m2.rows() || m1.columns() != m2.columns()) {
            return false;
        }
        for (int i = 0; i < m1.rows(); ++i) {
            for (int j = 0; j < m2.columns(); ++j) {
                if (m1.get(i, j) == m2.get(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public static int[] copyOf(int[] arr, int length) {
        int[] copy = new int[arr.length];
        System.arraycopy(arr, 0, copy, 0, length);
        return copy;
    }
}

