/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.RandomUtil;
import java.text.DecimalFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPersistentRandomUtil
extends TestCase {
    public TestPersistentRandomUtil(String name) {
        super(name);
    }

    public void testIntegralSumToOne() {
        int i;
        int numBoxes = 100;
        int[] boxes = new int[numBoxes];
        for (i = 0; i < 100000000; ++i) {
            int randomint;
            int n = randomint = RandomUtil.getInstance().nextInt(numBoxes);
            boxes[n] = boxes[n] + 1;
        }
        for (i = 0; i < numBoxes; ++i) {
            System.out.println("Count for box " + i + " = " + boxes[i]);
        }
    }

    public void testGaussian() {
        int i;
        int numBoxes = 40;
        double low = -4.0;
        double high = 4.0;
        DecimalFormat nf = new DecimalFormat("0.000");
        int[] boxes = new int[numBoxes];
        double[] cutoffs = new double[numBoxes - 1];
        for (i = 0; i < cutoffs.length; ++i) {
            cutoffs[i] = low + (double)i / (double)(cutoffs.length - 1) * (high - low);
        }
        block1: for (i = 0; i < 1000000; ++i) {
            double r = RandomUtil.getInstance().nextNormal(0.0, 1.0);
            for (int j = 0; j < cutoffs.length; ++j) {
                if (!(r < cutoffs[j])) continue;
                int n = j;
                boxes[n] = boxes[n] + 1;
                continue block1;
            }
            int n = boxes.length - 1;
            boxes[n] = boxes[n] + 1;
        }
        for (i = 0; i < cutoffs.length; ++i) {
            System.out.println("< " + nf.format(cutoffs[i]) + " = " + boxes[i]);
        }
        System.out.println("> " + nf.format(cutoffs[cutoffs.length - 1]) + " = " + boxes[cutoffs.length]);
    }

    public void testDouble() {
        int i;
        int numBoxes = 40;
        double low = 0.0;
        double high = 1.0;
        DecimalFormat nf = new DecimalFormat("0.000");
        int[] boxes = new int[numBoxes];
        double[] cutoffs = new double[numBoxes - 1];
        for (i = 0; i < cutoffs.length; ++i) {
            cutoffs[i] = low + (double)i / (double)(cutoffs.length - 1) * (high - low);
        }
        block1: for (i = 0; i < 1000000; ++i) {
            double r = RandomUtil.getInstance().nextDouble();
            for (int j = 0; j < cutoffs.length; ++j) {
                if (!(r < cutoffs[j])) continue;
                int n = j;
                boxes[n] = boxes[n] + 1;
                continue block1;
            }
            int n = boxes.length - 1;
            boxes[n] = boxes[n] + 1;
        }
        for (i = 0; i < cutoffs.length; ++i) {
            System.out.println("< " + nf.format(cutoffs[i]) + " = " + boxes[i]);
        }
        System.out.println("> " + nf.format(cutoffs[cutoffs.length - 1]) + " = " + boxes[cutoffs.length]);
    }

    public static Test suite() {
        return new TestSuite(TestPersistentRandomUtil.class);
    }
}

