/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ChiSquare
implements Distribution {
    static final long serialVersionUID = 23L;
    private double df = 5.0;

    public ChiSquare(double df) {
        this.df = df;
    }

    public static ChiSquare serializableInstance() {
        return new ChiSquare(5.0);
    }

    @Override
    public void setParameter(int index, double value) {
        if (index != 0 || !(value >= 0.0)) {
            throw new IllegalArgumentException("Illegal value: " + index + " = " + value);
        }
        this.df = value;
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.df;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "DF";
        }
        throw new IllegalArgumentException("Not a parameter index: " + index);
    }

    @Override
    public int getNumParameters() {
        return 1;
    }

    @Override
    public String getName() {
        return "Chi Square";
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextChiSquare(this.df);
    }

    public String toString() {
        return "ChiSquare(" + this.df + ")";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

