/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.search.Cfci;
import edu.cmu.tetrad.search.Fci;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Tscfci;
import edu.cmu.tetrad.search.Tsfci;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.logging.Level;

public final class TetradCmd {
    private String graphFileName;
    private Graph graph;
    private String dataFileName;
    private String dataTypeName;
    private String covFileName;
    private double significance;
    private DataSet data;
    private CovarianceMatrix covMatrix;
    private String algorithmName;
    private String knowledgeFileName;
    private Knowledge knowledge;
    private boolean inclInstEffect = false;
    private int depth = -1;
    private String outputStreamPath;
    private PrintStream out = System.out;
    private String seed;

    public TetradCmd(String[] argv) {
        this.readArguments(new StringArrayTokenizer(argv));
        this.setOutputStream();
        this.runAlgorithm();
        if (this.out != System.out) {
            this.out.close();
        }
    }

    private void setOutputStream() {
        if (this.outputStreamPath == null) {
            return;
        }
        File file = new File(this.outputStreamPath);
        try {
            this.out = new PrintStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Could not create a logfile at location " + file.getAbsolutePath());
        }
    }

    private void readArguments(StringArrayTokenizer tokenizer) {
        while (tokenizer.hasToken()) {
            String argument;
            String token = tokenizer.nextToken();
            if ("-graph".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("'-graph' tag must be followed by an argument indicating the path to the graph file.");
                }
                this.graphFileName = argument;
                this.loadGraph();
                continue;
            }
            if ("-data".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("'-data' tag must be followed by an argument indicating the path to the data file.");
                }
                this.dataFileName = argument;
                continue;
            }
            if ("-datatype".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("'-datatype' tag must be followed by either 'discrete' or 'continuous'.");
                }
                this.dataTypeName = argument;
                this.loadData();
                continue;
            }
            if ("-covariance".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("'-covariance' tag must be followed by an argument indicating the path to the covariance matrix file.");
                }
                this.covFileName = argument;
                this.loadCov();
                continue;
            }
            if ("-significance".equalsIgnoreCase(token)) {
                try {
                    argument = tokenizer.nextToken();
                    if (argument.startsWith("-") || argument == null) {
                        throw new NumberFormatException();
                    }
                    this.significance = Double.parseDouble(argument);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("'-significance' must be followed by a number in the range [0.0, 1.0].");
                }
            }
            if ("-algorithm".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("'-algorithm' tag must be followed by an algorithm name.");
                }
                this.algorithmName = argument;
                continue;
            }
            if ("-knowledge".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("'-knowledge' tag must be followed by an argument indicating the path to the knowledge file.");
                }
                this.knowledgeFileName = argument;
                this.loadKnowledge();
                continue;
            }
            if ("-inclInstEffect".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("'-inclInstEffect' tag must be followed by 'true' or 'false'.");
                }
                this.inclInstEffect = Boolean.parseBoolean(argument);
                continue;
            }
            if ("-depth".equalsIgnoreCase(token)) {
                try {
                    argument = tokenizer.nextToken();
                    if (argument.startsWith("-") || argument == null) {
                        throw new NumberFormatException();
                    }
                    this.depth = Integer.parseInt(argument);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("'depth' must be followed by an integer >= -1 (-1 means unlimited).");
                }
            }
            if ("-outfile".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("'-outfile' tag must be followed  by an argument indicating the path to the data file.");
                }
                this.outputStreamPath = argument;
                continue;
            }
            if ("-seed".equalsIgnoreCase(token)) {
                argument = tokenizer.nextToken();
                if (argument.startsWith("-") || argument == null) {
                    throw new IllegalArgumentException("-seed must be followed by an integer (long) value.");
                }
                this.seed = argument;
                continue;
            }
            throw new IllegalArgumentException("Unexpected argument: " + token);
        }
    }

    private void loadGraph() {
        try {
            String inputFileName = this.graphFileName;
            FileReader inputFileReader = new FileReader(inputFileName);
            BufferedReader inputStream = new BufferedReader(inputFileReader);
            String graph1 = inputStream.readLine();
            Graph graph = GraphConverter.convert(graph1);
            System.out.println(graph);
            this.graph = graph;
        }
        catch (IOException e) {
            System.out.println("IOException:");
            e.printStackTrace();
        }
    }

    private void loadData() {
        if (this.dataFileName == null) {
            throw new IllegalStateException("No data file was specified.");
        }
        if (this.dataTypeName == null) {
            throw new IllegalStateException("No data type (continuous/discrete) was specified.");
        }
        this.out.println("Loading data from " + this.dataFileName + ".");
        if ("continuous".equalsIgnoreCase(this.dataTypeName)) {
            this.out.println("Data type = continuous.");
        } else if ("discrete".equalsIgnoreCase(this.dataTypeName)) {
            this.out.println("Data type = discrete.");
        } else {
            throw new IllegalStateException("Data type was expected to be either 'continuous' or 'discrete'.");
        }
        File file = new File(this.dataFileName);
        try {
            try {
                DataReader reader = new DataReader();
                reader.setMaxIntegralDiscrete(5);
                DataSet data = reader.parseTabular(file);
                this.out.println("# variables = " + data.getNumColumns() + ", # cases = " + data.getNumRows());
                this.data = data;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Could not load file at " + file.getAbsolutePath());
        }
    }

    private void loadCov() {
        if (this.covFileName == null) {
            throw new IllegalStateException("No covariance matrix file was specified.");
        }
        this.out.println("Loading covariance matrix from " + this.covFileName + ".");
        File file = new File(this.covFileName);
        try {
            try {
                DataReader reader = new DataReader();
                CovarianceMatrix covMatrix = reader.parseCovariance(file);
                this.out.println("# variables = " + covMatrix.getVariables().size() + ", # cases = " + covMatrix.getSampleSize());
                this.covMatrix = covMatrix;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Could not load file at " + file.getAbsolutePath());
        }
    }

    private void loadKnowledge() {
        try {
            String str;
            String inputFileName = this.knowledgeFileName;
            FileReader inputFileReader = new FileReader(inputFileName);
            BufferedReader inputStream = new BufferedReader(inputFileReader);
            Knowledge knowledge = new Knowledge();
            while ((str = inputStream.readLine()) != null) {
                StringTokenizer str1 = new StringTokenizer(str);
                int tier = Integer.parseInt(str1.nextToken());
                String var = str1.nextToken();
                knowledge.addToTier(tier, var);
            }
            System.out.println(knowledge);
            this.knowledge = knowledge;
        }
        catch (IOException e) {
            System.out.println("IOException:");
            e.printStackTrace();
        }
    }

    private void runAlgorithm() {
        try {
            TetradLogger.getInstance().addOutputStream(System.out);
            TetradLogger.getInstance().setForceLog(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if ("fci".equalsIgnoreCase(this.algorithmName)) {
            this.runFci();
        } else if ("cfci".equalsIgnoreCase(this.algorithmName)) {
            this.runCfci();
        } else if ("tsfci".equalsIgnoreCase(this.algorithmName)) {
            this.runTsFci();
        } else if ("tscfci".equalsIgnoreCase(this.algorithmName)) {
            this.runTsCfci();
        } else {
            TetradLogger.getInstance().reset();
            TetradLogger.getInstance().removeOutputStream(System.out);
            throw new IllegalStateException("No algorithm was specified.");
        }
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    private void runFci() {
        IndependenceTest independence;
        if (this.data == null & this.graph == null & this.covMatrix == null) {
            throw new IllegalStateException("Data or Graph did not load correctly.");
        }
        if (this.graph != null) {
            independence = new IndTestDSep(this.graph);
        } else if (this.covMatrix != null) {
            CorrelationMatrix corrMatrix = new CorrelationMatrix(this.covMatrix);
            independence = new IndTestFisherZ(corrMatrix, this.significance);
        } else if (this.data.isDiscrete()) {
            independence = new IndTestGSquare(this.data, this.significance);
        } else if (this.data.isContinuous()) {
            independence = new IndTestFisherZ(this.data, this.significance);
        } else {
            throw new IllegalStateException("Data must be either continuous or discrete.");
        }
        Fci fci = new Fci(independence);
        if (this.knowledge != null) {
            fci.setKnowledge(this.knowledge);
        }
        Graph resultGraph = fci.search();
        this.out.println(resultGraph.getNumNodes());
        this.out.println(resultGraph.getNumEdges());
        this.out.println(resultGraph.getNodes());
        this.out.println(resultGraph.getEdges());
    }

    private void runCfci() {
        IndependenceTest independence;
        if (this.data == null & this.graph == null & this.covMatrix == null) {
            throw new IllegalStateException("Data or Graph did not load correctly.");
        }
        if (this.graph != null) {
            independence = new IndTestDSep(this.graph);
        } else if (this.covMatrix != null) {
            CorrelationMatrix corrMatrix = new CorrelationMatrix(this.covMatrix);
            independence = new IndTestFisherZ(corrMatrix, this.significance);
        } else if (this.data.isDiscrete()) {
            independence = new IndTestGSquare(this.data, this.significance);
        } else if (this.data.isContinuous()) {
            independence = new IndTestFisherZ(this.data, this.significance);
        } else {
            throw new IllegalStateException("Data must be either continuous or discrete.");
        }
        Cfci cfci = new Cfci(independence);
        if (this.knowledge != null) {
            cfci.setKnowledge(this.knowledge);
        }
        Graph resultGraph = cfci.search();
        this.out.println(resultGraph.getNumNodes());
        this.out.println(resultGraph.getNumEdges());
        this.out.println(resultGraph.getNodes());
        this.out.println(resultGraph.getEdges());
    }

    private void runTsFci() {
        IndependenceTest independence;
        if (this.data == null & this.graph == null & this.covMatrix == null) {
            throw new IllegalStateException("Data or Graph did not load correctly.");
        }
        if (this.graph != null) {
            independence = new IndTestDSep(this.graph);
        } else if (this.covMatrix != null) {
            CorrelationMatrix corrMatrix = new CorrelationMatrix(this.covMatrix);
            independence = new IndTestFisherZ(corrMatrix, this.significance);
        } else if (this.data.isDiscrete()) {
            independence = new IndTestGSquare(this.data, this.significance);
        } else if (this.data.isContinuous()) {
            independence = new IndTestFisherZ(this.data, this.significance);
        } else {
            throw new IllegalStateException("Data must be either continuous or discrete.");
        }
        Tsfci tsfci = new Tsfci(independence);
        if (this.knowledge != null) {
            tsfci.setKnowledge(this.knowledge);
        }
        if (this.inclInstEffect) {
            tsfci.setNoInstantaneousEffect(false);
        } else {
            tsfci.setNoInstantaneousEffect(true);
        }
        Graph resultGraph = tsfci.search();
        this.out.println(resultGraph.getNumNodes());
        this.out.println(resultGraph.getNumEdges());
        this.out.println(resultGraph.getNodes());
        this.out.println(resultGraph.getEdges());
    }

    private void runTsCfci() {
        IndependenceTest independence;
        if (this.data == null & this.graph == null & this.covMatrix == null) {
            throw new IllegalStateException("Data did not load correctly.");
        }
        if (this.graph != null) {
            independence = new IndTestDSep(this.graph);
        } else if (this.covMatrix != null) {
            CorrelationMatrix corrMatrix = new CorrelationMatrix(this.covMatrix);
            independence = new IndTestFisherZ(corrMatrix, this.significance);
        } else if (this.data.isDiscrete()) {
            independence = new IndTestGSquare(this.data, this.significance);
        } else if (this.data.isContinuous()) {
            independence = new IndTestFisherZ(this.data, this.significance);
        } else {
            throw new IllegalStateException("Data must be either continuous or discrete.");
        }
        Tscfci tsfci = new Tscfci(independence);
        if (this.knowledge != null) {
            tsfci.setKnowledge(this.knowledge);
        }
        if (this.inclInstEffect) {
            tsfci.setNoInstantaneousEffect(false);
        } else {
            tsfci.setNoInstantaneousEffect(true);
        }
        Graph resultGraph = tsfci.search();
        this.out.println(resultGraph.getNumNodes());
        this.out.println(resultGraph.getNumEdges());
        this.out.println(resultGraph.getNodes());
        this.out.println(resultGraph.getEdges());
    }

    private Level convertToLevel(String level) {
        if ("severe".equalsIgnoreCase(level)) {
            return Level.SEVERE;
        }
        if ("warning".equalsIgnoreCase(level)) {
            return Level.WARNING;
        }
        if ("info".equalsIgnoreCase(level)) {
            return Level.INFO;
        }
        if ("config".equalsIgnoreCase(level)) {
            return Level.CONFIG;
        }
        if ("fine".equalsIgnoreCase(level)) {
            return Level.FINE;
        }
        if ("finer".equalsIgnoreCase(level)) {
            return Level.FINER;
        }
        if ("finest".equalsIgnoreCase(level)) {
            return Level.FINEST;
        }
        throw new IllegalArgumentException("Level must be one of 'Severe', 'Warning', 'Info', 'Config', 'Fine', 'Finer', 'Finest'.");
    }

    public static void main(String[] argv) {
        new TetradCmd(argv);
    }

    private static class StringArrayTokenizer {
        String[] tokens;
        int i = -1;

        public StringArrayTokenizer(String[] tokens) {
            this.tokens = tokens;
        }

        public boolean hasToken() {
            return this.i < this.tokens.length - 1;
        }

        public String nextToken() {
            return this.tokens[++this.i];
        }
    }
}

