/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetradapp.app.SessionEditorNode;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.util.WatchedProcess;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class RunSimulationAction
extends AbstractAction {
    private SessionEditorNode sessionEditorNode;

    public RunSimulationAction(SessionEditorNode sessionEditorNode) {
        super("Run Simulation...");
        this.sessionEditorNode = sessionEditorNode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.executeNode();
    }

    private void executeNode() {
        int ret;
        Object[] options;
        SessionEditorNode centeringComp;
        int selection;
        Set<SessionNode> children = this.sessionEditorNode.getChildren();
        boolean noEmptyChildren = true;
        for (SessionNode child : children) {
            if (child.getModel() != null) continue;
            noEmptyChildren = false;
            break;
        }
        if ((selection = JOptionPane.showOptionDialog(centeringComp = this.sessionEditorNode, "Executing this node will erase any model for this node, \nerase any models for any descendant nodes, and create \nnew models with new values using the default\nparameters for each node, which you may edit, and \nthe repetition numbers for each node, which you \nmay also edit. Continue?", "Warning", -1, 2, null, options = new Object[]{"Simulate", "Cancel"}, options[1])) == 0 && (ret = JOptionPane.showConfirmDialog(centeringComp, "Please confirm once more.", "Confirm", 2, 2)) != 0) {
            return;
        }
        if (selection == 0) {
            this.executeSessionNode(this.sessionEditorNode.getSessionNode(), true);
        }
    }

    private SessionEditorWorkbench getWorkbench() {
        Class<SessionEditorWorkbench> c = SessionEditorWorkbench.class;
        Container container = SwingUtilities.getAncestorOfClass(c, this.sessionEditorNode);
        return (SessionEditorWorkbench)container;
    }

    private void executeSessionNode(final SessionNode sessionNode, final boolean overwrite) {
        Window owner = (Window)this.sessionEditorNode.getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                SessionEditorWorkbench workbench = RunSimulationAction.this.getWorkbench();
                workbench.getSimulationStudy().execute(sessionNode, overwrite);
            }
        };
    }
}

