/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.SimulationStudy;
import edu.cmu.tetradapp.app.SessionEditorEdge;
import edu.cmu.tetradapp.app.SessionEditorNode;
import edu.cmu.tetradapp.app.SessionNodeConfig;
import edu.cmu.tetradapp.app.TetradApplicationConfig;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.model.SessionNodeWrapper;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.workbench.AbstractWorkbench;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.IDisplayEdge;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.MarshalledObject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;

public final class SessionEditorWorkbench
extends AbstractWorkbench {
    private String nextButtonType;
    private SimulationStudy simulationStudy;

    public SessionEditorWorkbench(SessionWrapper sessionWrapper) {
        super(sessionWrapper);
        sessionWrapper.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if ("name".equals(propertyName)) {
                    SessionEditorWorkbench.this.firePropertyChange("name", e.getOldValue(), e.getNewValue());
                }
            }
        });
        super.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("cloneMe".equals(evt.getPropertyName())) {
                    SessionNodeWrapper result;
                    SessionEditorNode sessionEditorNode = (SessionEditorNode)evt.getNewValue();
                    SessionNodeWrapper wrapper = (SessionNodeWrapper)sessionEditorNode.getModelNode();
                    try {
                        result = new MarshalledObject<SessionNodeWrapper>(wrapper).get();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        throw new IllegalStateException("Could not clone.");
                    }
                    SessionNodeWrapper clone = result;
                    List<SessionNodeWrapper> sessionElements = Collections.singletonList(clone);
                    Point point = EditorUtils.getTopLeftPoint(sessionElements);
                    point.translate(50, 50);
                    SessionWrapper sessionWrapper = (SessionWrapper)SessionEditorWorkbench.this.getGraph();
                    SessionEditorWorkbench.this.deselectAll();
                    sessionWrapper.pasteSubsession(sessionElements, point);
                    SessionEditorWorkbench.this.selectNode(clone);
                }
            }
        });
        List<Node> nodes = this.getGraph().getNodes();
        for (Node node1 : nodes) {
            SessionNodeWrapper node = (SessionNodeWrapper)node1;
            this.setRepetitionLabel(node.getSessionNode());
        }
        this.setRightClickPopupAllowed(false);
    }

    @Override
    public Node getNewModelNode() {
        if (this.nextButtonType == null) {
            throw new NullPointerException("Next button type must be a non-null string.");
        }
        String name = SessionEditorWorkbench.nextUniqueName(this.nextButtonType, this.getGraph());
        Class[] modelClasses = SessionEditorWorkbench.getModelClasses(this.nextButtonType);
        SessionNode newNode = new SessionNode(this.nextButtonType, name, modelClasses);
        SessionNodeWrapper nodeWrapper = new SessionNodeWrapper(newNode);
        nodeWrapper.setButtonType(this.nextButtonType);
        return nodeWrapper;
    }

    @Override
    public DisplayNode getNewDisplayNode(Node modelNode) {
        SessionNodeWrapper wrapper = (SessionNodeWrapper)modelNode;
        SessionEditorNode displayNode = new SessionEditorNode(wrapper, this.getSimulationStudy());
        displayNode.adjustToModel();
        return displayNode;
    }

    @Override
    public Edge getNewModelEdge(Node node1, Node node2) {
        return new Edge(node1, node2, Endpoint.TAIL, Endpoint.ARROW);
    }

    @Override
    public IDisplayEdge getNewTrackingEdge(DisplayNode node, Point mouseLoc) {
        return new SessionEditorEdge((SessionEditorNode)node, mouseLoc);
    }

    @Override
    public IDisplayEdge getNewDisplayEdge(Edge modelEdge) {
        Node modelNodeA = modelEdge.getNode1();
        Node modelNodeB = modelEdge.getNode2();
        DisplayNode displayNodeA = (DisplayNode)this.getModelToDisplay().get(modelNodeA);
        DisplayNode displayNodeB = (DisplayNode)this.getModelToDisplay().get(modelNodeB);
        if (displayNodeA == null || displayNodeB == null) {
            return null;
        }
        SessionEditorNode sessionEditorNodeA = (SessionEditorNode)displayNodeA;
        SessionEditorNode sessionEditorNodeB = (SessionEditorNode)displayNodeB;
        return new SessionEditorEdge(sessionEditorNodeA, sessionEditorNodeB, 0);
    }

    public void setSessionWrapper(SessionWrapper sessionWrapper) {
        super.setGraph(sessionWrapper);
        this.simulationStudy = null;
        sessionWrapper.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if ("name".equals(propertyName)) {
                    SessionEditorWorkbench.this.firePropertyChange("name", e.getOldValue(), e.getNewValue());
                }
            }
        });
    }

    public SimulationStudy getSimulationStudy() {
        if (this.simulationStudy == null) {
            Session session = ((SessionWrapper)this.getGraph()).getSession();
            this.simulationStudy = new SimulationStudy(session);
            this.simulationStudy.addSessionListener(new SessionAdapter(){

                @Override
                public void repetitionChanged(SessionEvent event) {
                    SessionEditorWorkbench.this.setRepetitionLabel(event.getNode());
                }
            });
        }
        return this.simulationStudy;
    }

    public String getNextButtonType() {
        if (this.nextButtonType == null) {
            throw new NullPointerException("getNextButtonType() was called when there was no next button type set.");
        }
        return this.nextButtonType;
    }

    public void setNextButtonType(String nextButtonType) {
        this.nextButtonType = nextButtonType;
    }

    public void pasteSubsession(List sessionElements, Point point) {
        SessionWrapper sessionWrapper = (SessionWrapper)this.getGraph();
        sessionWrapper.pasteSubsession(sessionElements, point);
        this.deselectAll();
        for (Object sessionElement : sessionElements) {
            if (!(sessionElement instanceof GraphNode)) continue;
            Node modelNode = (Node)sessionElement;
            this.selectNode(modelNode);
        }
        this.selectConnectingEdges();
    }

    public SessionWrapper getSessionWrapper() {
        return (SessionWrapper)this.getGraph();
    }

    @Override
    public void setName(String name) {
        this.getSimulationStudy().getSession().setName(name);
    }

    private void setRepetitionLabel(SessionNode sessionNode) {
        if (sessionNode == null) {
            throw new NullPointerException("Node must not be null.");
        }
        SessionNodeWrapper sessionNodeWrapper = this.getSessionNodeWrapper(sessionNode);
        int repetitions = sessionNode.getRepetition();
        if (repetitions > 1) {
            JLabel label = new JLabel("x " + repetitions);
            label.setForeground(Color.red);
            this.setNodeLabel(sessionNodeWrapper, label, 25, 25);
        } else {
            this.setNodeLabel(sessionNodeWrapper, null, 25, 25);
        }
    }

    private SessionNodeWrapper getSessionNodeWrapper(SessionNode sessionNode) {
        Set keySet = this.getModelToDisplay().keySet();
        for (Object key : keySet) {
            SessionNodeWrapper wrapper;
            if (!(key instanceof SessionNodeWrapper) || (wrapper = (SessionNodeWrapper)key).getSessionNode() != sessionNode) continue;
            return wrapper;
        }
        throw new NullPointerException("Session node wrapper not in map.");
    }

    private static Class[] getModelClasses(String nextButtonType) {
        TetradApplicationConfig config = TetradApplicationConfig.getInstance();
        SessionNodeConfig nodeConfig = config.getSessionNodeConfig(nextButtonType);
        if (nodeConfig == null) {
            throw new NullPointerException("There is no configuration for: " + nextButtonType);
        }
        return nodeConfig.getModels();
    }

    private static String nextUniqueName(String base, Graph graph) {
        if (base == null) {
            throw new NullPointerException("Base name must be non-null.");
        }
        int i = 0;
        block0: while (true) {
            String name = base + ++i;
            for (Node o : graph.getNodes()) {
                Node node = o;
                if (!node.getName().equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }
}

