/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.app.SessionNodeConfig;
import edu.cmu.tetradapp.app.SessionNodeModelConfig;
import edu.cmu.tetradapp.app.TetradApplicationConfig;
import edu.cmu.tetradapp.app.TetradHelpBroker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.help.BadIDException;
import javax.help.JHelp;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

final class SessionUtils {
    SessionUtils() {
    }

    public static void showPermissibleParentsDialog(Class modelClass, JComponent centeringComp, boolean warning, boolean onlyModel) {
        TetradApplicationConfig config = TetradApplicationConfig.getInstance();
        SessionNodeConfig nodeConfig = config.getSessionNodeConfig(modelClass);
        if (nodeConfig == null) {
            throw new NullPointerException("No configuration for model: " + modelClass);
        }
        SessionNodeModelConfig modelConfig = nodeConfig.getModelConfig(modelClass);
        String[][] parentCombinations = SessionUtils.possibleParentCombinations(modelClass);
        Box b = Box.createVerticalBox();
        if (onlyModel) {
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("There is only one module you can build at this point."));
            b1.add(Box.createHorizontalGlue());
            b.add(b1);
            b.add(Box.createVerticalStrut(14));
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Permissible parents (or parent combinations) for \"" + modelConfig.getName() + "\" are:"));
        b2.add(Box.createHorizontalStrut(20));
        b2.add(Box.createHorizontalGlue());
        b.add(b2);
        b.add(Box.createVerticalStrut(10));
        for (String[] parentCombination : parentCombinations) {
            Box b3 = Box.createHorizontalBox();
            b3.add(Box.createHorizontalStrut(20));
            b3.add(new JLabel("\u2022 "));
            if (parentCombination.length == 0) {
                JLabel label = new JLabel("--No Inputs--");
                label.setFont(new Font("Dialog", 2, 14));
                b3.add(label);
            } else {
                for (int j = 0; j < parentCombination.length; ++j) {
                    b3.add(new JLabel(parentCombination[j]));
                    if (j >= parentCombination.length - 1) continue;
                    b3.add(new JLabel(" + "));
                }
            }
            b3.add(Box.createHorizontalStrut(20));
            b3.add(Box.createHorizontalGlue());
            b.add(b3);
        }
        b.add(Box.createVerticalStrut(14));
        b.add(Box.createVerticalStrut(14));
        JScrollPane scroll = new JScrollPane(b);
        scroll.setBorder(null);
        int messageType = warning ? 2 : 1;
        JOptionPane.showMessageDialog(centeringComp, scroll, "Information on \"" + modelConfig.getName() + "\"", messageType);
    }

    public static String[][] possibleParentCombinations(Class modelClass) {
        LinkedList parentCombinations = new LinkedList();
        Constructor<?>[] constructors = modelClass.getConstructors();
        boolean foundNull = false;
        block0: for (Constructor<?> constructor : constructors) {
            List<Class<?>> _list = Arrays.asList(constructor.getParameterTypes());
            LinkedList parameterTypes = new LinkedList(_list);
            Iterator j = parameterTypes.iterator();
            while (j.hasNext()) {
                Class parameterType = (Class)j.next();
                if (!SessionModel.class.isAssignableFrom(parameterType) && !Params.class.isAssignableFrom(parameterType)) continue block0;
                String string = SessionUtils.getModelName(parameterType);
                if (string != null) continue;
                j.remove();
            }
            if (parameterTypes.isEmpty()) {
                foundNull = true;
                continue;
            }
            LinkedList<String> combination = new LinkedList<String>();
            for (Object e : parameterTypes) {
                Class parameterType = (Class)e;
                String descrip = SessionUtils.getModelName(parameterType);
                combination.add(descrip);
            }
            parentCombinations.add(combination);
        }
        if (foundNull) {
            parentCombinations.add(0, new LinkedList());
        }
        String[][] _parentCombinations = new String[parentCombinations.size()][];
        for (int i = 0; i < parentCombinations.size(); ++i) {
            List combination = (List)parentCombinations.get(i);
            _parentCombinations[i] = new String[combination.size()];
            for (int j = 0; j < combination.size(); ++j) {
                _parentCombinations[i][j] = (String)combination.get(j);
            }
        }
        return _parentCombinations;
    }

    private static String getModelName(Class model) {
        TetradApplicationConfig tetradConfig = TetradApplicationConfig.getInstance();
        SessionNodeConfig config = tetradConfig.getSessionNodeConfig(model);
        if (config == null) {
            return null;
        }
        SessionNodeModelConfig modelConfig = config.getModelConfig(model);
        return modelConfig.getName();
    }

    private static void launchHelpForName(String helpName, String descrip) {
        JHelp jhelp = new JHelp(TetradHelpBroker.getInstance().getHelpSet());
        JComponent centeringComp = JOptionUtils.centeringComp();
        try {
            jhelp.setCurrentID(helpName);
        }
        catch (BadIDException e1) {
            System.out.println("Expected ID = " + helpName);
        }
        jhelp.setPreferredSize(new Dimension(600, 500));
        Container owner = centeringComp.getTopLevelAncestor();
        JDialog dialog = owner instanceof Dialog ? new JDialog((Dialog)owner, "Help for \"" + descrip + "\"", true) : new JDialog((Frame)owner, "Help for \"" + descrip + "\"", true);
        dialog.setResizable(true);
        dialog.getContentPane().add((Component)jhelp, "Center");
        dialog.pack();
        dialog.setSize(new Dimension(900, 600));
        dialog.setLocationRelativeTo(centeringComp);
        dialog.setVisible(true);
    }
}

