/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetradapp.app.SessionNodeConfig;
import edu.cmu.tetradapp.app.TetradApplicationConfig;
import edu.cmu.tetradapp.model.SessionNodeWrapper;
import edu.cmu.tetradapp.model.SessionWrapper;

final class SessionWrappers {
    SessionWrappers() {
    }

    public static Node addNode(SessionWrapper sessionWrapper, String nodeType, String nodeName, int centerX, int centerY) {
        SessionNodeWrapper node = SessionWrappers.getNewModelNode(nodeType, nodeName);
        node.setCenter(centerX, centerY);
        sessionWrapper.addNode(node);
        return node;
    }

    public static void addEdge(SessionWrapper sessionWrapper, String nodeName1, String nodeName2) {
        Node node1 = sessionWrapper.getNode(nodeName1);
        Node node2 = sessionWrapper.getNode(nodeName2);
        if (node1 == null) {
            throw new RuntimeException("There was no node by name nodeName1 in the session wrapper: " + nodeName1);
        }
        if (node2 == null) {
            throw new RuntimeException("There was no node by name nodeName2 in the session wrapper: " + nodeName2);
        }
        SessionNodeWrapper nodeWrapper1 = (SessionNodeWrapper)node1;
        SessionNodeWrapper nodeWrapper2 = (SessionNodeWrapper)node2;
        Edge edge = new Edge(nodeWrapper1, nodeWrapper2, Endpoint.TAIL, Endpoint.ARROW);
        sessionWrapper.addEdge(edge);
    }

    private static SessionNodeWrapper getNewModelNode(String nextButtonType, String name) {
        if (nextButtonType == null) {
            throw new NullPointerException("Next button type must be a non-null string.");
        }
        Class[] modelClasses = SessionWrappers.getModelClasses(nextButtonType);
        SessionNode newNode = new SessionNode(nextButtonType, name, modelClasses);
        SessionNodeWrapper nodeWrapper = new SessionNodeWrapper(newNode);
        nodeWrapper.setButtonType(nextButtonType);
        return nodeWrapper;
    }

    private static Class[] getModelClasses(String nextButtonType) {
        TetradApplicationConfig config = TetradApplicationConfig.getInstance();
        SessionNodeConfig nodeConfig = config.getSessionNodeConfig(nextButtonType);
        if (nodeConfig == null) {
            throw new NullPointerException("There is no configuration for: " + nextButtonType);
        }
        return nodeConfig.getModels();
    }
}

