/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetradapp.app.SessionDisplayComp;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class StdDisplayComp
extends JComponent
implements SessionDisplayComp {
    private static final Color NO_MODEL_COLOR = new Color(214, 214, 214);
    private static final Color HAS_MODEL_COLOR = DisplayNodeUtils.getNodeFillColor();
    private Color unselectedColor = NO_MODEL_COLOR;
    private static final Font SMALL_FONT = new Font("Dialog", 1, 10);
    private JLabel nameLabel = new JLabel(" ");
    private JLabel acronymLabel = new JLabel("No model");
    private boolean selected;
    private Image image;

    public StdDisplayComp(String imagePath) {
        this.image = ImageUtils.getImage(this, imagePath);
        this.layoutComponents();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setBorder(null);
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.nameLabel.setText(name);
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronymLabel.setText(acronym);
        this.layoutComponents();
    }

    public Shape getShape() {
        return new Rectangle2D.Double(0.0, 0.0, this.getSize().width - 1, this.getSize().height - 1);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getShape().contains(x, y);
    }

    @Override
    public void setHasModel(boolean hasModel) {
        this.unselectedColor = hasModel ? HAS_MODEL_COLOR : NO_MODEL_COLOR;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.isSelected() ? DisplayNodeUtils.getNodeSelectedFillColor() : this.unselectedColor);
        g2.fill(this.getShape());
        g2.setColor(this.isSelected() ? DisplayNodeUtils.getNodeSelectedEdgeColor() : DisplayNodeUtils.getNodeEdgeColor());
        g2.draw(this.getShape());
        super.paint(g);
    }

    private void layoutComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setBackground(DisplayNodeUtils.getNodeFillColor());
        this.setFont(DisplayNodeUtils.getFont());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel(new ImageIcon(this.image)));
        b1.add(Box.createHorizontalGlue());
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(Box.createHorizontalStrut(5));
        b2.add(this.nameLabel);
        b2.add(Box.createHorizontalStrut(5));
        b2.add(Box.createHorizontalGlue());
        b.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(Box.createHorizontalGlue());
        b3.add(Box.createHorizontalStrut(5));
        this.acronymLabel.setFont(SMALL_FONT);
        b3.add(this.acronymLabel);
        b3.add(Box.createHorizontalStrut(5));
        b3.add(Box.createHorizontalGlue());
        b.add(b3);
        b.add(Box.createRigidArea(new Dimension(60, 0)));
        this.add((Component)b, "Center");
        this.revalidate();
        this.repaint();
    }
}

