/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.util.DefaultTetradLoggerConfig;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradLoggerConfig;
import edu.cmu.tetradapp.app.DefaultModelChooser;
import edu.cmu.tetradapp.app.ModelChooser;
import edu.cmu.tetradapp.app.SessionDisplayComp;
import edu.cmu.tetradapp.app.SessionNodeConfig;
import edu.cmu.tetradapp.app.SessionNodeModelConfig;
import edu.cmu.tetradapp.app.StdDisplayComp;
import edu.cmu.tetradapp.editor.ParameterEditor;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;

public class TetradApplicationConfig {
    private static final TetradApplicationConfig instance = new TetradApplicationConfig();
    private static final String PATH = "/resources/configuration.xml";
    private Map<String, SessionNodeConfig> configs;
    private Map<Class, SessionNodeConfig> classMap = new HashMap<Class, SessionNodeConfig>();

    public TetradApplicationConfig() {
        InputStream stream = this.getClass().getResourceAsStream(PATH);
        Builder builder = new Builder(true);
        try {
            Document doc = builder.build(stream);
            this.configs = TetradApplicationConfig.buildConfiguration(doc.getRootElement());
            for (SessionNodeConfig config : this.configs.values()) {
                Class[] models;
                for (Class model : models = config.getModels()) {
                    if (this.classMap.containsKey(model)) {
                        throw new IllegalStateException("Model " + model + " has two configuratoins");
                    }
                    this.classMap.put(model, config);
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Chould not load configuration", ex);
        }
    }

    public static TetradApplicationConfig getInstance() {
        return instance;
    }

    public SessionNodeConfig getSessionNodeConfig(String id) {
        return this.configs.get(id);
    }

    public SessionNodeConfig getSessionNodeConfig(Class model) {
        return this.classMap.get(model);
    }

    private static Map<String, SessionNodeConfig> buildConfiguration(Element root) {
        Elements elements = root.getChildElements();
        ClassLoader loader = TetradApplicationConfig.getClassLoader();
        HashMap<String, SessionNodeConfig> configs = new HashMap<String, SessionNodeConfig>();
        for (int i = 0; i < elements.size(); ++i) {
            Element node = elements.get(i);
            String id = node.getAttributeValue("id");
            DefaultNodeConfig nodeConfig = new DefaultNodeConfig(id);
            Elements nodeElements = node.getChildElements();
            for (int k = 0; k < nodeElements.size(); ++k) {
                String value;
                Element child = nodeElements.get(k);
                if ("models".equals(child.getQualifiedName())) {
                    nodeConfig.setSessionNodeModelConfig(TetradApplicationConfig.buildModelConfigs(child));
                } else if ("display-component".equals(child.getQualifiedName())) {
                    String image = child.getAttributeValue("image");
                    value = TetradApplicationConfig.getValue(child);
                    Class compClass = value == null ? null : TetradApplicationConfig.loadClass(loader, value);
                    nodeConfig.setDisplayComp(image, compClass);
                } else if ("model-chooser".equals(child.getQualifiedName())) {
                    String title = child.getAttributeValue("title");
                    value = TetradApplicationConfig.getValue(child);
                    Class chooserClass = value == null ? null : TetradApplicationConfig.loadClass(loader, value);
                    nodeConfig.setChooser(title, chooserClass);
                } else if ("tooltip".equals(child.getQualifiedName())) {
                    nodeConfig.setTooltipText(child.getValue());
                } else {
                    throw new IllegalStateException("Unknown element " + child.getQualifiedName());
                }
                configs.put(id, nodeConfig);
            }
        }
        return configs;
    }

    private static String getValue(Element value) {
        String v = value.getValue();
        if (v != null && v.length() == 0) {
            return null;
        }
        return v;
    }

    private static List<SessionNodeModelConfig> buildModelConfigs(Element models) {
        Elements modelElements = models.getChildElements();
        LinkedList<SessionNodeModelConfig> configs = new LinkedList<SessionNodeModelConfig>();
        ClassLoader loader = TetradApplicationConfig.getClassLoader();
        for (int i = 0; i < modelElements.size(); ++i) {
            Element model = modelElements.get(i);
            String name = model.getAttributeValue("name");
            String acronym = model.getAttributeValue("acronym");
            String help = model.getAttributeValue("help");
            String category = model.getAttributeValue("category");
            Class modelClass = null;
            Class editorClass = null;
            Class paramsClass = null;
            Class paramsEditorClass = null;
            TetradLoggerConfig loggerConfig = null;
            Elements elements = model.getChildElements();
            for (int k = 0; k < elements.size(); ++k) {
                Element element = elements.get(k);
                if ("model-class".equals(element.getQualifiedName())) {
                    modelClass = TetradApplicationConfig.loadClass(loader, element.getValue());
                    continue;
                }
                if ("editor-class".equals(element.getQualifiedName())) {
                    editorClass = TetradApplicationConfig.loadClass(loader, element.getValue());
                    continue;
                }
                if ("params-class".equals(element.getQualifiedName())) {
                    paramsClass = TetradApplicationConfig.loadClass(loader, element.getValue());
                    continue;
                }
                if ("params-editor-class".equals(element.getQualifiedName())) {
                    paramsEditorClass = TetradApplicationConfig.loadClass(loader, element.getValue());
                    continue;
                }
                if ("logger".equals(element.getQualifiedName())) {
                    loggerConfig = TetradApplicationConfig.configureLogger(element);
                    continue;
                }
                throw new IllegalStateException("Unknown element: " + element.getQualifiedName());
            }
            if (loggerConfig != null) {
                TetradLogger.getInstance().addTetradLoggerConfig(modelClass, loggerConfig);
            }
            DefaultModelConfig config = new DefaultModelConfig(modelClass, paramsClass, paramsEditorClass, editorClass, name, acronym, help, category);
            configs.add(config);
        }
        return configs;
    }

    private static TetradLoggerConfig configureLogger(Element logger) {
        Elements elements = logger.getChildElements();
        LinkedList<TetradLoggerConfig.Event> events = new LinkedList<TetradLoggerConfig.Event>();
        LinkedList<String> defaultLog = new LinkedList<String>();
        for (int i = 0; i < elements.size(); ++i) {
            Element event = elements.get(i);
            String eventId = event.getAttributeValue("id");
            String description = event.getAttributeValue("description");
            String defaultOption = event.getAttributeValue("default");
            if (defaultOption != null && defaultOption.equals("on")) {
                defaultLog.add(eventId);
            }
            events.add(new DefaultTetradLoggerConfig.DefaultEvent(eventId, description));
        }
        DefaultTetradLoggerConfig config = new DefaultTetradLoggerConfig(events);
        for (String event : defaultLog) {
            config.setEventActive(event, true);
        }
        return config;
    }

    private static SessionDisplayComp createDisplayComp(String image, Class compClass) {
        if (compClass == null) {
            return new StdDisplayComp(image);
        }
        try {
            if (image == null) {
                return (SessionDisplayComp)compClass.newInstance();
            }
            Constructor constructor = compClass.getConstructor(String.class);
            return (SessionDisplayComp)constructor.newInstance(image);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create display component", ex);
        }
    }

    private static Class loadClass(ClassLoader loader, String className) {
        try {
            return loader.loadClass(className.trim());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class name " + className + " could not be found", e);
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = TetradApplicationConfig.class.getClassLoader();
        }
        if (loader == null) {
            throw new NullPointerException("Class loader was null could not load handler");
        }
        return loader;
    }

    private static String pruneTooltipText(String text) {
        int size = text.length();
        StringBuilder builder = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                builder.append(c);
                while (i < size - 1 && c == ' ') {
                    c = text.charAt(++i);
                }
            }
            if (c == '\n') continue;
            builder.append(c);
        }
        return builder.toString().trim();
    }

    private static boolean matches(Class[] params, Object[] arguments) {
        if (params.length != arguments.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            Class param = params[i];
            if (param.isInstance(arguments[i])) continue;
            return false;
        }
        return true;
    }

    private static class DefaultModelConfig
    implements SessionNodeModelConfig {
        private Class model;
        private Class params;
        private Class paramsEditor;
        private Class editor;
        private String name;
        private String acronym;
        private String help;
        private String category;

        public DefaultModelConfig(Class model, Class params, Class paramsEditor, Class editor, String name, String acronym, String help, String category) {
            if (model == null || editor == null || name == null || acronym == null) {
                throw new NullPointerException("Values must not be null");
            }
            this.model = model;
            this.params = params;
            this.paramsEditor = paramsEditor;
            this.editor = editor;
            this.name = name;
            this.help = help;
            this.acronym = acronym;
            this.category = category;
        }

        @Override
        public String getHelpIdentifier() {
            return this.help;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public Class getModel() {
            return this.model;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAcronym() {
            if (this.acronym == null) {
                System.out.println();
            }
            return this.acronym;
        }

        @Override
        public JPanel getEditorInstance(Object[] arguments) {
            Class[] parameters = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                parameters[i] = arguments[i].getClass();
            }
            Constructor<Object> constructor = null;
            try {
                constructor = this.editor.getConstructor(parameters);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (constructor == null) {
                Constructor<?>[] constructors;
                for (Constructor<?> _constructor : constructors = this.editor.getConstructors()) {
                    Class[] params = _constructor.getParameterTypes();
                    if (!TetradApplicationConfig.matches(params, arguments)) continue;
                    constructor = _constructor;
                    break;
                }
            }
            if (constructor == null) {
                throw new NullPointerException("Could not find constructor in " + this.editor + " for model: " + this.model);
            }
            try {
                return (JPanel)constructor.newInstance(arguments);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not construct editor", ex);
            }
        }

        @Override
        public Params getParametersInstance() {
            if (this.params != null) {
                try {
                    return (Params)this.params.newInstance();
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("Model params doesn't implement Params", e);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error instantiating params, must be empty constructor", e);
                }
            }
            return null;
        }

        @Override
        public ParameterEditor getParameterEditorInstance() {
            if (this.paramsEditor != null) {
                try {
                    return (ParameterEditor)this.paramsEditor.newInstance();
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("Params editor must implement ParameterEditor", e);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error intatiating params editor, must have empty constructor", e);
                }
            }
            return null;
        }
    }

    private static class DefaultNodeConfig
    implements SessionNodeConfig {
        private Map<Class, SessionNodeModelConfig> modelMap = new HashMap<Class, SessionNodeModelConfig>();
        private List<SessionNodeModelConfig> models;
        private String image;
        private Class compClass;
        private String tooltip;
        private String id;
        private String chooserTitle;
        private Class chooserClass;

        public DefaultNodeConfig(String id) {
            if (id == null) {
                throw new NullPointerException("The given id must not be null");
            }
            this.id = id;
        }

        @Override
        public SessionNodeModelConfig getModelConfig(Class model) {
            return this.modelMap.get(model);
        }

        @Override
        public Class[] getModels() {
            Class[] modelClasses = new Class[this.models.size()];
            for (int i = 0; i < this.models.size(); ++i) {
                modelClasses[i] = this.models.get(i).getModel();
            }
            return modelClasses;
        }

        @Override
        public String getTooltipText() {
            return this.tooltip;
        }

        @Override
        public ModelChooser getModelChooserInstance(SessionNode sessionNode) {
            ModelChooser chooser;
            if (this.chooserClass == null) {
                chooser = new DefaultModelChooser();
            } else {
                try {
                    chooser = (ModelChooser)this.chooserClass.newInstance();
                    chooser.setSessionNode(sessionNode);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Model chooser must have empty constructor", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Model chooser must have empty constructor", e);
                }
            }
            chooser.setSessionNode(sessionNode);
            chooser.setNodeId(this.id);
            chooser.setTitle(this.chooserTitle);
            chooser.setModelConfigs(new ArrayList<SessionNodeModelConfig>(this.models));
            chooser.setup();
            return chooser;
        }

        @Override
        public SessionDisplayComp getSessionDisplayCompInstance() {
            return TetradApplicationConfig.createDisplayComp(this.image, this.compClass);
        }

        private void setChooser(String title, Class chooserClass) {
            if (title == null) {
                throw new NullPointerException("The chooser title must not be null");
            }
            this.chooserTitle = title;
            this.chooserClass = chooserClass;
        }

        private void setTooltipText(String text) {
            if (text == null) {
                throw new NullPointerException("The give toolip text must not be null");
            }
            this.tooltip = TetradApplicationConfig.pruneTooltipText(text);
        }

        private void setDisplayComp(String image, Class comp) {
            if (image == null && comp == null) {
                throw new NullPointerException("Must have an image or a display component class defined");
            }
            this.image = image;
            this.compClass = comp;
        }

        private void setSessionNodeModelConfig(List<SessionNodeModelConfig> configs) {
            this.models = configs;
            for (SessionNodeModelConfig config : configs) {
                this.modelMap.put(config.getModel(), config);
            }
        }
    }
}

