/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradLoggerConfig;
import edu.cmu.tetrad.util.TetradLoggerEvent;
import edu.cmu.tetrad.util.TetradLoggerListener;
import edu.cmu.tetradapp.app.SaveSessionAsAction;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.app.TetradInternalFrame;
import edu.cmu.tetradapp.app.TetradLogArea;
import edu.cmu.tetradapp.app.TetradMenuBar;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.TetradMetadata;
import edu.cmu.tetradapp.util.DesktopControllable;
import edu.cmu.tetradapp.util.EditorWindowIndirectRef;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import edu.cmu.tetradapp.util.SessionWrapperIndirectRef;
import edu.cmu.tetradapp.util.TetradMetadataIndirectRef;
import edu.cmu.tetradapp.util.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.DefaultDesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public final class TetradDesktop
extends JPanel
implements DesktopControllable,
PropertyChangeListener {
    private static final int MARGIN = 10;
    private final JDesktopPane desktopPane;
    private final List sessionNodeKeys;
    private final Map<SessionEditor, JInternalFrame> framesMap = new HashMap<SessionEditor, JInternalFrame>();
    private final Map<SessionWrapper, TetradMetadata> metadataMap = new HashMap<SessionWrapper, TetradMetadata>();
    private TetradLogArea logArea;

    public TetradDesktop() {
        this.setBackground(new Color(204, 204, 204));
        this.sessionNodeKeys = new ArrayList();
        this.desktopPane = new JDesktopPane();
        this.setLayout(new BorderLayout());
        this.desktopPane.setDesktopManager(new DefaultDesktopManager());
        this.desktopPane.setBorder(new BevelBorder(1));
        this.desktopPane.addPropertyChangeListener(this);
        this.setupDesktop();
        Preferences.userRoot().putBoolean("displayLogging", false);
        TetradLogger.getInstance().addTetradLoggerListener(new LoggerListener());
    }

    @Override
    public void newSessionEditor() {
        String newName = this.getNewSessionName();
        SessionEditor editor = new SessionEditor(newName);
        this.addSessionEditor(editor);
    }

    @Override
    public void addSessionEditor(SessionEditorIndirectRef editorRef) {
        SessionEditor editor = (SessionEditor)editorRef;
        TetradInternalFrame frame = new TetradInternalFrame(null);
        frame.getContentPane().add(editor);
        this.framesMap.put(editor, frame);
        editor.addPropertyChangeListener(this);
        Dimension fullSize = this.desktopPane.getSize();
        int smallSize = Math.min(fullSize.width - 10, fullSize.height - 10);
        Dimension size = new Dimension(smallSize, smallSize);
        TetradDesktop.setGoodBounds(frame, this.desktopPane, size);
        this.desktopPane.add(frame);
        try {
            frame.setMaximum(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem setting frame to max: " + frame);
        }
        this.desktopPane.setLayer(frame, JLayeredPane.DEFAULT_LAYER);
        frame.moveToFront();
        frame.setTitle(editor.getName());
        frame.setVisible(true);
        this.setMainTitle(editor.getName());
    }

    @Override
    public void addEditorWindow(EditorWindowIndirectRef windowRef, int layer) {
        block6: {
            EditorWindow window = (EditorWindow)windowRef;
            Dimension desktopSize = this.desktopPane.getSize();
            Dimension preferredSize = window.getPreferredSize();
            Component source = window.getCenteringComp();
            Point convertedPoint = SwingUtilities.convertPoint(source.getParent(), source.getLocation(), this);
            int x = convertedPoint.x + source.getWidth() / 2 - preferredSize.width / 2;
            int y = convertedPoint.y - 25 + source.getHeight() / 2 - preferredSize.height / 2;
            int topMargin = 35;
            int bottomMargin = 35;
            int leftMargin = 150;
            int rightMargin = 25;
            if (x < leftMargin) {
                x = leftMargin;
            }
            if (y < topMargin) {
                y = topMargin;
            }
            int height = Math.min(preferredSize.height, this.getHeight() - topMargin - bottomMargin);
            int width = Math.min(preferredSize.width, this.getWidth() - leftMargin - rightMargin);
            if (x + width > this.getWidth() - rightMargin) {
                x = this.getWidth() - width - rightMargin;
            }
            if (y + height > this.getHeight() - bottomMargin) {
                y = this.getHeight() - height - bottomMargin;
            }
            window.setLocation(x, y);
            window.setPreferredSize(new Dimension(width, height));
            this.getDesktopPane().add(window);
            window.setLayer(layer);
            window.moveToFront();
            try {
                window.setVisible(true);
            }
            catch (Exception e) {
                if (e instanceof ClassCastException || e instanceof NullPointerException) break block6;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void closeFrontmostSession() {
        for (JInternalFrame frame : this.desktopPane.getAllFrames()) {
            if (!(frame instanceof EditorWindow)) continue;
            ((EditorWindow)frame).closeDialog();
        }
        JInternalFrame[] frames = this.desktopPane.getAllFramesInLayer(0);
        if (frames.length > 0) {
            frames[0].dispose();
            Map<SessionEditor, JInternalFrame> framesMap = this.framesMap;
            Iterator<SessionEditor> i = framesMap.keySet().iterator();
            while (i.hasNext()) {
                SessionEditor sessionEditor = i.next();
                JInternalFrame frame = framesMap.get(sessionEditor);
                if (frame != frames[0]) continue;
                i.remove();
                break;
            }
        }
    }

    @Override
    public void closeEmptySessions() {
        JInternalFrame[] frames;
        for (JInternalFrame frame : frames = this.desktopPane.getAllFramesInLayer(0)) {
            SessionEditor sessionEditor;
            SessionEditorWorkbench workbench;
            Graph graph;
            Component o = frame.getContentPane().getComponents()[0];
            if (!(o instanceof SessionEditor) || (graph = (workbench = (sessionEditor = (SessionEditor)o).getSessionWorkbench()).getGraph()).getNumNodes() != 0) continue;
            frame.dispose();
        }
    }

    @Override
    public boolean existsSessionByName(String filename) {
        JInternalFrame[] allFrames;
        for (JInternalFrame allFrame : allFrames = this.desktopPane.getAllFramesInLayer(0)) {
            SessionEditor editor;
            String editorName;
            Component o = allFrame.getContentPane().getComponents()[0];
            if (!(o instanceof SessionEditor) || !(editorName = (editor = (SessionEditor)o).getName()).equals(filename)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SessionEditor getFrontmostSessionEditor() {
        JInternalFrame[] allFrames = this.desktopPane.getAllFramesInLayer(0);
        if (allFrames.length == 0) {
            return null;
        }
        JInternalFrame frontmostFrame = allFrames[0];
        Component o = frontmostFrame.getContentPane().getComponents()[0];
        boolean isSessionEditor = o instanceof SessionEditor;
        return isSessionEditor ? (SessionEditor)o : null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("editorClosing".equals(name)) {
            for (int n = 0; n < this.sessionNodeKeys.size(); ++n) {
                if (!e.getNewValue().equals(this.sessionNodeKeys.get(n))) continue;
                this.sessionNodeKeys.remove(n);
            }
        } else if ("closeFrame".equals(e.getPropertyName())) {
            if (this.getFramesMap().containsKey(e.getSource())) {
                JInternalFrame frameObject;
                JInternalFrame frame = frameObject = this.getFramesMap().get(e.getSource());
                frame.setVisible(false);
                frame.dispose();
            }
        } else if ("name".equals(e.getPropertyName()) && this.getFramesMap().containsKey(e.getSource())) {
            JInternalFrame frameObject;
            JInternalFrame frame = frameObject = this.getFramesMap().get(e.getSource());
            String _name = (String)e.getNewValue();
            frame.setTitle(_name);
            this.setMainTitle(_name);
        }
    }

    private void setMainTitle(String name) {
        JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
        jFrame.setTitle(name + " - " + "Tetrad " + Version.currentViewableVersion().toString());
    }

    @Override
    public void exitProgram() {
        this.firePropertyChange("exitProgram", null, null);
    }

    public final JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    @Override
    public boolean closeAllSessions() {
        while (this.existsSession()) {
            int ret2;
            SessionEditor sessionEditor = this.getFrontmostSessionEditor();
            SessionEditorWorkbench workbench = sessionEditor.getSessionWorkbench();
            SessionWrapper wrapper = workbench.getSessionWrapper();
            if (!wrapper.isSessionChanged()) {
                this.closeFrontmostSession();
                continue;
            }
            String name = sessionEditor.getName();
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "Would you like to save the changes you made to " + name + "?", "Advise needed...", 1);
            if (ret == 1) {
                this.closeFrontmostSession();
                continue;
            }
            if (ret == 2) {
                return false;
            }
            SaveSessionAsAction action = new SaveSessionAsAction();
            action.actionPerformed(new ActionEvent(this, 1001, "Dummy close action"));
            if (!action.isSaved() && (ret2 = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This session was not saved. Close session and continue anyway?", "Advise needed...", 2)) == 2) {
                return false;
            }
            this.closeFrontmostSession();
        }
        return true;
    }

    @Override
    public void putMetadata(SessionWrapperIndirectRef sessionWrapperRef, TetradMetadataIndirectRef metadataRef) {
        SessionWrapper sessionWrapper = (SessionWrapper)sessionWrapperRef;
        TetradMetadata metadata = (TetradMetadata)metadataRef;
        this.metadataMap.put(sessionWrapper, metadata);
    }

    @Override
    public TetradMetadataIndirectRef getTetradMetadata(SessionWrapperIndirectRef sessionWrapperRef) {
        SessionWrapper sessionWrapper = (SessionWrapper)sessionWrapperRef;
        return this.metadataMap.get(sessionWrapper);
    }

    public void setDisplayLogging(boolean displayLogging) {
        if (displayLogging) {
            try {
                TetradLogger.getInstance().setNextOutputStream();
            }
            catch (IllegalStateException e2) {
                e2.printStackTrace();
                return;
            }
            this.logArea = new TetradLogArea(this);
        } else {
            if (this.logArea != null) {
                TetradLogger.getInstance().removeOutputStream(this.logArea.getOutputStream());
            }
            this.logArea = null;
        }
        this.setupDesktop();
        this.revalidate();
        this.repaint();
        Preferences.userRoot().putBoolean("displayLogging", displayLogging);
    }

    public boolean isDisplayLogging() {
        return this.logArea != null;
    }

    private int getDivider() {
        int height;
        if (this.desktopPane.getSize().height == 0) {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            height = size.height;
        } else {
            height = this.desktopPane.getSize().height;
        }
        return (int)((double)height * 0.8);
    }

    private void setupDesktop() {
        this.removeAll();
        if (this.logArea != null) {
            CompoundBorder border = new CompoundBorder(new EmptyBorder(0, 2, 0, 2), new BevelBorder(1));
            this.logArea.setBorder(border);
            JSplitPane splitPane = new JSplitPane(0, this.desktopPane, this.logArea);
            splitPane.setDividerSize(5);
            splitPane.setDividerLocation(this.getDivider());
            this.add((Component)splitPane, "Center");
        } else {
            this.add((Component)this.desktopPane, "Center");
        }
        TetradMenuBar menuBar = new TetradMenuBar(this);
        this.add((Component)menuBar, "North");
    }

    private boolean existsSession() {
        JInternalFrame[] allFrames;
        for (JInternalFrame allFrame : allFrames = this.desktopPane.getAllFramesInLayer(0)) {
            Component o = allFrame.getContentPane().getComponents()[0];
            if (!(o instanceof SessionEditor)) continue;
            return true;
        }
        return false;
    }

    private static void setGoodBounds(JInternalFrame frame, JDesktopPane desktopPane, Dimension desiredSize) {
        RandomUtil randomUtil = RandomUtil.getInstance();
        Dimension desktopSize = desktopPane.getSize();
        Dimension d = new Dimension(desiredSize);
        int tx = desktopSize.width - d.width;
        int ty = desktopSize.height - d.height;
        if (tx < 0) {
            tx = 0;
            d.width = desktopSize.width;
        } else {
            tx = (int)(randomUtil.nextDouble() * (double)tx);
        }
        if (ty < 0) {
            ty = 0;
            d.height = desktopSize.height;
        } else {
            ty = (int)(randomUtil.nextDouble() * (double)ty);
        }
        frame.setBounds(tx, ty, d.width, d.height);
    }

    private String getNewSessionName() {
        String name;
        String base = "untitled";
        String suffix = ".tet";
        int i = 0;
        block0: while (true) {
            name = base + ++i + suffix;
            for (SessionEditor _o : this.framesMap.keySet()) {
                SessionEditor sessionEditor;
                SessionEditorWorkbench workbench;
                SessionWrapper sessionWrapper;
                if (!(_o instanceof SessionEditor) || !(sessionWrapper = (workbench = (sessionEditor = _o).getSessionWorkbench()).getSessionWrapper()).getName().equals(name)) continue;
                continue block0;
            }
            break;
        }
        return name;
    }

    private Map<SessionEditor, JInternalFrame> getFramesMap() {
        return this.framesMap;
    }

    private boolean allowAutomaticLogPopup() {
        Boolean allowed = TetradLogger.getInstance().isAutomaticLogDisplayEnabled();
        if (allowed == null) {
            String message = "<html>Whenever Tetrad's logging features are active any generated log <br>output will be automatically display in Tetrad's log display. Would you like Tetrad<br>to continue to automatically open the log display window whenever there is logging output?</html>";
            int option = JOptionPane.showConfirmDialog(this, message, "Automatic Logging", 0);
            if (option == 1) {
                JOptionPane.showMessageDialog(this, "This feature can be enabled later by going to Logging>Setup Logging.");
            }
            TetradLogger.getInstance().setAutomaticLogDisplayEnabled(option == 0);
            return true;
        }
        return allowed;
    }

    private static class PositionListener
    extends ComponentAdapter {
        private PositionListener() {
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            Component component = evt.getComponent();
            Point point = component.getLocation();
            if (point.y < 0) {
                component.setBounds(point.x, 0, component.getWidth(), component.getHeight());
            }
        }
    }

    private class LoggerListener
    implements TetradLoggerListener {
        private LoggerListener() {
        }

        @Override
        public void configurationActived(TetradLoggerEvent evt) {
            TetradLoggerConfig config = evt.getTetradLoggerConfig();
            if (TetradLogger.getInstance().isLogging() && config.isActive() && TetradLogger.getInstance().isDisplayLogEnabled() && !TetradDesktop.this.isDisplayLogging() && TetradDesktop.this.allowAutomaticLogPopup()) {
                TetradDesktop.this.setDisplayLogging(true);
            }
        }

        @Override
        public void configurationDeactived(TetradLoggerEvent evt) {
        }
    }
}

