/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.app.TetradDesktop;
import edu.cmu.tetradapp.util.TextAreaOutputStream;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

class TetradLogArea
extends JPanel {
    private JTextArea textArea;
    private TextAreaOutputStream stream;
    private TetradDesktop desktop;

    public TetradLogArea(TetradDesktop tetradDesktop) {
        super(new BorderLayout());
        if (tetradDesktop == null) {
            throw new NullPointerException("The given desktop must not be null");
        }
        this.desktop = tetradDesktop;
        this.textArea = new JTextArea();
        if (TetradLogger.getInstance().isDisplayLogEnabled()) {
            this.stream = new TextAreaOutputStream(this.textArea);
            TetradLogger.getInstance().addOutputStream(this.stream);
        }
        JScrollPane pane = new JScrollPane(this.textArea);
        pane.setVerticalScrollBarPolicy(22);
        this.add((Component)this.createHeader(), "North");
        this.add((Component)pane, "Center");
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel();
        panel.setBackground(DisplayNodeUtils.getNodeFillColor());
        panel.setLayout(new BorderLayout());
        String path = TetradLogger.getInstance().getLatestFilePath();
        JLabel label = new JLabel(path == null ? "Logging to console (select Setup... from Logging menu)" : "  Logging to " + path);
        label.setFont(label.getFont().deriveFont(1, 12.0f));
        label.setBackground(DisplayNodeUtils.getNodeFillColor());
        label.setForeground(Color.WHITE);
        label.setOpaque(false);
        label.setBorder(new EmptyBorder(1, 2, 1, 2));
        Box b = Box.createHorizontalBox();
        b.add(label);
        b.add(Box.createHorizontalGlue());
        panel.add((Component)b, "Center");
        return panel;
    }

    private JButton getStyledButton(String name, JLabel label) {
        JButton stop = new JButton(name);
        stop.setFont(label.getFont().deriveFont(1, 12.0f));
        stop.setBackground(DisplayNodeUtils.getNodeFillColor());
        stop.setForeground(Color.WHITE);
        stop.setOpaque(true);
        stop.setBorder(new CompoundBorder(new EmptyBorder(2, 1, 2, 1), new MatteBorder(1, 1, 1, 1, Color.WHITE)));
        return stop;
    }

    public static JPanel buildSetupLoggingComponent() {
        JComboBox<String> activateCombo = new JComboBox<String>(new String[]{"No", "Yes"});
        activateCombo.setMaximumSize(activateCombo.getPreferredSize());
        activateCombo.setSelectedItem(TetradLogger.getInstance().isLogging() ? "Yes" : "No");
        activateCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                TetradLogger.getInstance().setLogging("Yes".equals(combo.getSelectedItem()));
            }
        });
        String saveLocation = TetradLogger.getInstance().getLoggingDirectory();
        final JTextField saveField = new JTextField(saveLocation);
        saveField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField field = (JTextField)e.getSource();
                try {
                    TetradLogger.getInstance().setLoggingDirectory(field.getText());
                }
                catch (IllegalArgumentException ex) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), ex.getMessage());
                }
            }
        });
        JButton chooseButton = new JButton(" ... ");
        chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String saveLocation = TetradLogger.getInstance().getLoggingDirectory();
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setCurrentDirectory(new File(saveLocation));
                int ret = chooser.showOpenDialog(JOptionUtils.centeringComp());
                if (ret == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    Preferences.userRoot().put("loggingDirectory", selectedFile.getAbsolutePath());
                    saveField.setText(selectedFile.getAbsolutePath());
                }
            }
        });
        chooseButton.setBorder(new EtchedBorder());
        JTextField prefixField = new JTextField(TetradLogger.getInstance().getLoggingFilePrefix());
        prefixField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                JTextField field = (JTextField)e.getSource();
                String text = field.getText();
                if (!text.matches("[a-zA-Z_]*")) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Spaces, numbers, and special characters (except underlines) in filenames will be ignored. You might want to delete them.", "Friendly Detail Message", 2);
                }
                TetradLogger.getInstance().setLoggingFilePrefix(text);
            }
        });
        Box b1 = Box.createVerticalBox();
        b1.add(TetradLogArea.createLogToBox());
        b1.add(Box.createVerticalStrut(5));
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Output Directory:"));
        b4.add(Box.createHorizontalGlue());
        b1.add(b4);
        Box b5 = Box.createHorizontalBox();
        b5.add(saveField);
        b5.add(chooseButton);
        b1.add(b5);
        b1.add(Box.createVerticalStrut(5));
        Box b6 = Box.createHorizontalBox();
        b6.add(new JLabel("File Prefix:"));
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        Box b7 = Box.createHorizontalBox();
        b7.add(prefixField);
        b1.add(b7);
        b1.add(Box.createVerticalStrut(5));
        Box b8 = Box.createHorizontalBox();
        b8.add(new JLabel("<html>Output will be written to sequentially numbered files, using the<br>given file prefix, in the given directory.</html>"));
        b1.add(b8);
        JPanel panel = new JPanel();
        panel.add((Component)b1, "Center");
        return panel;
    }

    private static Box createLogToBox() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Log output to: "));
        box.add(Box.createHorizontalStrut(5));
        JCheckBox fileCheckBox = new JCheckBox(" File ");
        fileCheckBox.setSelected(TetradLogger.getInstance().isFileLoggingEnabled());
        fileCheckBox.setHorizontalTextPosition(2);
        fileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                TetradLogger.getInstance().setFileLoggingEnabled(box.isSelected());
            }
        });
        JCheckBox textareaCheckBox = new JCheckBox(" Log Display ");
        textareaCheckBox.setSelected(TetradLogger.getInstance().isDisplayLogEnabled());
        textareaCheckBox.setHorizontalTextPosition(2);
        textareaCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                TetradLogger.getInstance().setDisplayLogEnabled(box.isSelected());
            }
        });
        box.add(fileCheckBox);
        box.add(textareaCheckBox);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JPanel viewLogsInstructions() {
        JPanel panel = new JPanel();
        JLabel label1 = new JLabel("<html>The best advise for viewing your logs is to go to the log output directory<br>and open them using a text editor, like WordPad, or Emacs, or gEdit, that<br>can handle large text files. Your output directory is...</html>");
        JTextField field = new JTextField(TetradLogger.getInstance().getLoggingDirectory());
        field.setMaximumSize(new Dimension(500, 20));
        field.setEditable(false);
        field.setBackground(Color.WHITE);
        JLabel label = new JLabel("<html>Higher numbered files are more recent.</html>");
        Box b = Box.createVerticalBox();
        b.add(label1);
        b.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(field);
        b2.add(Box.createHorizontalGlue());
        b.add(b2);
        b.add(Box.createVerticalStrut(10));
        b.add(label);
        panel.add((Component)b, "Center");
        return panel;
    }

    private void writeLogToFile(File file) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(this.textArea.getText());
            writer.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.desktop, "Error while trying to write to the selected file.");
        }
    }
}

