/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetradapp.editor.BayesImEditorWizard;
import edu.cmu.tetradapp.editor.SaveBayesImXmlAction;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.SaveScreenshot;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class BayesImEditor
extends JPanel {
    private BayesImEditorWizard wizard;

    public BayesImEditor(BayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException("Bayes IM must not be null.");
        }
        BayesPm bayesPm = bayesIm.getBayesPm();
        Dag graph = bayesPm.getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveBayesImXmlAction(this));
        file.add(new SaveScreenshot(this, true, "Save Screenshot..."));
        file.add(new SaveComponentImage(workbench, "Save Graph Image..."));
        this.setLayout(new BorderLayout());
        this.add((Component)menuBar, "North");
        this.wizard = new BayesImEditorWizard(bayesIm, workbench);
        this.wizard.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorValueChanged".equals(evt.getPropertyName())) {
                    BayesImEditor.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        JScrollPane wizardScroll = new JScrollPane(this.getWizard());
        workbenchScroll.setPreferredSize(new Dimension(450, 450));
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, wizardScroll);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        this.add((Component)splitPane, "Center");
        this.setName("Bayes IM Editor");
        this.getWizard().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorClosing".equals(evt.getPropertyName())) {
                    BayesImEditor.this.firePropertyChange("editorClosing", null, BayesImEditor.this.getName());
                }
                if ("closeFrame".equals(evt.getPropertyName())) {
                    BayesImEditor.this.firePropertyChange("closeFrame", null, null);
                    BayesImEditor.this.firePropertyChange("editorClosing", true, true);
                }
                if ("modelChanged".equals(evt.getPropertyName())) {
                    BayesImEditor.this.firePropertyChange("modelChanged", evt.getOldValue(), evt.getNewValue());
                }
            }
        });
    }

    public BayesImEditor(BayesImWrapper bayesImWrapper) {
        this(bayesImWrapper.getBayesIm());
    }

    public BayesImEditor(BayesEstimatorWrapper bayesEstWrapper) {
        this(bayesEstWrapper.getEstimatedBayesIm());
    }

    public BayesImEditor(DirichletEstimatorWrapper dirichletEstWrapper) {
        this(dirichletEstWrapper.getEstimatedBayesIm());
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    public BayesImEditorWizard getWizard() {
        return this.wizard;
    }
}

