/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.BayesPmParams;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class BayesPmParamsEditor
extends JPanel
implements ParameterEditor {
    private BayesPmParams params = null;
    private IntTextField lowerBoundField;
    private IntTextField upperBoundField;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (BayesPmParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        this.lowerBoundField = new IntTextField(this.getParams().getLowerBoundNumVals(), 4);
        this.lowerBoundField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    BayesPmParamsEditor.this.getParams().setLowerBoundNumVals(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        this.upperBoundField = new IntTextField(this.getParams().getUpperBoundNumVals(), 4);
        this.upperBoundField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    BayesPmParamsEditor.this.getParams().setUpperBoundNumVals(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        this.setLayout(new BorderLayout());
        JRadioButton setUpManually = new JRadioButton("<html>Set up manually.</html>");
        JRadioButton automaticallyAssigned = new JRadioButton("<html>Automatically assigned.</html>");
        ButtonGroup group = new ButtonGroup();
        group.add(setUpManually);
        group.add(automaticallyAssigned);
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Categories for variables should be:"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b3 = Box.createHorizontalBox();
        b3.add(setUpManually);
        b3.add(Box.createHorizontalGlue());
        b1.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createHorizontalStrut(25));
        b4.add(new JLabel("<html>All variables will initially have 2 categories, '0' and '1', <br>which can then be changed variable by variable in the editor.</html>"));
        b4.add(Box.createHorizontalGlue());
        b1.add(b4);
        b1.add(Box.createVerticalStrut(10));
        Box b5 = Box.createHorizontalBox();
        b5.add(automaticallyAssigned);
        b5.add(Box.createHorizontalGlue());
        b1.add(b5);
        Box b6 = Box.createHorizontalBox();
        b6.add(Box.createHorizontalStrut(25));
        b6.add(new JLabel("<html>Each variable will be automatically be assigned a number<br>of categories (for simulation, e.g.). </html>"));
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        b1.add(Box.createVerticalStrut(10));
        Box b7 = Box.createHorizontalBox();
        b7.add(Box.createHorizontalStrut(25));
        b7.add(new JLabel("Least number of categories for each variable:  "));
        b7.add(Box.createHorizontalGlue());
        b7.add(this.lowerBoundField);
        b1.add(b7);
        Box b8 = Box.createHorizontalBox();
        b8.add(Box.createHorizontalStrut(25));
        b8.add(new JLabel("Greatest number of categories for each variable:  "));
        b8.add(Box.createHorizontalGlue());
        b8.add(this.upperBoundField);
        b1.add(b8);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
        if (this.getParams().getInitializationMode() == 0) {
            setUpManually.setSelected(true);
            this.lowerBoundField.setEnabled(false);
            this.upperBoundField.setEnabled(false);
        } else {
            automaticallyAssigned.setSelected(true);
            this.lowerBoundField.setEnabled(true);
            this.upperBoundField.setEnabled(true);
        }
        setUpManually.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BayesPmParamsEditor.this.getParams().setInitializationMode(0);
                BayesPmParamsEditor.this.lowerBoundField.setEnabled(false);
                BayesPmParamsEditor.this.upperBoundField.setEnabled(false);
            }
        });
        automaticallyAssigned.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BayesPmParamsEditor.this.getParams().setInitializationMode(1);
                BayesPmParamsEditor.this.lowerBoundField.setEnabled(true);
                BayesPmParamsEditor.this.upperBoundField.setEnabled(true);
            }
        });
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private synchronized BayesPmParams getParams() {
        return this.params;
    }
}

