/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.BootstrapSamplerParams;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BootstrapSamplerParamsEditor
extends JPanel
implements ParameterEditor {
    private BootstrapSamplerParams params = null;
    private DataSet parentDataSet;

    @Override
    public void setParams(Params params) {
        this.params = (BootstrapSamplerParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        for (Object parentModel : parentModels) {
            DataModel dataModel;
            if (!(parentModel instanceof DataWrapper) || !((dataModel = ((DataWrapper)parentModel).getSelectedDataModel()) instanceof DataSet)) continue;
            this.parentDataSet = (DataSet)dataModel;
        }
    }

    @Override
    public void setup() {
        this.buildGui();
    }

    @Override
    public boolean mustBeShown() {
        return true;
    }

    private void buildGui() {
        int sampleSize;
        this.setLayout(new BorderLayout());
        if (this.params.isSampleSizeSet()) {
            sampleSize = this.params.getSampleSize();
        } else {
            sampleSize = this.parentDataSet.getNumRows();
            this.params.setSampleSize(sampleSize);
        }
        IntTextField sampleSizeField = new IntTextField(sampleSize, 6);
        sampleSizeField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    BootstrapSamplerParamsEditor.this.params.setSampleSize(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("<html>The input dataset will be sampled with replacement to create a new<br>dataset with the number of samples entered below."));
        Box b7 = Box.createHorizontalBox();
        b7.add(Box.createHorizontalGlue());
        b7.add(new JLabel("<html><i>Sample size:  </i></html>"));
        b7.add(sampleSizeField);
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        b1.add(b7);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
    }
}

