/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ExpressionEditor;
import edu.cmu.tetradapp.editor.FinalizingParameterEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.calculator.CalculatorParams;
import edu.cmu.tetradapp.model.calculator.expression.ConstantExpression;
import edu.cmu.tetradapp.model.calculator.expression.Equation;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionManager;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionSignature;
import edu.cmu.tetradapp.util.LayoutUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class CalculatorEditor
extends JPanel
implements FinalizingParameterEditor {
    private CalculatorParams params;
    private DataSet dataSet;
    private List<ExpressionEditor> editors = new LinkedList<ExpressionEditor>();
    private ExpressionEditor focused;
    private JList variableList;
    private JPanel expressionsPanel;
    private boolean canceled;

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public void setParams(Params params) {
        this.params = (CalculatorParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null || parentModels.length == 0) {
            throw new IllegalArgumentException("There must be parent model");
        }
        DataWrapper data = null;
        for (Object parent : parentModels) {
            if (!(parent instanceof DataWrapper)) continue;
            data = (DataWrapper)parent;
        }
        if (data == null) {
            throw new IllegalArgumentException("Should have have a data wrapper as a parent");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("The data must be tabular");
        }
        this.dataSet = (DataSet)model;
    }

    @Override
    public void setup() {
        JComponent calculator = this.buildCalculator();
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(5, 5, 5, 5));
        box.add(calculator);
        this.add(box);
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    @Override
    public boolean finalizeEdit() {
        if (this.canceled) {
            return false;
        }
        List<Equation> equations = this.parseEquations();
        if (equations == null) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < equations.size(); ++i) {
            Equation eq = equations.get(i);
            buf.append(eq.getUnparsedExpression());
            if (i >= equations.size() - 1) continue;
            buf.append("///");
        }
        Preferences.userRoot().put("calculator_equations", buf.toString());
        if (this.params != null) {
            this.params.resetEquations();
            for (Equation eq : equations) {
                this.params.addEquation(eq.getUnparsedExpression());
            }
        }
        return true;
    }

    private List<Equation> parseEquations() {
        ArrayList<Equation> equations = new ArrayList<Equation>();
        for (ExpressionEditor editor : this.editors) {
            try {
                System.out.println(editor.getEquation());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                equations.add(editor.getEquation());
            }
            catch (ParseException e) {
                String s = e.getMessage();
                if (!"".equals(s)) {
                    JOptionPane.showMessageDialog(this, s);
                } else {
                    JOptionPane.showMessageDialog(this, "Could not parse equations.");
                }
                e.printStackTrace();
                return null;
            }
        }
        return equations;
    }

    private static void setLocation(Window window) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = window.getBounds();
        window.setLocation((screenDim.width - bounds.width) / 2, (screenDim.height - bounds.height) / 2);
    }

    private JComponent buildCalculator() {
        Box mainBox = Box.createHorizontalBox();
        Box varBox = Box.createVerticalBox();
        varBox.add(CalculatorEditor.createLabel("Variables:"));
        varBox.add(this.createVariableList());
        varBox.add(Box.createVerticalGlue());
        Box expressionBox = Box.createVerticalBox();
        Box equationEditors = Box.createVerticalBox();
        equationEditors.setBorder(new TitledBorder("Edit Expressions"));
        JPanel editors1 = this.initializeExpressionEditors();
        JScrollPane pane = new JScrollPane(editors1);
        pane.setVerticalScrollBarPolicy(22);
        LayoutUtils.setAllSizes(pane, new Dimension(editors1.getPreferredSize().width + 25, 100));
        equationEditors.add(pane);
        Box b = Box.createHorizontalBox();
        JLabel label = new JLabel("Example using wildcard: New$ = $ + 1");
        label.setFont(new Font("Dialog", 1, 10));
        b.add(label);
        b.add(Box.createHorizontalGlue());
        equationEditors.add(b);
        equationEditors.add(Box.createVerticalStrut(10));
        equationEditors.add(this.createAddRemoveButtons());
        equationEditors.add(Box.createVerticalGlue());
        Box box = Box.createHorizontalBox();
        box.add(this.createCalculatorNumberPad());
        box.add(Box.createHorizontalStrut(40));
        box.add(this.createFunctionList());
        box.add(Box.createHorizontalStrut(10));
        box.add(Box.createHorizontalGlue());
        expressionBox.add(equationEditors);
        expressionBox.add(Box.createVerticalStrut(15));
        expressionBox.add(box);
        expressionBox.add(Box.createVerticalGlue());
        mainBox.add(varBox);
        mainBox.add(Box.createHorizontalStrut(3));
        mainBox.add(this.createSelectVariableButton());
        mainBox.add(Box.createHorizontalStrut(3));
        mainBox.add(expressionBox);
        mainBox.add(Box.createHorizontalGlue());
        return mainBox;
    }

    private JComponent createSelectVariableButton() {
        Box box = Box.createVerticalBox();
        JButton selectVariable = new JButton(">");
        selectVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node node = (Node)CalculatorEditor.this.variableList.getSelectedValue();
                if (node != null) {
                    CalculatorEditor.this.insertSymbol(node.getName());
                }
            }
        });
        box.add(Box.createVerticalStrut(50));
        box.add(selectVariable);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private JComponent createAddRemoveButtons() {
        Box box = Box.createHorizontalBox();
        JButton remove = new JButton("Remove Selected Expressions");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorEditor.this.removeSelected();
            }
        });
        JButton add = new JButton("Add Expression");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorEditor.this.editors.add(new ExpressionEditor(CalculatorEditor.this.dataSet, "", ""));
                CalculatorEditor.this.createExpressionEditors();
                CalculatorEditor.this.expressionsPanel.revalidate();
                CalculatorEditor.this.expressionsPanel.repaint();
            }
        });
        box.add(add);
        box.add(Box.createHorizontalStrut(5));
        box.add(remove);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JPanel initializeExpressionEditors() {
        String[] displayEquations;
        if (this.expressionsPanel == null) {
            this.expressionsPanel = new JPanel();
            this.expressionsPanel.setLayout(new BoxLayout(this.expressionsPanel, 1));
        }
        this.expressionsPanel.removeAll();
        if (this.params != null) {
            int size = this.params.getEquations().size();
            displayEquations = this.params.getEquations().toArray(new String[size]);
        } else {
            String _displayEquations = Preferences.userRoot().get("calculator_equations", "");
            displayEquations = _displayEquations.split("///");
        }
        for (String expression : displayEquations) {
            if (!expression.contains("=")) continue;
            String[] sides = expression.split("=");
            this.editors.add(new ExpressionEditor(this.dataSet, sides[0], sides[1]));
        }
        if (this.editors.isEmpty()) {
            this.editors.add(new ExpressionEditor(this.dataSet, "", ""));
        }
        FocusAdapter listener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CalculatorEditor.this.focused = (ExpressionEditor)evt.getSource();
            }
        };
        for (ExpressionEditor editor : this.editors) {
            editor.addFieldFocusListener(listener);
            this.expressionsPanel.add(editor);
        }
        this.expressionsPanel.add(Box.createVerticalGlue());
        return this.expressionsPanel;
    }

    private JPanel createExpressionEditors() {
        if (this.expressionsPanel == null) {
            this.expressionsPanel = new JPanel();
            this.expressionsPanel.setLayout(new BoxLayout(this.expressionsPanel, 1));
        }
        this.expressionsPanel.removeAll();
        if (this.editors.isEmpty()) {
            this.editors.add(new ExpressionEditor(this.dataSet, "", ""));
        }
        FocusAdapter listener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CalculatorEditor.this.focused = (ExpressionEditor)evt.getSource();
            }
        };
        for (ExpressionEditor editor : this.editors) {
            editor.addFieldFocusListener(listener);
            this.expressionsPanel.add(editor);
        }
        this.expressionsPanel.add(Box.createVerticalGlue());
        return this.expressionsPanel;
    }

    private JComponent createVariableList() {
        List<Node> nodes = this.dataSet.getVariables();
        this.variableList = new JList(new DefaultListModel());
        this.variableList.setSelectionMode(0);
        DefaultListModel model = (DefaultListModel)this.variableList.getModel();
        for (Node node : nodes) {
            model.addElement(node);
        }
        this.variableList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ListModel model;
                Node node;
                int index;
                if (evt.getButton() == 1 && evt.getClickCount() % 2 == 0 && 0 <= (index = CalculatorEditor.this.variableList.locationToIndex(evt.getPoint())) && (node = (Node)(model = CalculatorEditor.this.variableList.getModel()).getElementAt(index)) != null) {
                    CalculatorEditor.this.insertSymbol(node.getName());
                }
            }
        });
        JScrollPane pane = new JScrollPane(this.variableList);
        pane.setPreferredSize(new Dimension(100, 300));
        return pane;
    }

    private static Box createLabel(String text) {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(text));
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void removeSelected() {
        boolean allSelected = true;
        for (ExpressionEditor e : this.editors) {
            if (e.removeSelected()) continue;
            allSelected = false;
        }
        if (allSelected) {
            JOptionPane.showMessageDialog(this, "Cannot delete all expression editors.");
        } else {
            for (int i = this.editors.size() - 1; 0 <= i; --i) {
                ExpressionEditor e;
                e = this.editors.get(i);
                if (!e.removeSelected()) continue;
                this.editors.remove(i);
            }
            this.createExpressionEditors();
            this.expressionsPanel.revalidate();
            this.expressionsPanel.repaint();
        }
    }

    private void insertSymbol(String symbol) {
        ExpressionEditor editor = this.focused;
        if (editor != null) {
            editor.insertLastFocused(symbol, true);
        } else {
            this.editors.get(0).insertLastFocused(symbol, true);
        }
    }

    private void insertExpression(ExpressionSignature sig) {
        ExpressionEditor editor = this.focused;
        if (editor != null) {
            editor.addExpressionSignature(sig);
        } else {
            this.editors.get(0).addExpressionSignature(sig);
        }
    }

    private JComponent createCalculatorNumberPad() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 4));
        panel.add(this.createCalculatorButton("7"));
        panel.add(this.createCalculatorButton("8"));
        panel.add(this.createCalculatorButton("9"));
        panel.add(this.createCalculatorButton("+"));
        panel.add(this.createCalculatorButton("4"));
        panel.add(this.createCalculatorButton("5"));
        panel.add(this.createCalculatorButton("6"));
        panel.add(this.createCalculatorButton("-"));
        panel.add(this.createCalculatorButton("1"));
        panel.add(this.createCalculatorButton("2"));
        panel.add(this.createCalculatorButton("3"));
        panel.add(this.createCalculatorButton("*"));
        panel.add(this.createCalculatorButton("0"));
        panel.add(this.createCalculatorButton("."));
        panel.add(this.createCalculatorButton(ConstantExpression.E.getName()));
        panel.add(this.createCalculatorButton(ConstantExpression.PI.getName()));
        panel.setPreferredSize(new Dimension(150, 150));
        return panel;
    }

    private JButton createCalculatorButton(final String symbol) {
        JButton button = new JButton(symbol);
        Font font = button.getFont();
        button.setFont(new Font("Dialog", font.getStyle(), font.getSize()));
        button.setMargin(new Insets(4, 4, 4, 4));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculatorEditor.this.insertSymbol(symbol);
            }
        });
        return button;
    }

    private JComponent createFunctionList() {
        List<ExpressionDescriptor> des = ExpressionManager.getInstance().getDescriptors();
        Object[] descriptors = des.toArray(new Object[des.size()]);
        final JList<Object> list = new JList<Object>(descriptors);
        list.setSelectionMode(0);
        list.setCellRenderer(new Renderer());
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                if (evt.getButton() == 1 && evt.getClickCount() % 2 == 0 && 0 <= (index = list.locationToIndex(evt.getPoint()))) {
                    ListModel model = list.getModel();
                    ExpressionDescriptor des = (ExpressionDescriptor)model.getElementAt(index);
                    CalculatorEditor.this.insertExpression(des.getSignature());
                }
            }
        });
        JScrollPane pane = new JScrollPane(list);
        LayoutUtils.setAllSizes(pane, new Dimension(150, 130));
        pane.setVerticalScrollBarPolicy(22);
        JButton select = new JButton("Select");
        select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionDescriptor des = (ExpressionDescriptor)list.getSelectedValue();
                if (des != null) {
                    CalculatorEditor.this.insertExpression(des.getSignature());
                }
            }
        });
        Box selectBox = Box.createHorizontalBox();
        selectBox.add(Box.createHorizontalGlue());
        selectBox.add(select);
        selectBox.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Functions:"), "North");
        panel.add((Component)pane, "Center");
        panel.add((Component)selectBox, "South");
        return panel;
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
            } else {
                ExpressionDescriptor des = (ExpressionDescriptor)value;
                this.setText(des.getToken());
            }
            return this;
        }
    }
}

