/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class ConvertToCovMatixAction
extends AbstractAction {
    private DataEditor dataEditor;

    public ConvertToCovMatixAction(DataEditor editor) {
        super("Covariance Matrix");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            if (!dataSet.isContinuous()) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Must be a continuous data set or a covariance (or correlation) matrix.");
                return;
            }
            CovarianceMatrix corrMatrix = new CovarianceMatrix(dataSet);
            DataModelList list = new DataModelList();
            list.add(corrMatrix);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else if (dataModel instanceof CovarianceMatrix) {
            CovarianceMatrix covMatrix1 = (CovarianceMatrix)dataModel;
            CovarianceMatrix covMatrix2 = new CovarianceMatrix(covMatrix1);
            DataModelList list = new DataModelList();
            list.add(covMatrix2);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Must be a continuous data set or a covariance (or correlation) matrix.");
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

