/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.SubgraphSelection;
import edu.cmu.tetradapp.util.InternalClipboard;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;

class CopySubgraphAction
extends AbstractAction
implements ClipboardOwner {
    private GraphEditable graphEditor;

    public CopySubgraphAction(GraphEditable graphEditor) {
        super("Copy");
        if (graphEditor == null) {
            throw new NullPointerException("Desktop must not be null.");
        }
        this.graphEditor = graphEditor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List modelComponents = this.graphEditor.getSelectedModelComponents();
        SubgraphSelection selection = new SubgraphSelection(modelComponents);
        InternalClipboard.getInstance().setContents(selection, this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

