/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.NumberFormatUtil;
import java.awt.Color;
import java.text.NumberFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

class CovCellEditor
extends DefaultCellEditor {
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private JTextField textField = (JTextField)this.editorComponent;

    public CovCellEditor() {
        super(new JTextField());
        this.textField.setHorizontalAlignment(2);
        this.textField.setBorder(new LineBorder(Color.black));
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value == null) {
                    CovCellEditor.this.textField.setText("");
                } else if (value instanceof String) {
                    CovCellEditor.this.textField.setText((String)value);
                } else if (value instanceof Integer) {
                    CovCellEditor.this.textField.setText(value.toString());
                } else if (value instanceof Double) {
                    double doubleValue = (Double)value;
                    if (Double.isNaN(doubleValue)) {
                        CovCellEditor.this.textField.setText("");
                    } else {
                        CovCellEditor.this.textField.setText(CovCellEditor.this.nf.format(doubleValue));
                    }
                }
                CovCellEditor.this.textField.selectAll();
            }

            @Override
            public Object getCellEditorValue() {
                return CovCellEditor.this.textField.getText();
            }
        };
        this.textField.addActionListener(this.delegate);
    }

    public void setRed(boolean red) {
        if (red) {
            this.textField.setForeground(Color.RED);
        } else {
            this.textField.setForeground(Color.BLACK);
        }
    }
}

