/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

class CovCellRenderer
extends DefaultTableCellRenderer {
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private boolean positiveDefinite = true;
    private CovarianceMatrix covMatrix;
    private Color selectedColor = new Color(204, 204, 255);

    public CovCellRenderer(CovarianceMatrix covMatrix) {
        if (covMatrix == null) {
            throw new NullPointerException();
        }
        this.covMatrix = covMatrix;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            this.setText((String)value);
        } else if (value instanceof Integer) {
            this.setText(value.toString());
        } else if (value instanceof Double) {
            double doubleValue = (Double)value;
            this.setText(this.nf.format(doubleValue));
        } else {
            this.setText("");
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        boolean colSelected;
        boolean rowSelected;
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)c;
        renderer.setBackground(Color.WHITE);
        renderer.setForeground(Color.BLACK);
        if (!this.isPositiveDefinite() && row >= 4 && col >= 1) {
            renderer.setForeground(Color.RED);
        }
        if (value instanceof Number) {
            renderer.setHorizontalAlignment(4);
        } else {
            renderer.setHorizontalAlignment(2);
        }
        List<Node> variables = this.covMatrix.getVariables();
        int rowVar = row - 4;
        int colVar = col - 1;
        int numVars = variables.size();
        if (colVar >= 0 && colVar < numVars && rowVar >= 0 && rowVar < numVars && rowVar >= colVar) {
            rowSelected = this.covMatrix.isSelected(variables.get(rowVar));
            boolean colSelected2 = this.covMatrix.isSelected(variables.get(colVar));
            if (rowSelected && colSelected2) {
                renderer.setBackground(this.selectedColor);
            }
        }
        if (colVar == -1 && rowVar >= 0 && rowVar < numVars && (rowSelected = this.covMatrix.isSelected(variables.get(rowVar)))) {
            renderer.setBackground(this.selectedColor);
        }
        if (rowVar == -1 && colVar >= 0 && colVar < numVars && (colSelected = this.covMatrix.isSelected(variables.get(colVar)))) {
            renderer.setBackground(this.selectedColor);
        }
        if (hasFocus) {
            renderer.setBackground(Color.WHITE);
            renderer.setBorder(new LineBorder(Color.BLACK));
        }
        return renderer;
    }

    private boolean isPositiveDefinite() {
        return this.positiveDefinite;
    }

    public void setPositiveDefinite(boolean positiveDefinite) {
        this.positiveDefinite = positiveDefinite;
    }

    public CovarianceMatrix getCovMatrix() {
        return this.covMatrix;
    }
}

