/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.PointXy;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.editor.AllPathsAction;
import edu.cmu.tetradapp.editor.CopySubgraphAction;
import edu.cmu.tetradapp.editor.DagGraphToolbar;
import edu.cmu.tetradapp.editor.DirectedPathsAction;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.GraphFileMenu;
import edu.cmu.tetradapp.editor.GraphPropertiesAction;
import edu.cmu.tetradapp.editor.IndependenceFactsAction;
import edu.cmu.tetradapp.editor.NeighborhoodsAction;
import edu.cmu.tetradapp.editor.PasteSubgraphAction;
import edu.cmu.tetradapp.editor.RandomGraphEditor;
import edu.cmu.tetradapp.editor.TreksAction;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.LayoutMenu;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;

public final class DagEditor
extends JPanel
implements GraphEditable,
LayoutEditable,
DelegatesEditing,
IndTestProducer {
    private final GraphWorkbench workbench;
    private DagWrapper dagWrapper;

    public DagEditor(DagWrapper graphWrapper) {
        this(graphWrapper.getDag());
        this.dagWrapper = graphWrapper;
    }

    public DagEditor(Dag dag) {
        this.setPreferredSize(new Dimension(550, 450));
        this.setLayout(new BorderLayout());
        this.workbench = new GraphWorkbench(dag);
        this.workbench.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graph".equals(evt.getPropertyName()) && DagEditor.this.getDagWrapper() != null) {
                    DagEditor.this.getDagWrapper().setDag((Dag)evt.getNewValue());
                }
            }
        });
        DagGraphToolbar toolbar = new DagGraphToolbar(this.getWorkbench());
        JMenuBar menuBar = this.createGraphMenuBar();
        this.add((Component)new JScrollPane(this.getWorkbench()), "Center");
        this.add((Component)toolbar, "West");
        this.add((Component)menuBar, "North");
        JLabel label = new JLabel("Double click variable to change name.");
        label.setFont(new Font("SansSerif", 0, 12));
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalStrut(2));
        b.add(label);
        b.add(Box.createHorizontalGlue());
        b.setBorder(new MatteBorder(0, 0, 1, 0, Color.GRAY));
        this.add((Component)b, "South");
        this.workbench.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("dag".equals(propertyName)) {
                    Dag _graph = (Dag)evt.getNewValue();
                    if (DagEditor.this.getWorkbench() != null) {
                        DagEditor.this.getDagWrapper().setDag(_graph);
                    }
                }
            }
        });
        this.workbench.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("modelChanged".equals(propertyName)) {
                    DagEditor.this.firePropertyChange("modelChanged", evt.getOldValue(), evt.getNewValue());
                }
            }
        });
    }

    @Override
    public final void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public JComponent getEditDelegate() {
        return this.getWorkbench();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public List getSelectedModelComponents() {
        List<Component> selectedComponents = this.getWorkbench().getSelectedComponents();
        ArrayList<TetradSerializable> selectedModelComponents = new ArrayList<TetradSerializable>();
        for (Component comp : selectedComponents) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (Object sessionElement : sessionElements) {
            if (!(sessionElement instanceof GraphNode)) continue;
            Node modelNode = (Node)sessionElement;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public Graph getGraph() {
        return this.workbench.getGraph();
    }

    @Override
    public void setGraph(Graph graph) {
        try {
            Dag dag = new Dag(graph);
            this.workbench.setGraph(dag);
        }
        catch (Exception e) {
            throw new RuntimeException("Not a DAG", e);
        }
    }

    @Override
    public Knowledge getKnowledge() {
        return null;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getWorkbench().getGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public void layoutByKnowledge() {
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    private DagWrapper getDagWrapper() {
        return this.dagWrapper;
    }

    private JMenuBar createGraphMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        GraphFileMenu fileMenu = new GraphFileMenu(this, this.getWorkbench());
        JMenu editMenu = this.createEditMenu();
        JMenu graphMenu = this.createGraphMenu();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(graphMenu);
        menuBar.add(new LayoutMenu(this));
        return menuBar;
    }

    private JMenu createEditMenu() {
        JMenu edit = new JMenu("Edit");
        JMenuItem copy = new JMenuItem(new CopySubgraphAction(this));
        JMenuItem paste = new JMenuItem(new PasteSubgraphAction(this));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        edit.add(copy);
        edit.add(paste);
        return edit;
    }

    private JMenu createGraphMenu() {
        JMenu graph = new JMenu("Graph");
        graph.add(new GraphPropertiesAction(this.getWorkbench()));
        graph.add(new DirectedPathsAction(this.getWorkbench()));
        graph.add(new TreksAction(this.getWorkbench()));
        graph.add(new AllPathsAction(this.getWorkbench()));
        graph.add(new NeighborhoodsAction(this.getWorkbench()));
        JMenuItem randomDag = new JMenuItem("Random DAG");
        graph.add(randomDag);
        randomDag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomGraphEditor editor = new RandomGraphEditor(DagEditor.this.workbench.getGraph(), false);
                int ret = JOptionPane.showConfirmDialog(DagEditor.this, editor, "Edit Random DAG Parameters", -1);
                if (ret == 0) {
                    Dag dag = new Dag();
                    boolean numTrials = false;
                    if (editor.isUniformlySelected()) {
                        if (DagEditor.this.getGraph().getNumNodes() == editor.getNumNodes()) {
                            HashMap<String, PointXy> layout = GraphUtils.grabLayout(DagEditor.this.workbench.getGraph().getNodes());
                            dag = GraphUtils.randomDag(DagEditor.this.getGraph().getNodes(), editor.getNumLatents(), editor.getMaxEdges(), editor.getMaxDegree(), editor.getMaxIndegree(), editor.getMaxOutdegree(), editor.isConnected());
                            GraphUtils.arrangeBySourceGraph(dag, DagEditor.this.getWorkbench().getGraph());
                            GraphUtils.arrangeByLayout(dag, layout);
                        } else {
                            dag = GraphUtils.randomDag(editor.getNumNodes(), editor.getNumLatents(), editor.getMaxEdges(), editor.getMaxDegree(), editor.getMaxIndegree(), editor.getMaxOutdegree(), editor.isConnected());
                        }
                    } else {
                        do {
                            if (DagEditor.this.getGraph().getNumNodes() == editor.getNumNodes()) {
                                HashMap<String, PointXy> layout = GraphUtils.grabLayout(DagEditor.this.workbench.getGraph().getNodes());
                                dag = GraphUtils.randomDag(DagEditor.this.getGraph().getNodes(), editor.getNumLatents(), editor.getMaxEdges(), 30, 15, 15, editor.isConnected());
                                GraphUtils.arrangeByLayout(dag, layout);
                                continue;
                            }
                            dag = GraphUtils.randomDag(editor.getNumNodes(), editor.getNumLatents(), editor.getMaxEdges(), 30, 15, 15, editor.isConnected());
                        } while (dag.getNumEdges() < editor.getMaxEdges());
                    }
                    DagEditor.this.getWorkbench().setGraph(dag);
                }
            }
        });
        graph.addSeparator();
        IndependenceFactsAction action = new IndependenceFactsAction(JOptionUtils.centeringComp(), this, "D Separation Facts...");
        graph.add(action);
        return graph;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return new IndTestDSep(this.workbench.getGraph());
    }
}

