/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

class DagGraphToolbar
extends JPanel
implements PropertyChangeListener {
    private ButtonGroup group;
    private Box buttonsPanel = Box.createVerticalBox();
    private JToggleButton move;
    private JToggleButton addObserved;
    private JToggleButton addLatent;
    private JToggleButton addDirectedEdge;
    private GraphWorkbench workbench;

    public DagGraphToolbar(GraphWorkbench workbench) {
        if (workbench == null) {
            throw new NullPointerException();
        }
        this.workbench = workbench;
        this.group = new ButtonGroup();
        this.setLayout(new BoxLayout(this, 0));
        this.buttonsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add(this.buttonsPanel);
        this.move = new JToggleButton();
        this.addObserved = new JToggleButton();
        this.addLatent = new JToggleButton();
        this.addDirectedEdge = new JToggleButton();
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JToggleButton component = (JToggleButton)e.getComponent();
                component.doClick();
            }
        };
        this.move.addFocusListener(focusListener);
        this.addObserved.addFocusListener(focusListener);
        this.addLatent.addFocusListener(focusListener);
        this.addDirectedEdge.addFocusListener(focusListener);
        this.move.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DagGraphToolbar.this.move.getModel().setSelected(true);
                DagGraphToolbar.this.setWorkbenchMode(0);
            }
        });
        this.addObserved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DagGraphToolbar.this.addObserved.getModel().setSelected(true);
                DagGraphToolbar.this.setWorkbenchMode(1);
                DagGraphToolbar.this.setNodeMode(0);
            }
        });
        this.addLatent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DagGraphToolbar.this.addLatent.getModel().setSelected(true);
                DagGraphToolbar.this.setWorkbenchMode(1);
                DagGraphToolbar.this.setNodeMode(1);
            }
        });
        this.addDirectedEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DagGraphToolbar.this.addDirectedEdge.getModel().setSelected(true);
                DagGraphToolbar.this.setWorkbenchMode(2);
                DagGraphToolbar.this.setEdgeMode(0);
            }
        });
        this.addButton(this.move, "move");
        this.addButton(this.addObserved, "variable");
        this.addButton(this.addLatent, "latent");
        this.addButton(this.addDirectedEdge, "directed");
        workbench.addPropertyChangeListener(this);
        this.selectArrowTools();
        this.buttonsPanel.add(Box.createGlue());
    }

    private void setWorkbenchMode(int mode) {
        this.workbench.setWorkbenchMode(mode);
    }

    private void setEdgeMode(int mode) {
        this.workbench.setEdgeMode(mode);
    }

    private void setNodeMode(int mode) {
        this.workbench.setNodeType(mode);
    }

    private void addButton(JToggleButton button, String name) {
        button.setIcon(new ImageIcon(ImageUtils.getImage(this, name + "3.gif")));
        button.setMaximumSize(new Dimension(80, 40));
        button.setPreferredSize(new Dimension(80, 40));
        this.buttonsPanel.add(button);
        this.buttonsPanel.add(Box.createVerticalStrut(5));
        this.group.add(button);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("graph".equals(e.getPropertyName())) {
            this.selectArrowTools();
        }
    }

    private void selectArrowTools() {
        this.addDirectedEdge.setEnabled(true);
    }
}

