/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.DescriptiveStats;
import edu.cmu.tetradapp.editor.QQPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class DescriptiveStatsEditorPanel
extends JPanel {
    private JComboBox variableBox;
    private DataSet dataSet;
    private QQPlot qqPlot;
    private LinkedList<DiscreteVariable> variables = new LinkedList();

    public DescriptiveStatsEditorPanel(Node selected, DataSet dataSet) {
        this.setLayout(new BorderLayout());
        this.dataSet = dataSet;
        this.variableBox = new JComboBox();
        VariableBoxRenderer renderer = new VariableBoxRenderer();
        this.variableBox.setRenderer(renderer);
        for (Node node : dataSet.getVariables()) {
            if (!(node instanceof ContinuousVariable)) continue;
            this.variableBox.addItem(node);
            if (node != selected) continue;
            this.variableBox.setSelectedItem(node);
        }
        this.variableBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Node node = (Node)e.getItem();
                    DescriptiveStatsEditorPanel.this.changeDescriptiveStats(DescriptiveStats.generateDescriptiveStats(DescriptiveStatsEditorPanel.this.dataSet, node));
                }
            }
        });
        this.add((Component)this.buildEditArea(), "Center");
    }

    private void changeDescriptiveStats(String test) {
        this.firePropertyChange("histogramChange", null, test);
    }

    private static void setPreferredAsMax(JComponent component) {
        component.setMaximumSize(component.getPreferredSize());
    }

    private Box buildEditArea() {
        DescriptiveStatsEditorPanel.setPreferredAsMax(this.variableBox);
        Box main = Box.createVerticalBox();
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(new JLabel("Select Variable: "));
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(this.variableBox);
        hBox.add(Box.createHorizontalGlue());
        main.add(hBox);
        main.add(Box.createVerticalStrut(5));
        Box hBox2 = Box.createHorizontalBox();
        hBox2.add(Box.createHorizontalStrut(10));
        hBox2.add(Box.createHorizontalGlue());
        main.add(hBox2);
        main.add(Box.createVerticalStrut(5));
        main.add(Box.createVerticalStrut(10));
        main.add(Box.createVerticalGlue());
        return main;
    }

    private static class VariableBoxRenderer
    extends DefaultListCellRenderer {
        private VariableBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Node node = (Node)value;
            if (node == null) {
                this.setText("");
            } else {
                this.setText(node.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

