/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.EvidenceEditor;
import edu.cmu.tetradapp.model.UpdaterWrapper;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public class EvidenceWizardSingle
extends JPanel {
    private UpdaterWrapper updaterWrapper;
    private GraphWorkbench workbench;
    private final EvidenceEditor evidenceEditor;

    public EvidenceWizardSingle(final UpdaterWrapper updaterWrapper, GraphWorkbench workbench) {
        if (updaterWrapper == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        Node node = workbench.getGraph().getNodes().get(0);
        workbench.deselectAll();
        workbench.selectNode(node);
        this.updaterWrapper = updaterWrapper;
        this.workbench = workbench;
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        JButton updateButton = new JButton("Do Update Now");
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("<html>Select the node in the graph that you would like to see updated<br>probabilities for. In the list below, select the evidence that<br>you would like to update on. Click the 'Do Update Now' button<br>to view updated probabilities.</html>"));
        b0.add(Box.createHorizontalGlue());
        this.add(b0);
        this.add(Box.createVerticalStrut(10));
        this.evidenceEditor = new EvidenceEditor(updaterWrapper.getBayesUpdater().getEvidence());
        this.getUpdaterWrapper().getParams().setEvidence(this.evidenceEditor.getEvidence());
        this.add(this.evidenceEditor);
        this.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(updateButton);
        this.add(b2);
        this.add(Box.createVerticalGlue());
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayNode graphNode = EvidenceWizardSingle.this.getWorkbench().getSelectedNode();
                if (graphNode == null) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Please select exactly one node in the graph.");
                    return;
                }
                Node tetradNode = graphNode.getModelNode();
                String selectedNodeName = tetradNode.getName();
                EvidenceWizardSingle.this.getUpdaterWrapper().getParams().setEvidence(EvidenceWizardSingle.this.evidenceEditor.getEvidence());
                EvidenceWizardSingle.this.getUpdaterWrapper().getParams().setVariable((DiscreteVariable)updaterWrapper.getBayesUpdater().getBayesIm().getBayesPm().getVariable(tetradNode));
                EvidenceWizardSingle.this.getUpdaterWrapper().getBayesUpdater().setEvidence(EvidenceWizardSingle.this.evidenceEditor.getEvidence());
                Graph updatedGraph = EvidenceWizardSingle.this.getUpdaterWrapper().getBayesUpdater().getManipulatedGraph();
                Node selectedNode = updatedGraph.getNode(selectedNodeName);
                EvidenceWizardSingle.this.getWorkbench().setGraph(updatedGraph);
                EvidenceWizardSingle.this.getWorkbench().deselectAll();
                EvidenceWizardSingle.this.getWorkbench().selectNode(selectedNode);
                EvidenceWizardSingle.this.firePropertyChange("updateButtonPressed", null, null);
                EvidenceWizardSingle.this.firePropertyChange("modelChanged", null, null);
            }
        });
    }

    public BayesIm getBayesIM() {
        return this.getUpdaterWrapper().getBayesUpdater().getUpdatedBayesIm();
    }

    private UpdaterWrapper getUpdaterWrapper() {
        return this.updaterWrapper;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }
}

