/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetradapp.model.calculator.expression.Equation;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionSignature;
import edu.cmu.tetradapp.model.calculator.parser.ExpressionParser;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ExpressionEditor
extends JPanel {
    private JTextField variable;
    private final JTextField expression;
    private ExpressionParser parser;
    private JTextField lastFocused;
    private List<FocusListener> listeners = new LinkedList<FocusListener>();
    private boolean remove;
    private List<Selection> selections = new LinkedList<Selection>();
    private static final Color SELECTION = new Color(204, 204, 255);
    private PositionsFocusListener positionsListener;

    public ExpressionEditor(DataSet data, String lhs, String rhs) {
        this.parser = new ExpressionParser(data.getVariableNames(), ExpressionParser.RestrictionType.MAY_ONLY_CONTAIN);
        this.variable = new JTextField(5);
        this.variable.setText(lhs);
        this.expression = new JTextField(25);
        this.expression.setText(rhs);
        this.variable.addFocusListener(new VariableFocusListener(this.variable));
        this.expression.addFocusListener(new ExpressionFocusListener(this.expression));
        this.positionsListener = new PositionsFocusListener();
        this.expression.addFocusListener(this.positionsListener);
        Box box = Box.createHorizontalBox();
        box.add(this.variable);
        box.add(Box.createHorizontalStrut(5));
        box.add(new JLabel("="));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.expression);
        JCheckBox checkBox = new JCheckBox();
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox b = (JCheckBox)e.getSource();
                ExpressionEditor.this.remove = b.isSelected();
            }
        });
        box.add(Box.createHorizontalStrut(2));
        box.add(checkBox);
        box.add(Box.createHorizontalGlue());
        this.add(box);
    }

    public Equation getEquation() throws ParseException {
        if (!NamingProtocol.isLegalName(this.variable.getText())) {
            this.variable.setSelectionColor(Color.RED);
            this.variable.select(0, this.variable.getText().length());
            this.variable.grabFocus();
            throw new ParseException(NamingProtocol.getProtocolDescription(), 1);
        }
        String equation = this.variable.getText() + "=" + this.expression.getText();
        try {
            return this.parser.parseEquation(equation);
        }
        catch (ParseException ex) {
            this.expression.setSelectionColor(Color.RED);
            this.expression.select(ex.getErrorOffset() - 1, this.expression.getText().length());
            this.expression.grabFocus();
            throw ex;
        }
    }

    public void addFieldFocusListener(FocusListener listener) {
        this.listeners.add(listener);
    }

    public void setVariable(String var, boolean append) {
        if (append) {
            this.variable.setText(this.variable.getText() + var);
        } else {
            this.variable.setText(var);
        }
    }

    public void setExpression(String exp, boolean append) {
        if (exp == null) {
            return;
        }
        if (!this.selections.isEmpty()) {
            this.expression.grabFocus();
            int start = this.positionsListener.start;
            int end = this.positionsListener.end;
            if (start < end) {
                this.selections.add(new Selection(start, end));
                this.expression.setCaretPosition(this.positionsListener.caretPosition);
            }
            String text = this.expression.getText();
            Selection selection = this.selections.remove(0);
            if (this.caretInSelection(selection)) {
                this.expression.setText(text.substring(0, selection.x) + exp + text.substring(selection.y));
                this.adjustSelections(selection, exp);
                this.highlightNextSelection();
                this.positionsListener.start = this.expression.getSelectionStart();
                this.positionsListener.end = this.expression.getSelectionEnd();
                this.positionsListener.caretPosition = this.expression.getCaretPosition();
                return;
            }
        }
        if (append) {
            String text = this.expression.getText();
            int caret = this.positionsListener.caretPosition;
            this.expression.setText(this.expression.getText() + exp);
            this.positionsListener.start = 0;
            this.positionsListener.end = 0;
            this.positionsListener.caretPosition = 0;
        } else {
            this.expression.setText(exp);
            this.positionsListener.start = 0;
            this.positionsListener.end = 0;
            this.positionsListener.caretPosition = 0;
        }
    }

    public void addExpressionSignature(ExpressionSignature signature) {
        Selection selection;
        this.expression.grabFocus();
        int start = this.positionsListener.start;
        int end = this.positionsListener.end;
        int caret = this.positionsListener.caretPosition;
        if (start < end) {
            this.selections.add(new Selection(start, end));
        }
        String sig = signature.getSignature();
        String text = this.expression.getText();
        Selection selection2 = selection = this.selections.isEmpty() ? null : this.selections.remove(0);
        if (selection == null || !this.caretInSelection(selection)) {
            String newText = text.substring(0, caret) + signature.getSignature() + text.substring(caret, text.length());
            this.expression.setText(newText);
            this.addSelections(signature, newText, false);
            this.highlightNextSelection();
            return;
        }
        String replacedText = text.substring(0, selection.x) + sig + text.substring(selection.y);
        this.expression.setText(replacedText);
        this.adjustSelections(selection, sig);
        this.addSelections(signature, replacedText, true);
        this.highlightNextSelection();
        this.positionsListener.start = 0;
        this.positionsListener.end = 0;
        this.positionsListener.caretPosition = 0;
    }

    public void insertLastFocused(String symbol, boolean append) {
        if (this.variable == this.lastFocused) {
            this.setVariable(symbol, append);
        } else {
            this.setExpression(symbol, append);
        }
    }

    public boolean removeSelected() {
        return this.remove;
    }

    private boolean caretInSelection(Selection sel) {
        int caret = this.expression.getCaretPosition();
        if (caret < sel.x || sel.y < caret) {
            this.selections.clear();
            return false;
        }
        return true;
    }

    private void addSelections(ExpressionSignature signature, String newText, boolean addFirst) {
        int offset = 0;
        for (int i = 0; i < signature.getNumberOfArguments(); ++i) {
            String arg = signature.getArgument(i);
            int index = newText.indexOf(arg);
            int end = index + arg.length();
            if (0 <= index) {
                if (addFirst) {
                    this.selections.add(i, new Selection(offset + index, offset + end));
                } else {
                    this.selections.add(new Selection(offset + index, offset + end));
                }
            }
            offset += end;
            newText = newText.substring(end);
        }
    }

    private void fireGainedFocus() {
        FocusEvent evt = new FocusEvent(this, 1004);
        for (FocusListener l : this.listeners) {
            l.focusGained(evt);
        }
    }

    private void adjustSelections(Selection selection, String inserted) {
        int dif = selection.y - selection.x - inserted.length();
        for (Selection sel : this.selections) {
            sel.x = sel.x - dif;
            sel.y = sel.y - dif;
        }
    }

    private void highlightNextSelection() {
        System.out.println("Highlighting next selection.");
        if (!this.selections.isEmpty()) {
            Selection sel = this.selections.get(0);
            this.expression.setSelectionColor(SELECTION);
            this.expression.select(sel.x, sel.y);
            this.expression.grabFocus();
        }
    }

    private static class PositionsFocusListener
    extends FocusAdapter {
        private int start = 0;
        private int end = 0;
        private int caretPosition = 0;

        private PositionsFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextField textField = (JTextField)e.getSource();
            this.start = textField.getSelectionStart();
            this.end = textField.getSelectionEnd();
            this.caretPosition = textField.getCaretPosition();
        }
    }

    private class ExpressionFocusListener
    implements FocusListener {
        private JTextField field;

        public ExpressionFocusListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void focusGained(FocusEvent e) {
            ExpressionEditor.this.lastFocused = this.field;
            ExpressionEditor.this.fireGainedFocus();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.field.getText() == null || this.field.getText().length() == 0) {
                return;
            }
            try {
                ExpressionEditor.this.parser.parseExpression(this.field.getText());
                this.field.setSelectionColor(SELECTION);
                this.field.setToolTipText(null);
            }
            catch (ParseException e1) {
                this.field.setToolTipText(e1.getMessage());
            }
        }
    }

    private class VariableFocusListener
    implements FocusListener {
        private JTextField field;

        public VariableFocusListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void focusGained(FocusEvent e) {
            ExpressionEditor.this.lastFocused = this.field;
            ExpressionEditor.this.fireGainedFocus();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.field.getText() != null && this.field.getText().length() != 0 && !NamingProtocol.isLegalName(this.field.getText())) {
                this.field.setToolTipText(NamingProtocol.getProtocolDescription());
            } else {
                this.field.setSelectionColor(SELECTION);
                this.field.setToolTipText(null);
            }
        }
    }

    private static class Selection {
        private int x;
        private int y;

        public Selection(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

