/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetradapp.editor.AbstractSearchEditor;
import edu.cmu.tetradapp.editor.DiscDetIndepParamsEditor;
import edu.cmu.tetradapp.editor.GesIndTestParamsEditor;
import edu.cmu.tetradapp.editor.IndTestParamsEditor;
import edu.cmu.tetradapp.editor.PcIndTestParamsEditor;
import edu.cmu.tetradapp.editor.TimeSeriesIndTestParamsEditor;
import edu.cmu.tetradapp.model.DiscDetIndepParams;
import edu.cmu.tetradapp.model.FactorAnalysisRunner;
import edu.cmu.tetradapp.model.GesIndTestParams;
import edu.cmu.tetradapp.model.GesRunner;
import edu.cmu.tetradapp.model.GraphIndTestParams;
import edu.cmu.tetradapp.model.IGesRunner;
import edu.cmu.tetradapp.model.ImagesRunner;
import edu.cmu.tetradapp.model.IndTestParams;
import edu.cmu.tetradapp.model.LagIndTestParams;
import edu.cmu.tetradapp.model.PcIndTestParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FactorAnalysisEditor
extends AbstractSearchEditor {
    private boolean alreadyLaidOut = false;

    public FactorAnalysisEditor(FactorAnalysisRunner runner) {
        super(runner, "Factor Analysis");
    }

    @Override
    public Graph getGraph() {
        return this.getWorkbench().getGraph();
    }

    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    @Override
    protected void setup(String resultLabel) {
        FactorAnalysisRunner runner = (FactorAnalysisRunner)this.getAlgorithmRunner();
        Graph graph = runner.getGraph();
        JTextArea display = new JTextArea(runner.getOutput());
        JScrollPane scrollPane = new JScrollPane(display);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        display.setEditable(false);
        display.setFont(new Font("Monospaced", 0, 12));
        GraphUtils.arrangeInCircle(graph, 225, 200, 150);
        GraphUtils.fruchtermanReingoldLayout(graph);
        GraphWorkbench workbench = new GraphWorkbench(graph);
        JScrollPane graphPane = new JScrollPane(workbench);
        graphPane.setPreferredSize(new Dimension(500, 400));
        Box box = Box.createHorizontalBox();
        box.add(scrollPane);
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        box.add(graphPane);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)vBox, "Center");
        this.add(panel);
    }

    @Override
    protected void addSpecialMenus(JMenuBar menuBar) {
    }

    public Graph getSourceGraph() {
        Graph sourceGraph = this.getWorkbench().getGraph();
        if (sourceGraph == null) {
            sourceGraph = this.getAlgorithmRunner().getSourceGraph();
        }
        return sourceGraph;
    }

    public List<String> getVarNames() {
        SearchParams params = this.getAlgorithmRunner().getParams();
        return params.getVarNames();
    }

    @Override
    public JPanel getToolbar() {
        return null;
    }

    private JComponent getIndTestParamBox() {
        SearchParams params = this.getAlgorithmRunner().getParams();
        IndTestParams indTestParams = params.getIndTestParams();
        return this.getIndTestParamBox(indTestParams);
    }

    private JComponent getIndTestParamBox(IndTestParams indTestParams) {
        if (indTestParams == null) {
            throw new NullPointerException();
        }
        if (indTestParams instanceof GesIndTestParams) {
            if (this.getAlgorithmRunner() instanceof IGesRunner) {
                GesRunner gesRunner = (GesRunner)this.getAlgorithmRunner();
                GesIndTestParams params = (GesIndTestParams)indTestParams;
                DataModel dataModel = gesRunner.getDataModel();
                boolean discreteData = dataModel instanceof DataSet && ((DataSet)dataModel).isDiscrete();
                return new GesIndTestParamsEditor(params, discreteData);
            }
            if (this.getAlgorithmRunner() instanceof ImagesRunner) {
                ImagesRunner gesRunner = (ImagesRunner)this.getAlgorithmRunner();
                GesIndTestParams params = (GesIndTestParams)indTestParams;
                DataSet dataSet = (DataSet)gesRunner.getDataModel();
                boolean discreteData = dataSet.isDiscrete();
                return new GesIndTestParamsEditor(params, discreteData);
            }
        }
        if (indTestParams instanceof LagIndTestParams) {
            return new TimeSeriesIndTestParamsEditor((LagIndTestParams)indTestParams);
        }
        if (indTestParams instanceof GraphIndTestParams) {
            return new IndTestParamsEditor((GraphIndTestParams)indTestParams);
        }
        if (indTestParams instanceof DiscDetIndepParams) {
            return new DiscDetIndepParamsEditor((DiscDetIndepParams)indTestParams);
        }
        if (indTestParams instanceof PcIndTestParams) {
            return new PcIndTestParamsEditor((PcIndTestParams)indTestParams);
        }
        return new IndTestParamsEditor(indTestParams);
    }

    @Override
    protected void doDefaultArrangement(Graph resultGraph) {
        if (this.alreadyLaidOut) {
            GraphUtils.arrangeBySourceGraph(resultGraph, this.getLatestWorkbenchGraph());
        } else {
            GraphUtils.arrangeBySourceGraph(resultGraph, this.getLatestWorkbenchGraph());
            this.alreadyLaidOut = true;
        }
    }
}

