/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import java.util.Vector;

public class FactorAnalysisJoe {
    public CovarianceMatrix covarianceMatrix;
    public CorrelationMatrix correlationMatrix;
    public Vector<Double> dValues;
    public Vector<DenseDoubleMatrix2D> factorLoadingVectors;
    public Vector<DenseDoubleMatrix2D> residualMatrices;

    public FactorAnalysisJoe(CovarianceMatrix covarianceMatrix) {
        this.covarianceMatrix = covarianceMatrix;
        this.correlationMatrix = new CorrelationMatrix(covarianceMatrix);
    }

    public FactorAnalysisJoe(DataSet dataSet) {
        this.covarianceMatrix = new CovarianceMatrix(dataSet);
        this.correlationMatrix = new CorrelationMatrix(dataSet);
    }

    public void unity(CorrelationMatrix r) {
        DoubleMatrix2D residual = r.getMatrix();
        for (int i = 0; i < residual.columns(); ++i) {
            residual.set(i, i, 1.0);
        }
    }

    public void largestNonDiagonalMagnitude(CorrelationMatrix r) {
        DoubleMatrix2D residual = r.getMatrix();
        for (int i = 0; i < residual.columns(); ++i) {
            double max = 0.0;
            for (int j = 0; j < residual.columns(); ++j) {
                double temp;
                if (i == j || !((temp = Math.abs(residual.get(j, i))) > max)) continue;
                max = temp;
            }
            residual.set(i, i, max);
        }
    }

    public void loadTestMatrix() {
        DenseDoubleMatrix2D testMatrix = new DenseDoubleMatrix2D(9, 9);
        for (int i = 0; i < 9; ++i) {
            testMatrix.set(i, i, 1.0);
        }
        testMatrix.set(0, 1, 0.829);
        testMatrix.set(0, 2, 0.768);
        testMatrix.set(0, 3, 0.108);
        testMatrix.set(0, 4, 0.033);
        testMatrix.set(0, 5, 0.108);
        testMatrix.set(0, 6, 0.298);
        testMatrix.set(0, 7, 0.309);
        testMatrix.set(0, 8, 0.351);
        testMatrix.set(1, 0, 0.829);
        testMatrix.set(2, 0, 0.768);
        testMatrix.set(3, 0, 0.108);
        testMatrix.set(4, 0, 0.033);
        testMatrix.set(5, 0, 0.108);
        testMatrix.set(6, 0, 0.298);
        testMatrix.set(7, 0, 0.309);
        testMatrix.set(8, 0, 0.351);
        testMatrix.set(1, 2, 0.775);
        testMatrix.set(1, 3, 0.115);
        testMatrix.set(1, 4, 0.061);
        testMatrix.set(1, 5, 0.125);
        testMatrix.set(1, 6, 0.323);
        testMatrix.set(1, 7, 0.347);
        testMatrix.set(1, 8, 0.369);
        testMatrix.set(2, 1, 0.775);
        testMatrix.set(3, 1, 0.115);
        testMatrix.set(4, 1, 0.061);
        testMatrix.set(5, 1, 0.125);
        testMatrix.set(6, 1, 0.323);
        testMatrix.set(7, 1, 0.347);
        testMatrix.set(8, 1, 0.369);
        testMatrix.set(2, 3, 0.272);
        testMatrix.set(2, 4, 0.205);
        testMatrix.set(2, 5, 0.238);
        testMatrix.set(2, 6, 0.296);
        testMatrix.set(2, 7, 0.271);
        testMatrix.set(2, 8, 0.385);
        testMatrix.set(3, 2, 0.272);
        testMatrix.set(4, 2, 0.205);
        testMatrix.set(5, 2, 0.238);
        testMatrix.set(6, 2, 0.296);
        testMatrix.set(7, 2, 0.271);
        testMatrix.set(8, 2, 0.385);
        testMatrix.set(3, 4, 0.636);
        testMatrix.set(3, 5, 0.626);
        testMatrix.set(3, 6, 0.249);
        testMatrix.set(3, 7, 0.183);
        testMatrix.set(3, 8, 0.369);
        testMatrix.set(4, 3, 0.636);
        testMatrix.set(5, 3, 0.626);
        testMatrix.set(6, 3, 0.249);
        testMatrix.set(7, 3, 0.183);
        testMatrix.set(8, 3, 0.369);
        testMatrix.set(4, 5, 0.709);
        testMatrix.set(4, 6, 0.138);
        testMatrix.set(4, 7, 0.091);
        testMatrix.set(4, 8, 0.254);
        testMatrix.set(5, 4, 0.709);
        testMatrix.set(6, 4, 0.138);
        testMatrix.set(7, 4, 0.091);
        testMatrix.set(8, 4, 0.254);
        testMatrix.set(5, 6, 0.19);
        testMatrix.set(5, 7, 0.103);
        testMatrix.set(5, 8, 0.291);
        testMatrix.set(6, 5, 0.19);
        testMatrix.set(7, 5, 0.103);
        testMatrix.set(8, 5, 0.291);
        testMatrix.set(6, 7, 0.654);
        testMatrix.set(6, 8, 0.527);
        testMatrix.set(7, 6, 0.654);
        testMatrix.set(8, 6, 0.527);
        testMatrix.set(7, 8, 0.541);
        testMatrix.set(8, 7, 0.541);
        this.correlationMatrix.setMatrix(testMatrix);
        System.out.println(this.correlationMatrix);
    }

    public DenseDoubleMatrix2D successiveResidual() {
        this.loadTestMatrix();
        this.factorLoadingVectors = new Vector();
        this.residualMatrices = new Vector();
        this.dValues = new Vector();
        this.residualMatrices.add((DenseDoubleMatrix2D)this.correlationMatrix.getMatrix());
        DenseDoubleMatrix2D unitVector = new DenseDoubleMatrix2D(9, 1);
        for (int i = 0; i < 9; ++i) {
            unitVector.set(i, 0, 1.0);
        }
        this.successiveResidualHelper(this.residualMatrices.lastElement(), unitVector);
        int failSafe = 0;
        while (FactorAnalysisJoe.vectorSum(this.dValues) / FactorAnalysisJoe.trace((DenseDoubleMatrix2D)this.correlationMatrix.getMatrix()) < 0.99) {
            System.out.println("****************  " + this.dValues.lastElement() / FactorAnalysisJoe.trace((DenseDoubleMatrix2D)this.correlationMatrix.getMatrix()));
            DenseDoubleMatrix2D prod = FactorAnalysisJoe.matrixMult(this.factorLoadingVectors.lastElement(), FactorAnalysisJoe.transpose(this.factorLoadingVectors.lastElement()));
            DenseDoubleMatrix2D residual = FactorAnalysisJoe.matrixSubtract(this.residualMatrices.lastElement(), prod);
            System.out.println(residual);
            this.residualMatrices.add(residual);
            this.successiveResidualHelper(this.residualMatrices.lastElement(), unitVector);
            if (++failSafe <= 500) continue;
            break;
        }
        return null;
    }

    public void successiveResidualHelper(DenseDoubleMatrix2D residual, DenseDoubleMatrix2D approximationVector) {
        DenseDoubleMatrix2D uVector = FactorAnalysisJoe.matrixMult(residual, approximationVector);
        DenseDoubleMatrix2D lVector = FactorAnalysisJoe.matrixMult(FactorAnalysisJoe.transpose(approximationVector), uVector);
        double dScalar = Math.sqrt(lVector.get(0, 0));
        DenseDoubleMatrix2D aVector = FactorAnalysisJoe.matrixDiv(dScalar, uVector);
        Vector<DenseDoubleMatrix2D> aVectors = new Vector<DenseDoubleMatrix2D>();
        Vector<DenseDoubleMatrix2D> uVectors = new Vector<DenseDoubleMatrix2D>();
        Vector<Double> dScalars = new Vector<Double>();
        aVectors.add(aVector);
        uVectors.add(uVector);
        dScalars.add(dScalar);
        for (int i = 0; i < 100; ++i) {
            approximationVector = (DenseDoubleMatrix2D)aVectors.lastElement();
            uVector = FactorAnalysisJoe.matrixMult(residual, approximationVector);
            lVector = FactorAnalysisJoe.matrixMult(FactorAnalysisJoe.transpose(approximationVector), uVector);
            dScalar = Math.sqrt(lVector.get(0, 0));
            aVector = FactorAnalysisJoe.matrixDiv(dScalar, uVector);
            aVectors.add(aVector);
            uVectors.add(uVector);
            dScalars.add(dScalar);
            System.out.println("New D Scalar: " + dScalar);
            if (!(Math.sqrt(dScalar / (Double)dScalars.get(dScalars.size() - 2) - 1.0) < 1.0E-5)) continue;
            System.out.println("Stopped on the " + i + "th iteration.");
            break;
        }
        System.out.println("Resultant factor loading matrix: ");
        System.out.println(aVectors.lastElement());
        this.dValues.add((Double)dScalars.lastElement());
        this.factorLoadingVectors.add((DenseDoubleMatrix2D)aVectors.lastElement());
    }

    public static DenseDoubleMatrix2D diag(DoubleMatrix2D matrix) {
        DenseDoubleMatrix2D diagonal = new DenseDoubleMatrix2D(matrix.columns(), matrix.columns());
        for (int i = 0; i < matrix.columns(); ++i) {
            for (int j = 0; j < matrix.columns(); ++j) {
                if (i == j) {
                    diagonal.set(j, i, matrix.get(i, i));
                    continue;
                }
                diagonal.set(j, i, 0.0);
            }
        }
        return diagonal;
    }

    public static DenseDoubleMatrix2D diag(DataSet dataSet) {
        return FactorAnalysisJoe.diag(dataSet.getDoubleData());
    }

    public static DenseDoubleMatrix2D diag(CovarianceMatrix covMatrix) {
        return FactorAnalysisJoe.diag(covMatrix.getMatrix());
    }

    public static DenseDoubleMatrix2D diag(CorrelationMatrix corMatrix) {
        return FactorAnalysisJoe.diag(corMatrix.getMatrix());
    }

    public static DenseDoubleMatrix2D matrixSubtract(DenseDoubleMatrix2D a, DenseDoubleMatrix2D b) {
        if (a.columns() != b.columns() || a.rows() != b.rows()) {
            throw new IllegalArgumentException();
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < result.rows(); ++i) {
            for (int j = 0; j < result.columns(); ++j) {
                result.set(i, j, a.get(i, j) - b.get(i, j));
            }
        }
        return result;
    }

    public static DenseDoubleMatrix2D matrixMult(DenseDoubleMatrix2D a, DenseDoubleMatrix2D b) {
        if (a.columns() != b.rows()) {
            throw new IllegalArgumentException();
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), b.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < b.columns(); ++j) {
                double value = 0.0;
                for (int k = 0; k < b.rows(); ++k) {
                    value += a.get(i, k) * b.get(k, j);
                }
                result.set(i, j, value);
            }
        }
        return result;
    }

    public static DenseDoubleMatrix2D matrixMult(double scalar, DenseDoubleMatrix2D a) {
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                result.set(i, j, scalar * a.get(i, j));
            }
        }
        return result;
    }

    public static DenseDoubleMatrix2D matrixAdd(DenseDoubleMatrix2D a, DenseDoubleMatrix2D b) {
        if (a.rows() != b.rows() || a.columns() != b.columns()) {
            throw new IllegalArgumentException();
        }
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                result.set(i, j, a.get(i, j) + b.get(i, j));
            }
        }
        return result;
    }

    public static DenseDoubleMatrix2D matrixDiv(double scalar, DenseDoubleMatrix2D a) {
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                result.set(i, j, a.get(i, j) / scalar);
            }
        }
        return result;
    }

    public static DenseDoubleMatrix2D transpose(DenseDoubleMatrix2D a) {
        DenseDoubleMatrix2D result = new DenseDoubleMatrix2D(a.columns(), a.rows());
        for (int i = 0; i < a.columns(); ++i) {
            for (int j = 0; j < a.rows(); ++j) {
                result.set(i, j, a.get(j, i));
            }
        }
        return result;
    }

    public static double trace(DenseDoubleMatrix2D a) {
        double result = 0.0;
        for (int i = 0; i < a.columns(); ++i) {
            result += a.get(i, i);
        }
        return result;
    }

    public static double vectorSum(Vector<Double> vector) {
        double sum = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            sum += vector.get(i).doubleValue();
        }
        return sum;
    }
}

