/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.GeneralizedExpressionEditor;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class GeneralizedSemPmGraphicalEditor
extends JPanel {
    private static Font SMALL_FONT = new Font("Dialog", 0, 10);
    private GeneralizedSemPm semPm;
    private GraphWorkbench workbench;
    private Map<Object, EditorWindow> launchedEditors = new HashMap<Object, EditorWindow>();

    public GeneralizedSemPmGraphicalEditor(GeneralizedSemPm semPm, Map<Object, EditorWindow> launchedEditors) {
        this.semPm = semPm;
        this.launchedEditors = launchedEditors;
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.workbench());
        scroll.setPreferredSize(new Dimension(450, 450));
        this.add((Component)scroll, "Center");
        this.setBorder(new TitledBorder("Double click expressions to edit"));
    }

    private void beginNodeEdit(final Node node) {
        if (this.launchedEditors.keySet().contains(node)) {
            this.launchedEditors.get(node).moveToFront();
            return;
        }
        final GeneralizedExpressionEditor paramEditor = new GeneralizedExpressionEditor(this.semPm, node);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)paramEditor, "Center");
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        final EditorWindow editorWindow = new EditorWindow(panel, "Edit Expression", "OK", true, this);
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.pack();
        editorWindow.setVisible(true);
        this.launchedEditors.put(node, editorWindow);
        editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                if (!editorWindow.isCanceled()) {
                    String expressionString = paramEditor.getExpressionString();
                    try {
                        GeneralizedSemPmGraphicalEditor.this.semPm.setNodeExpression(node, expressionString);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        GeneralizedSemPmGraphicalEditor.this.launchedEditors.remove(node);
                        throw new RuntimeException("The expression editor returned an unparseable string: " + expressionString, e);
                    }
                    GeneralizedSemPmGraphicalEditor.this.refreshLabels();
                    GeneralizedSemPmGraphicalEditor.this.firePropertyChange("modelChanged", null, null);
                }
                GeneralizedSemPmGraphicalEditor.this.launchedEditors.remove(node);
            }
        });
    }

    private GeneralizedSemPm semPm() {
        return this.semPm;
    }

    private Graph graph() {
        return this.semPm().getGraph();
    }

    private GraphWorkbench workbench() {
        if (this.getWorkbench() == null) {
            this.workbench = new GraphWorkbench(this.graph());
            this.getWorkbench().setAllowDoubleClickActions(false);
            this.refreshLabels();
            this.addMouseListenerToGraphNodesMeasured();
        }
        return this.getWorkbench();
    }

    public void refreshLabels() {
        List<Node> nodes = this.graph().getNodes();
        for (Node node : nodes) {
            this.resetNodeLabel(node);
        }
        this.workbench().repaint();
    }

    private void resetNodeLabel(Node node) {
        int maxExpressionLength = Preferences.userRoot().getInt("maxExpressionLength", 25);
        String expressionString = this.semPm.getNodeExpressionString(node);
        if (expressionString.length() > maxExpressionLength) {
            expressionString = "- long formula -";
        }
        if (expressionString == null) {
            this.workbench().setNodeLabel(node, null, 0, 0);
        } else {
            JLabel label = new JLabel();
            label.setForeground(Color.BLACK);
            label.setBackground(Color.WHITE);
            label.setText(expressionString);
            label.addMouseListener(new NodeMouseListener(node, this));
            if (node.getNodeType() == NodeType.ERROR) {
                label.setOpaque(false);
                if (this.workbench().getGraph().containsNode(node)) {
                    this.workbench().setNodeLabel(node, label, 15, 2);
                }
            } else {
                label.setOpaque(true);
                if (this.workbench().getGraph().containsNode(node)) {
                    this.workbench().setNodeLabel(node, label, 31, 4);
                }
            }
        }
        this.firePropertyChange("modelChanged", null, null);
    }

    private void addMouseListenerToGraphNodesMeasured() {
        List<Node> nodes = this.graph().getNodes();
    }

    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    private static final class NodeMouseListener
    extends MouseAdapter {
        private Node node;
        private GeneralizedSemPmGraphicalEditor editor;

        public NodeMouseListener(Node node, GeneralizedSemPmGraphicalEditor editor) {
            this.node = node;
            this.editor = editor;
        }

        private Node getNode() {
            return this.node;
        }

        private GeneralizedSemPmGraphicalEditor getEditor() {
            return this.editor;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.getEditor().beginNodeEdit(this.getNode());
            }
        }
    }
}

