/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.PointXy;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.editor.AllPathsAction;
import edu.cmu.tetradapp.editor.CopySubgraphAction;
import edu.cmu.tetradapp.editor.DirectedPathsAction;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.GraphFileMenu;
import edu.cmu.tetradapp.editor.GraphPropertiesAction;
import edu.cmu.tetradapp.editor.GraphToolbar;
import edu.cmu.tetradapp.editor.IndependenceFactsAction;
import edu.cmu.tetradapp.editor.NeighborhoodsAction;
import edu.cmu.tetradapp.editor.PasteSubgraphAction;
import edu.cmu.tetradapp.editor.RandomGraphEditor;
import edu.cmu.tetradapp.editor.RandomMimParamsEditor;
import edu.cmu.tetradapp.editor.SelectBidirectedAction;
import edu.cmu.tetradapp.editor.SelectUndirectedAction;
import edu.cmu.tetradapp.editor.TreksAction;
import edu.cmu.tetradapp.model.ChooseDagGraphWrapper;
import edu.cmu.tetradapp.model.CompletedPatternWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.LayoutMenu;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;

public final class GraphEditor
extends JPanel
implements GraphEditable,
LayoutEditable,
IndTestProducer {
    private final GraphWorkbench workbench;
    private GraphWrapper graphWrapper;

    public GraphEditor(GraphWrapper graphWrapper) {
        this(graphWrapper.getGraph());
        this.graphWrapper = graphWrapper;
        this.getWorkbench().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graph".equals(evt.getPropertyName())) {
                    GraphEditor.this.getGraphWrapper().setGraph((Graph)evt.getNewValue());
                } else if ("modelChanged".equals(evt.getPropertyName())) {
                    GraphEditor.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
    }

    public GraphEditor(ChooseDagGraphWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public GraphEditor(CompletedPatternWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public GraphEditor(Graph graph) {
        this.setLayout(new BorderLayout());
        this.workbench = new GraphWorkbench(graph);
        GraphToolbar toolbar = new GraphToolbar(this.getWorkbench());
        JMenuBar menuBar = this.createGraphMenuBar();
        JScrollPane scroll = new JScrollPane(this.getWorkbench());
        scroll.setPreferredSize(new Dimension(450, 450));
        this.add((Component)scroll, "Center");
        this.add((Component)toolbar, "West");
        this.add((Component)menuBar, "North");
        JLabel label = new JLabel("Double click variable to change name.");
        label.setFont(new Font("SansSerif", 0, 12));
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalStrut(2));
        b.add(label);
        b.add(Box.createHorizontalGlue());
        b.setBorder(new MatteBorder(0, 0, 1, 0, Color.GRAY));
        this.add((Component)b, "South");
        this.getWorkbench().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("graph".equals(propertyName)) {
                    Graph _graph = (Graph)evt.getNewValue();
                    if (GraphEditor.this.getWorkbench() != null) {
                        GraphEditor.this.getGraphWrapper().setGraph(_graph);
                    }
                }
            }
        });
    }

    @Override
    public final void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public List getSelectedModelComponents() {
        List<Component> selectedComponents = this.getWorkbench().getSelectedComponents();
        ArrayList<TetradSerializable> selectedModelComponents = new ArrayList<TetradSerializable>();
        for (Component comp : selectedComponents) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (int i = 0; i < sessionElements.size(); ++i) {
            Object o = sessionElements.get(i);
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public Graph getGraph() {
        return this.getWorkbench().getGraph();
    }

    @Override
    public void setGraph(Graph graph) {
        this.getWorkbench().setGraph(graph);
    }

    @Override
    public Knowledge getKnowledge() {
        return null;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getWorkbench().getGraph();
    }

    @Override
    public void layoutByGraph(Graph graph) {
        this.getWorkbench().layoutByGraph(graph);
    }

    @Override
    public void layoutByKnowledge() {
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.getWorkbench().getVisibleRect();
    }

    private GraphWrapper getGraphWrapper() {
        return this.graphWrapper;
    }

    private JMenuBar createGraphMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        GraphFileMenu fileMenu = new GraphFileMenu(this, this.getWorkbench());
        JMenu editMenu = this.createEditMenu();
        JMenu graphMenu = this.createGraphMenu();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(graphMenu);
        menuBar.add(new LayoutMenu(this));
        return menuBar;
    }

    private JMenu createEditMenu() {
        JMenu edit = new JMenu("Edit");
        JMenuItem copy = new JMenuItem(new CopySubgraphAction(this));
        JMenuItem paste = new JMenuItem(new PasteSubgraphAction(this));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        edit.add(copy);
        edit.add(paste);
        return edit;
    }

    private JMenu createGraphMenu() {
        JMenu graph = new JMenu("Graph");
        graph.add(new GraphPropertiesAction(this.getWorkbench()));
        graph.add(new DirectedPathsAction(this.getWorkbench()));
        graph.add(new TreksAction(this.getWorkbench()));
        graph.add(new AllPathsAction(this.getWorkbench()));
        graph.add(new NeighborhoodsAction(this.getWorkbench()));
        graph.addSeparator();
        JMenuItem correlateExogenous = new JMenuItem("Correlate Exogenous Variables");
        JMenuItem uncorrelateExogenous = new JMenuItem("Uncorrelate Exogenous Variables");
        graph.add(correlateExogenous);
        graph.add(uncorrelateExogenous);
        graph.addSeparator();
        correlateExogenous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.correlateExogenousVariables();
                GraphEditor.this.getWorkbench().invalidate();
                GraphEditor.this.getWorkbench().repaint();
            }
        });
        uncorrelateExogenous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.uncorrelationExogenousVariables();
                GraphEditor.this.getWorkbench().invalidate();
                GraphEditor.this.getWorkbench().repaint();
            }
        });
        JMenuItem randomGraph = new JMenuItem("Random Graph");
        graph.add(randomGraph);
        randomGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomGraphEditor editor = new RandomGraphEditor(GraphEditor.this.workbench.getGraph(), true);
                int ret = JOptionPane.showConfirmDialog(GraphEditor.this, editor, "Edit Random DAG Parameters", -1);
                if (ret == 0) {
                    Graph graph = null;
                    Dag dag = new Dag();
                    int numTrials = 0;
                    while (graph == null && ++numTrials < 100) {
                        if (editor.isUniformlySelected()) {
                            if (GraphEditor.this.getGraph().getNumNodes() == editor.getNumNodes()) {
                                HashMap<String, PointXy> layout = GraphUtils.grabLayout(GraphEditor.this.workbench.getGraph().getNodes());
                                dag = GraphUtils.randomDag(GraphEditor.this.getGraph().getNodes(), editor.getNumLatents(), editor.getMaxEdges(), editor.getMaxDegree(), editor.getMaxIndegree(), editor.getMaxOutdegree(), editor.isConnected());
                                GraphUtils.arrangeBySourceGraph(dag, GraphEditor.this.getWorkbench().getGraph());
                                GraphUtils.arrangeByLayout(dag, layout);
                            } else {
                                dag = GraphUtils.randomDag(editor.getNumNodes(), editor.getNumLatents(), editor.getMaxEdges(), editor.getMaxDegree(), editor.getMaxIndegree(), editor.getMaxOutdegree(), editor.isConnected());
                            }
                        } else {
                            do {
                                if (GraphEditor.this.getGraph().getNumNodes() == editor.getNumNodes()) {
                                    HashMap<String, PointXy> layout = GraphUtils.grabLayout(GraphEditor.this.workbench.getGraph().getNodes());
                                    dag = GraphUtils.randomDag(GraphEditor.this.getGraph().getNodes(), editor.getNumLatents(), editor.getMaxEdges(), 30, 15, 15, editor.isConnected());
                                    GraphUtils.arrangeByLayout(dag, layout);
                                    continue;
                                }
                                dag = GraphUtils.randomDag(editor.getNumNodes(), editor.getNumLatents(), editor.getMaxEdges(), 30, 15, 15, editor.isConnected());
                            } while (dag.getNumEdges() < editor.getMaxEdges());
                        }
                        boolean addCycles = editor.isAddCycles();
                        if (addCycles) {
                            int minNumCycles = editor.getMinNumCycles();
                            int minCycleLength = editor.getMinCycleLength();
                            graph = GraphUtils.addCycles2(dag, minNumCycles, minCycleLength);
                            continue;
                        }
                        graph = new EdgeListGraph(dag);
                    }
                    if (graph == null) {
                        JOptionPane.showMessageDialog(GraphEditor.this, "Could not find a graph that fits those constrains.");
                        GraphEditor.this.getWorkbench().setGraph(new EdgeListGraph(dag));
                    } else {
                        GraphEditor.this.getWorkbench().setGraph(graph);
                    }
                }
            }
        });
        JMenuItem randomIndicatorModel = new JMenuItem("Random Multiple Indicator Model");
        graph.add(randomIndicatorModel);
        randomIndicatorModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomMimParamsEditor editor = new RandomMimParamsEditor();
                int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), editor, "Edit Random MIM Parameters", 2, -1);
                if (ret == 0) {
                    int numStructuralNodes = Preferences.userRoot().getInt("numStructuralNodes", 3);
                    int maxStructuralEdges = Preferences.userRoot().getInt("numStructuralEdges", 3);
                    int measurementModelDegree = Preferences.userRoot().getInt("measurementModelDegree", 3);
                    int numLatentMeasuredImpureParents = Preferences.userRoot().getInt("latentMeasuredImpureParents", 0);
                    int numMeasuredMeasuredImpureParents = Preferences.userRoot().getInt("measuredMeasuredImpureParents", 0);
                    int numMeasuredMeasuredImpureAssociations = Preferences.userRoot().getInt("measuredMeasuredImpureAssociations", 0);
                    Graph graph = GraphUtils.randomMim(numStructuralNodes, maxStructuralEdges, measurementModelDegree, numLatentMeasuredImpureParents, numMeasuredMeasuredImpureParents, numMeasuredMeasuredImpureAssociations);
                    GraphEditor.this.getWorkbench().setGraph(graph);
                }
            }
        });
        graph.addSeparator();
        graph.add(new JMenuItem(new SelectBidirectedAction(this.getWorkbench())));
        graph.add(new JMenuItem(new SelectUndirectedAction(this.getWorkbench())));
        graph.addSeparator();
        IndependenceFactsAction action = new IndependenceFactsAction(JOptionUtils.centeringComp(), this, "D Separation Facts...");
        graph.add(action);
        return graph;
    }

    private void correlateExogenousVariables() {
        int i;
        Graph graph = this.getWorkbench().getGraph();
        if (graph instanceof Dag) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Cannot add bidirected edges to DAG's.");
            return;
        }
        List<Node> nodes = graph.getNodes();
        LinkedList<Node> exoNodes = new LinkedList<Node>();
        for (i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!graph.isExogenous(node)) continue;
            exoNodes.add(node);
        }
        for (i = 0; i < exoNodes.size(); ++i) {
            block2: for (int j = i + 1; j < exoNodes.size(); ++j) {
                Node node1 = (Node)exoNodes.get(i);
                Node node2 = (Node)exoNodes.get(j);
                List<Edge> edges = graph.getEdges(node1, node2);
                for (int k = 0; k < edges.size(); ++k) {
                    Edge edge = edges.get(k);
                    if (Edges.isBidirectedEdge(edge)) continue block2;
                }
                graph.addBidirectedEdge(node1, node2);
            }
        }
    }

    private void uncorrelationExogenousVariables() {
        Graph graph = this.getWorkbench().getGraph();
        List<Edge> edges = graph.getEdges();
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.get(i);
            if (!Edges.isBidirectedEdge(edge)) continue;
            try {
                graph.removeEdge(edge);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        Graph graph = this.getWorkbench().getGraph();
        EdgeListGraph listGraph = new EdgeListGraph(graph);
        return new IndTestDSep(listGraph);
    }
}

