/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.Histogram;
import edu.cmu.tetradapp.editor.HistogramDisplayPanel;
import edu.cmu.tetradapp.editor.HistogramEditorPanel;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HistogramAction
extends AbstractAction {
    private DataEditor dataEditor;

    public HistogramAction(DataEditor editor) {
        super("Histograms...");
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        if (dataSet == null || dataSet.getNumColumns() == 0) {
            JOptionPane.showMessageDialog(this.findOwner(), "Cannot display a histogram for an empty data set.");
            return;
        }
        int[] selected = dataSet.getSelectedIndices();
        if (selected != null && 1 < selected.length) {
            int option;
            if (10 < selected.length && (option = JOptionPane.showConfirmDialog(this.findOwner(), "You are about to open " + selected.length + " histograms, are you sure you want to proceed?", "Histogram Warning", 0)) == 1) {
                return;
            }
            for (int index : selected) {
                JPanel component = this.createHistogramPanel(dataSet.getVariable(index));
                EditorWindow editorWindow = new EditorWindow(component, "Histogram", "Close", false, this.dataEditor);
                DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
                editorWindow.pack();
                editorWindow.setVisible(true);
            }
        } else {
            JPanel component = this.createHistogramPanel(null);
            EditorWindow editorWindow = new EditorWindow(component, "Histogram", "Close", false, this.dataEditor);
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
        }
    }

    private void setLocation(JDialog dialog, int index) {
        Rectangle bounds = dialog.getBounds();
        JFrame frame = this.findOwner();
        Dimension dim = frame == null ? Toolkit.getDefaultToolkit().getScreenSize() : frame.getSize();
        int x = (int)(150.0 * Math.cos((double)(index * 15) * (Math.PI / 180)));
        int y = (int)(150.0 * Math.sin((double)(index * 15) * (Math.PI / 180)));
        dialog.setLocation(x += (dim.width - bounds.width) / 2, y += (dim.height - bounds.height) / 2);
    }

    private JPanel createHistogramPanel(Node selected) {
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        Histogram histogram = new Histogram(dataSet, selected, 12);
        HistogramEditorPanel editorPanel = new HistogramEditorPanel(histogram, dataSet);
        HistogramDisplayPanel display = new HistogramDisplayPanel(histogram);
        editorPanel.addPropertyChangeListener(new HistogramListener(display));
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem(new SaveComponentImage(display, "Save Histogram")));
        bar.add(menu);
        Box box = Box.createHorizontalBox();
        box.add(display);
        box.add(Box.createHorizontalStrut(3));
        box.add(editorPanel);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)vBox, "Center");
        return panel;
    }

    private JFrame findOwner() {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.dataEditor);
    }

    private static class HistogramListener
    implements PropertyChangeListener {
        private HistogramDisplayPanel display;

        public HistogramListener(HistogramDisplayPanel display) {
            this.display = display;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("histogramChange".equals(evt.getPropertyName())) {
                this.display.updateHistogram((Histogram)evt.getNewValue());
            }
        }
    }
}

