/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.Histogram;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class HistogramConditionEditorPanel
extends JPanel {
    private final List<DiscreteVariable> variables;
    private final Box variablePanel = Box.createVerticalBox();
    private final List<JComboBox> variableBoxes = new LinkedList<JComboBox>();
    private final List<JComboBox> variableValueBoxes = new LinkedList<JComboBox>();
    private final List<JCheckBox> checkBoxes = new LinkedList<JCheckBox>();
    private final List<Box> row = new LinkedList<Box>();
    private int forbidden = -1;
    private final Box buttonBox = Box.createHorizontalBox();

    public HistogramConditionEditorPanel(List<DiscreteVariable> variables, Node selected) {
        if (variables == null) {
            throw new NullPointerException("Given value(s) null");
        }
        if (selected instanceof DiscreteVariable) {
            this.forbidden = variables.indexOf(selected);
        }
        this.variables = variables;
        TitledBorder border = new TitledBorder("Condition on");
        border.setTitleColor(Color.BLACK);
        this.variablePanel.setBorder(border);
        this.setLayout(new BoxLayout(this, 1));
        JButton add = HistogramConditionEditorPanel.createButton("Add Condition");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramConditionEditorPanel.this.addSelectionBox();
                HistogramConditionEditorPanel.this.fireDependencyChange();
            }
        });
        JButton remove = HistogramConditionEditorPanel.createButton("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramConditionEditorPanel.this.removeDependencies();
            }
        });
        this.buttonBox.add(Box.createHorizontalGlue());
        this.buttonBox.add(Box.createHorizontalStrut(3));
        this.buttonBox.add(add);
        this.buttonBox.add(Box.createHorizontalStrut(3));
        this.buttonBox.add(remove);
        this.buttonBox.add(Box.createHorizontalStrut(3));
        this.buttonBox.add(Box.createHorizontalGlue());
        this.variablePanel.add(this.buttonBox);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.variablePanel);
        box2.add(Box.createHorizontalStrut(10));
        this.add(box2);
    }

    public void updateVariable(Node node) {
        this.forbidden = node instanceof DiscreteVariable ? this.variables.indexOf(node) : -1;
        this.removeAllConditions();
        this.revalidate();
        this.repaint();
    }

    private static JButton createButton(String text) {
        JButton button = new JButton(text);
        button.setMargin(new Insets(2, 5, 2, 5));
        Font current = button.getFont();
        button.setFont(current.deriveFont(0, 10.0f));
        return button;
    }

    private synchronized void fireDependencyChange() {
        HashMap<Node, ArrayList<String>> map = new HashMap<Node, ArrayList<String>>(this.variableBoxes.size());
        for (int i = 0; i < this.variableBoxes.size(); ++i) {
            JComboBox box = this.variableBoxes.get(i);
            JComboBox valuesBox = this.variableValueBoxes.get(i);
            Object selected = box.getSelectedItem();
            Object selectedValue = valuesBox.getSelectedItem();
            if (selected == null || selectedValue == null) continue;
            Node variable = (Node)selected;
            ArrayList<String> values = (ArrayList<String>)map.get(variable);
            if (values == null) {
                values = new ArrayList<String>(3);
                values.add(selectedValue.toString());
                map.put(variable, values);
                continue;
            }
            values.add(selectedValue.toString());
        }
        ArrayList<Histogram.ConditionalDependency> nodes = new ArrayList<Histogram.ConditionalDependency>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            List value = (List)entry.getValue();
            nodes.add(new Histogram.ConditionalDependency((Node)entry.getKey(), value));
        }
        this.firePropertyChange("changeDependencies", null, nodes);
    }

    private synchronized void removeDependencies() {
        for (int i = this.checkBoxes.size() - 1; 0 <= i; --i) {
            JCheckBox checkBox = this.checkBoxes.get(i);
            if (!checkBox.isSelected()) continue;
            this.removeComponents(i);
        }
        this.variablePanel.revalidate();
        this.revalidate();
        this.repaint();
        this.fireDependencyChange();
    }

    private void removeComponents(int i) {
        this.checkBoxes.remove(i);
        this.variableBoxes.remove(i);
        this.variableValueBoxes.remove(i);
        Box box = this.row.remove(i);
        this.variablePanel.remove(box);
    }

    private void removeAllConditions() {
        for (int i = this.row.size() - 1; 0 <= i; --i) {
            this.removeComponents(i);
        }
    }

    private int availableVariableSize() {
        if (this.forbidden == -1) {
            return this.variables.size();
        }
        return this.variables.size() - 1;
    }

    private boolean addSelectionBox() {
        if (this.variableBoxes.size() < this.availableVariableSize()) {
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(Box.createHorizontalStrut(5));
            JComboBox variableBox = this.createVariableBox(this.variables);
            this.variableBoxes.add(variableBox);
            int anIndex = this.variableBoxes.size() - 1;
            variableBox.setSelectedIndex(anIndex);
            variableBox.addItemListener(new ConditionItemListener());
            box.add(variableBox);
            box.add(new JLabel(" = "));
            JComboBox comboBox = HistogramConditionEditorPanel.createVariableValuesBox(this.variables.get(anIndex));
            comboBox.addItemListener(new ConditionItemListener());
            this.variableValueBoxes.add(comboBox);
            HistogramConditionEditorPanel.setPreferredAsMax(comboBox);
            box.add(comboBox);
            box.add(Box.createHorizontalStrut(10));
            JCheckBox checkBox = new JCheckBox();
            this.checkBoxes.add(checkBox);
            box.add(checkBox);
            box.add(Box.createHorizontalStrut(5));
            box.add(Box.createHorizontalGlue());
            this.row.add(box);
            this.variablePanel.add(box);
            this.variablePanel.remove(this.buttonBox);
            this.variablePanel.add(this.buttonBox);
            this.variablePanel.revalidate();
            this.revalidate();
            this.repaint();
            return true;
        }
        return false;
    }

    private static JComboBox createVariableValuesBox(DiscreteVariable variable) {
        JComboBox<String> box = new JComboBox<String>();
        for (String c : variable.getCategories()) {
            box.addItem(c);
        }
        HistogramConditionEditorPanel.setPreferredAsMax(box);
        return box;
    }

    private JComboBox createVariableBox(List<DiscreteVariable> variables) {
        JComboBox<Object> box = new JComboBox<Object>();
        for (int i = 0; i < variables.size(); ++i) {
            if (this.forbidden == i) continue;
            box.addItem(variables.get(i));
        }
        box.setRenderer(new VariableBoxRenderer());
        HistogramConditionEditorPanel.setPreferredAsMax(box);
        return box;
    }

    private static void setPreferredAsMax(JComponent component) {
        component.setMaximumSize(component.getPreferredSize());
    }

    private static class VariableBoxRenderer
    extends DefaultListCellRenderer {
        private VariableBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Node node = (Node)value;
            if (node == null) {
                this.setText("");
            } else {
                this.setText(node.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class ConditionItemListener
    implements ItemListener {
        private ConditionItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                HistogramConditionEditorPanel.this.fireDependencyChange();
            }
        }
    }
}

