/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.Histogram;
import edu.cmu.tetradapp.editor.HistogramConditionEditorPanel;
import edu.cmu.tetradapp.util.IntSpinner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HistogramEditorPanel
extends JPanel {
    private JComboBox variableBox;
    private JComboBox conditionalVariableBox;
    private JComboBox conditionalValuesBox;
    public IntSpinner categorySelector;
    public IntSpinner outlierHandler;
    public JLabel outlierLabel1;
    public JLabel outlierLabel2;
    public Histogram originalHistogram;
    private DataSet dataSet;
    private LinkedList<DiscreteVariable> variables = new LinkedList();
    private HistogramConditionEditorPanel conditionEditor;
    private Histogram histogram;
    public Box editArea;

    public HistogramEditorPanel(Histogram histogram, DataSet dataSet) {
        this.outlierHandler = new IntSpinner(0, 1, 4);
        this.outlierHandler.setMin(0);
        this.outlierHandler.setMax(100);
        this.outlierLabel1 = new JLabel("Cull bins that contain under ");
        this.outlierLabel2 = new JLabel(" % of the data.");
        this.setLayout(new BorderLayout());
        this.histogram = histogram;
        this.originalHistogram = histogram;
        Node selected = histogram.getSelectedVariable();
        this.dataSet = dataSet;
        this.variableBox = new JComboBox();
        this.conditionalVariableBox = new JComboBox();
        this.conditionalValuesBox = new JComboBox();
        VariableBoxRenderer renderer = new VariableBoxRenderer();
        this.variableBox.setRenderer(renderer);
        this.conditionalVariableBox.setRenderer(renderer);
        for (Node node : dataSet.getVariables()) {
            this.variableBox.addItem(node);
            if (node == selected) {
                this.variableBox.setSelectedItem(node);
            }
            if (!(node instanceof DiscreteVariable)) continue;
            this.variables.add((DiscreteVariable)node);
        }
        this.variableBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Node node = (Node)e.getItem();
                    if (HistogramEditorPanel.this.conditionEditor != null) {
                        HistogramEditorPanel.this.conditionEditor.updateVariable(node);
                    }
                    Histogram newValue = new Histogram(HistogramEditorPanel.this.dataSet, node, HistogramEditorPanel.this.getHistogram().getNumberOfCategories());
                    HistogramEditorPanel.this.categorySelector.setValue(newValue.getNumberOfCategories());
                    HistogramEditorPanel.this.changeHistogram(newValue);
                }
            }
        });
        this.categorySelector = new IntSpinner(histogram.getNumberOfCategories(), 1, 3);
        this.categorySelector.setMin(2);
        this.categorySelector.setMax(HistogramEditorPanel.getMaxCategoryValue(histogram));
        this.categorySelector.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner s = (JSpinner)e.getSource();
                Integer cat = (Integer)s.getValue();
                if (cat.intValue() != HistogramEditorPanel.this.getHistogram().getNumberOfCategories()) {
                    HistogramEditorPanel.this.changeHistogram(new Histogram(HistogramEditorPanel.this.getHistogram(), cat));
                    HistogramEditorPanel.this.outlierHandler.setValue(0);
                }
            }
        });
        this.outlierHandler.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double ratio;
                double percentageOfDataInBin;
                int numBins;
                JSpinner s = (JSpinner)e.getSource();
                Integer percentage = (Integer)s.getValue();
                Histogram current = HistogramEditorPanel.this.getOriginalHistogram();
                int[] frequencies = current.getFrequencies();
                int dataSetSize = current.getDataSet().getNumRows();
                int originalNumBins = numBins = current.getNumberOfCategories() - 1;
                while (numBins >= 0 && !((percentageOfDataInBin = (double)frequencies[numBins] / (double)dataSetSize) >= (ratio = (double)percentage.intValue() / 100.0))) {
                    --numBins;
                }
                if (numBins <= 0) {
                    HistogramEditorPanel.this.outlierHandler.setValue((Integer)HistogramEditorPanel.this.outlierHandler.getValue() - 1);
                } else if (originalNumBins != numBins) {
                    HistogramEditorPanel.this.changeHistogram(new Histogram(current, numBins + 1));
                    HistogramEditorPanel.this.categorySelector.setValue(numBins + 1);
                }
            }
        });
        this.editArea = this.buildEditArea();
        this.add((Component)this.editArea, "Center");
    }

    public Histogram getOriginalHistogram() {
        return this.originalHistogram;
    }

    private static int getMaxCategoryValue(Histogram histogram) {
        Node node = histogram.getSelectedVariable();
        if (node instanceof DiscreteVariable) {
            DiscreteVariable var = (DiscreteVariable)node;
            int categories = var.getCategories().size();
            return Math.max(categories, 2);
        }
        return 20;
    }

    private Histogram getHistogram() {
        return this.histogram;
    }

    private void changeHistogram(Histogram histogram) {
        this.histogram = histogram;
        this.categorySelector.setMax(HistogramEditorPanel.getMaxCategoryValue(histogram));
        this.firePropertyChange("histogramChange", null, histogram);
    }

    private static void setPreferredAsMax(JComponent component) {
        component.setMaximumSize(component.getPreferredSize());
    }

    private Box buildEditArea() {
        HistogramEditorPanel.setPreferredAsMax(this.variableBox);
        HistogramEditorPanel.setPreferredAsMax(this.conditionalVariableBox);
        HistogramEditorPanel.setPreferredAsMax(this.conditionalValuesBox);
        HistogramEditorPanel.setPreferredAsMax(this.categorySelector);
        HistogramEditorPanel.setPreferredAsMax(this.outlierHandler);
        HistogramEditorPanel.setPreferredAsMax(this.outlierLabel1);
        HistogramEditorPanel.setPreferredAsMax(this.outlierLabel2);
        Box main = Box.createVerticalBox();
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(new JLabel("Select Variable: "));
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(this.variableBox);
        hBox.add(Box.createHorizontalGlue());
        main.add(hBox);
        main.add(Box.createVerticalStrut(5));
        Box hBox2 = Box.createHorizontalBox();
        hBox2.add(Box.createHorizontalStrut(10));
        hBox2.add(new JLabel("# Bars: "));
        hBox2.add(this.categorySelector);
        hBox2.add(Box.createHorizontalGlue());
        main.add(hBox2);
        main.add(Box.createVerticalStrut(5));
        if (0 < this.variables.size()) {
            this.conditionEditor = new HistogramConditionEditorPanel(new ArrayList<DiscreteVariable>(this.variables), this.histogram.getSelectedVariable());
            this.conditionEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("changeDependencies".equals(evt.getPropertyName())) {
                        Histogram histogram = new Histogram(HistogramEditorPanel.this.histogram, (List)evt.getNewValue());
                        HistogramEditorPanel.this.changeHistogram(histogram);
                    }
                }
            });
            main.add(this.conditionEditor);
        }
        Box hBox3 = Box.createHorizontalBox();
        hBox3.add(this.outlierLabel1);
        hBox3.add(this.outlierHandler);
        hBox3.add(this.outlierLabel2);
        main.add(hBox3);
        main.add(Box.createVerticalStrut(10));
        main.add(Box.createVerticalGlue());
        return main;
    }

    private static class VariableBoxRenderer
    extends DefaultListCellRenderer {
        private VariableBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Node node = (Node)value;
            if (node == null) {
                this.setText("");
            } else {
                this.setText(node.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

