/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class IndependenceFactsAction
extends AbstractAction {
    private static NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private Component centeringComp;
    private LinkedList<String> vars;
    private JTextField textField;
    private IndTestProducer indTestProducer;
    private List<Result> results = new ArrayList<Result>();
    private AbstractTableModel tableModel;
    private IndependenceTest independenceTest;
    private int sortDir;
    private int lastSortCol;

    public IndependenceFactsAction(Component comp, IndTestProducer indTestProducer, String menuName) {
        super(menuName);
        if (indTestProducer == null) {
            throw new NullPointerException();
        }
        this.centeringComp = comp;
        this.indTestProducer = indTestProducer;
        this.vars = new LinkedList();
        this.textField = new JTextField(40);
        this.textField.setEditable(false);
        this.textField.setFont(new Font("Serif", 1, 14));
        this.textField.setBackground(new Color(250, 250, 250));
        this.resetText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.independenceTest = this.getIndTestProducer().getIndependenceTest();
        final ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("VAR");
        varNames.addAll(this.getDataVars());
        varNames.add("?");
        varNames.add("+");
        final JComboBox<String> variableBox = new JComboBox<String>();
        DefaultComboBoxModel<String> aModel1 = new DefaultComboBoxModel<String>(varNames.toArray(new String[0]));
        aModel1.setSelectedItem("VAR");
        variableBox.setModel(aModel1);
        variableBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                String var = (String)box.getSelectedItem();
                LinkedList vars = IndependenceFactsAction.this.getVars();
                int size = vars.size();
                if ("VAR".equals(var)) {
                    return;
                }
                if ("?".equals(var)) {
                    if (size >= 0 && !vars.contains("+")) {
                        vars.addLast(var);
                    }
                } else if ("+".equals(var)) {
                    if (size >= 2) {
                        vars.addLast(var);
                    }
                } else if (vars.indexOf("?") < 2 && !vars.contains("+") && !vars.contains(var)) {
                    vars.add(var);
                }
                IndependenceFactsAction.this.resetText();
                DefaultComboBoxModel<String> aModel = new DefaultComboBoxModel<String>(varNames.toArray(new String[0]));
                aModel.setSelectedItem("VAR");
                variableBox.setModel(aModel);
            }
        });
        JButton delete = new JButton("Delete");
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!IndependenceFactsAction.this.getVars().isEmpty()) {
                    IndependenceFactsAction.this.getVars().removeLast();
                    IndependenceFactsAction.this.resetText();
                }
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ('?' == e.getKeyChar()) {
                    variableBox.setSelectedItem("?");
                } else if ('+' == e.getKeyChar()) {
                    variableBox.setSelectedItem("+");
                } else if ('\b' == e.getKeyChar()) {
                    IndependenceFactsAction.this.vars.removeLast();
                    IndependenceFactsAction.this.resetText();
                }
                e.consume();
            }
        });
        delete.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ('?' == e.getKeyChar()) {
                    variableBox.setSelectedItem("?");
                } else if ('+' == e.getKeyChar()) {
                    variableBox.setSelectedItem("+");
                } else if ('\b' == e.getKeyChar()) {
                    IndependenceFactsAction.this.vars.removeLast();
                    IndependenceFactsAction.this.resetText();
                }
            }
        });
        variableBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                if ('\b' == e.getKeyChar()) {
                    IndependenceFactsAction.this.vars.removeLast();
                    IndependenceFactsAction.this.resetText();
                }
            }
        });
        JButton list = new JButton("LIST");
        list.setFont(new Font("Dialog", 1, 14));
        list.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndependenceFactsAction.this.generateResults();
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Test: "));
        b2.add(new JLabel(this.getIndependenceTest().toString()));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(10));
        Box b3 = Box.createHorizontalBox();
        b3.add(this.getTextField());
        b3.add(variableBox);
        b3.add(delete);
        b1.add(b3);
        b1.add(Box.createVerticalStrut(10));
        this.tableModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Index";
                }
                if (column == 1) {
                    if (IndependenceFactsAction.this.independenceTest instanceof IndTestDSep) {
                        return "D-Separation Relation";
                    }
                    return "Independence Relation";
                }
                if (column == 2) {
                    return "Judgment";
                }
                if (column == 3) {
                    return "P Value";
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                if (IndependenceFactsAction.this.usesDSeparation()) {
                    return 3;
                }
                return 4;
            }

            @Override
            public int getRowCount() {
                return IndependenceFactsAction.this.getResults().size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Result result = (Result)IndependenceFactsAction.this.getResults().get(rowIndex);
                if (columnIndex == 0) {
                    return result.getIndex() + 1;
                }
                if (columnIndex == 1) {
                    return result.getFact();
                }
                if (columnIndex == 2) {
                    if (IndependenceFactsAction.this.independenceTest instanceof IndTestDSep) {
                        if (result.getType() == Result.Type.INDEPENDENT) {
                            return "D-Separated";
                        }
                        if (result.getType() == Result.Type.DEPENDENT) {
                            return "D-Connected";
                        }
                        if (result.getType() == Result.Type.UNDETERMINED) {
                            return "*";
                        }
                    } else {
                        if (result.getType() == Result.Type.INDEPENDENT) {
                            return "Independent";
                        }
                        if (result.getType() == Result.Type.DEPENDENT) {
                            return "Dependent";
                        }
                        if (result.getType() == Result.Type.UNDETERMINED) {
                            return "*";
                        }
                    }
                } else if (columnIndex == 3) {
                    return nf.format(result.getpValue());
                }
                return null;
            }

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Number.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                if (columnIndex == 2) {
                    return Number.class;
                }
                if (columnIndex == 3) {
                    return Number.class;
                }
                return null;
            }
        };
        JTable table = new JTable(this.tableModel);
        table.getColumnModel().getColumn(0).setMinWidth(40);
        table.getColumnModel().getColumn(0).setMaxWidth(40);
        table.getColumnModel().getColumn(1).setMinWidth(200);
        table.getColumnModel().getColumn(2).setMinWidth(100);
        table.getColumnModel().getColumn(2).setMaxWidth(100);
        if (!this.usesDSeparation()) {
            table.getColumnModel().getColumn(3).setMinWidth(80);
            table.getColumnModel().getColumn(3).setMaxWidth(80);
        }
        JTableHeader header = table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTableHeader header = (JTableHeader)e.getSource();
                Point point = e.getPoint();
                int col = header.columnAtPoint(point);
                int sortCol = header.getTable().convertColumnIndexToModel(col);
                IndependenceFactsAction.this.sortByColumn(sortCol, true);
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(400, 400));
        b1.add(scroll);
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Limit list to "));
        IntTextField field = new IntTextField(this.getListLimit(), 7);
        field.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                try {
                    IndependenceFactsAction.this.setListLimit(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        b4.add(field);
        b4.add(new JLabel(" items."));
        b4.add(Box.createHorizontalGlue());
        b4.add(list);
        b1.add(b4);
        b1.add(Box.createVerticalStrut(10));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)b1, "Center");
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        EditorWindow editorWindow = new EditorWindow(panel, "Independence Facts", "Save", false, this.centeringComp);
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.setVisible(true);
        JRootPane root = SwingUtilities.getRootPane(editorWindow);
        if (root != null) {
            root.setDefaultButton(list);
        }
    }

    private Component getCenteringComp() {
        return this.centeringComp;
    }

    private boolean usesDSeparation() {
        return this.getIndependenceTest() instanceof IndTestDSep;
    }

    private void sortByColumn(final int sortCol, boolean allowReverse) {
        if (allowReverse && sortCol == this.getLastSortCol()) {
            this.setSortDir(-1 * this.getSortDir());
        } else {
            this.setSortDir(1);
        }
        this.setLastSortCol(sortCol);
        Collections.sort(this.results, new Comparator<Result>(){

            @Override
            public int compare(Result r1, Result r2) {
                switch (sortCol) {
                    case 0: {
                        return IndependenceFactsAction.this.getSortDir() * (r1.getIndex() - r2.getIndex());
                    }
                    case 1: {
                        return IndependenceFactsAction.this.getSortDir() * (r1.getIndex() - r2.getIndex());
                    }
                    case 2: {
                        int ind1 = r1.getType() == Result.Type.UNDETERMINED ? 0 : (r1.getType() == Result.Type.DEPENDENT ? 1 : 2);
                        int ind2 = r2.getType() == Result.Type.UNDETERMINED ? 0 : (r2.getType() == Result.Type.DEPENDENT ? 1 : 2);
                        return IndependenceFactsAction.this.getSortDir() * (ind1 - ind2);
                    }
                    case 3: {
                        double difference = (double)IndependenceFactsAction.this.getSortDir() * (r1.getpValue() - r2.getpValue());
                        if (difference < 0.0) {
                            return -1;
                        }
                        if (difference == 0.0) {
                            return 0;
                        }
                        return 1;
                    }
                }
                return 0;
            }
        });
        this.tableModel.fireTableDataChanged();
    }

    private List<String> getDataVars() {
        return this.getIndependenceTest().getVariableNames();
    }

    private void resetText() {
        StringBuilder buf = new StringBuilder();
        if (this.getVars().size() == 0) {
            buf.append("Choose variables and wildcards from dropdown-->");
        }
        if (this.getVars().size() > 0) {
            buf.append(" ").append(this.getVars().get(0));
            buf.append(" _||_ ");
        }
        if (this.getVars().size() > 1) {
            buf.append(this.getVars().get(1));
        }
        if (this.getVars().size() > 2) {
            buf.append(" | ");
        }
        for (int i = 2; i < this.getVars().size() - 1; ++i) {
            buf.append(this.getVars().get(i));
            buf.append(", ");
        }
        if (this.getVars().size() > 2) {
            buf.append(this.getVars().get(this.getVars().size() - 1));
        }
        this.textField.setText(buf.toString());
    }

    private void generateResults() {
        this.getResults().clear();
        List<String> dataVars = this.getDataVars();
        if (this.getVars().size() < 2) {
            this.tableModel.fireTableDataChanged();
            return;
        }
        int min = 0;
        int max = 0;
        ArrayList<String> specifiedVars = new ArrayList<String>();
        for (int i = 0; i < this.getVars().size(); ++i) {
            String var = this.getVars().get(i);
            if ("?".equals(var)) {
                ++min;
                ++max;
                continue;
            }
            if ("+".equals(var)) {
                ++max;
                continue;
            }
            specifiedVars.add(var);
        }
        int[] pattern = new int[this.getVars().size()];
        for (int j = 0; j < this.getVars().size(); ++j) {
            if (!"?".equals(this.getVars().get(j)) && !"+".equals(this.getVars().get(j))) continue;
            pattern[j] = 1;
        }
        int resultIndex = -1;
        block4: for (int n = min; n <= max; ++n) {
            int[] choice;
            ArrayList<String> remainder = new ArrayList<String>(dataVars);
            remainder.removeAll(specifiedVars);
            if (remainder.size() < n) continue;
            ChoiceGenerator cg = new ChoiceGenerator(remainder.size(), n);
            while ((choice = cg.next()) != null) {
                Result.Type indep;
                if (resultIndex >= this.getListLimit() - 1) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "List limit exceeded.");
                    continue block4;
                }
                int[] spec = new int[n + specifiedVars.size()];
                int choiceIndex = -1;
                for (int j = 0; j < n + specifiedVars.size(); ++j) {
                    if (pattern[j] == 0) {
                        spec[j] = dataVars.indexOf(this.getVars().get(j));
                        continue;
                    }
                    int index = choice[++choiceIndex];
                    String var1 = (String)remainder.get(index);
                    spec[j] = dataVars.indexOf(var1);
                }
                Node x = this.getIndependenceTest().getVariable(dataVars.get(spec[0]));
                Node y = this.getIndependenceTest().getVariable(dataVars.get(spec[1]));
                LinkedList<Node> z = new LinkedList<Node>();
                for (int i = 2; i < spec.length; ++i) {
                    z.add(this.getIndependenceTest().getVariable(dataVars.get(spec[i])));
                }
                double pValue = 0.0;
                try {
                    indep = this.getIndependenceTest().isIndependent(x, y, z) ? Result.Type.INDEPENDENT : Result.Type.DEPENDENT;
                    pValue = this.getIndependenceTest().getPValue();
                }
                catch (Exception e) {
                    indep = Result.Type.UNDETERMINED;
                    pValue = Double.NaN;
                }
                if (this.usesDSeparation()) {
                    this.getResults().add(new Result(++resultIndex, IndependenceFactsAction.dsepFactString(x, y, z), indep, pValue));
                    continue;
                }
                this.getResults().add(new Result(++resultIndex, IndependenceFactsAction.independenceFactString(x, y, z), indep, pValue));
            }
        }
        this.tableModel.fireTableDataChanged();
    }

    private LinkedList<String> getVars() {
        return this.vars;
    }

    private JTextField getTextField() {
        return this.textField;
    }

    private IndTestProducer getIndTestProducer() {
        return this.indTestProducer;
    }

    private List<Result> getResults() {
        return this.results;
    }

    private static String independenceFactString(Node x, Node y, List<Node> condSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(x.getName());
        sb.append(" _||_ ");
        sb.append(y.getName());
        Iterator<Node> it = condSet.iterator();
        if (it.hasNext()) {
            sb.append(" | ");
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(", ");
            sb.append(it.next());
        }
        return sb.toString();
    }

    private static String dsepFactString(Node x, Node y, List<Node> condSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append("dsep(");
        sb.append(x.getName());
        sb.append(", ");
        sb.append(y.getName());
        Iterator<Node> it = condSet.iterator();
        if (it.hasNext()) {
            sb.append(" | ");
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(", ");
            sb.append(it.next());
        }
        sb.append(")");
        return sb.toString();
    }

    private IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    private int getLastSortCol() {
        return this.lastSortCol;
    }

    private void setLastSortCol(int lastSortCol) {
        if (lastSortCol < 0 || lastSortCol > 4) {
            throw new IllegalArgumentException();
        }
        this.lastSortCol = lastSortCol;
    }

    private int getSortDir() {
        return this.sortDir;
    }

    private void setSortDir(int sortDir) {
        if (sortDir != 1 && sortDir != -1) {
            throw new IllegalArgumentException();
        }
        this.sortDir = sortDir;
    }

    private int getListLimit() {
        return Preferences.userRoot().getInt("indFactsListLimit", 10000);
    }

    private void setListLimit(int listLimit) {
        if (listLimit < 1) {
            throw new IllegalArgumentException();
        }
        Preferences.userRoot().putInt("indFactsListLimit", listLimit);
    }

    private static final class Result {
        private static NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        private int index;
        private String fact;
        private Type indep;
        private double pValue;

        public Result(int index, String fact, Type indep, double pValue) {
            this.index = index;
            this.fact = fact;
            this.indep = indep;
            this.pValue = pValue;
        }

        public int getIndex() {
            return this.index;
        }

        public String getFact() {
            return this.fact;
        }

        public Type getType() {
            return this.indep;
        }

        public double getpValue() {
            return this.pValue;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Result: ");
            buf.append(this.getFact()).append("\t");
            buf.append((Object)this.getType()).append("\t");
            buf.append(nf.format(this.getpValue()));
            return buf.toString();
        }

        public static enum Type {
            INDEPENDENT,
            DEPENDENT,
            UNDETERMINED;

        }
    }
}

