/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

final class KnowledgeLoaderWizard
extends JPanel {
    private JTextArea fileTextArea;
    private String delimiters = " \t";
    private String commentIndicator = "//";

    public KnowledgeLoaderWizard(File file, KnowledgeEditable knowledgeEditable) {
        if (file == null) {
            throw new NullPointerException();
        }
        if (knowledgeEditable == null) {
            throw new NullPointerException();
        }
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BorderLayout());
        JTextArea sampleTextArea = new JTextArea("???");
        sampleTextArea.setEditable(false);
        sampleTextArea.setFont(new Font("Monospaced", 0, 12));
        sampleTextArea.setTabSize(6);
        JScrollPane sampleScroll = new JScrollPane(sampleTextArea);
        sampleScroll.setPreferredSize(new Dimension(200, 300));
        sampleScroll.setBorder(new TitledBorder("Prototype"));
        this.fileTextArea = new JTextArea();
        this.fileTextArea.setEditable(false);
        this.fileTextArea.setFont(new Font("Monospaced", 0, 12));
        KnowledgeLoaderWizard.setText(file, this.fileTextArea);
        JScrollPane fileScroll = new JScrollPane(this.fileTextArea);
        fileScroll.setPreferredSize(new Dimension(400, 300));
        fileScroll.setBorder(new TitledBorder("File You Selected"));
        sampleTextArea.setText(KnowledgeLoaderWizard.knowledgeSampleText());
        sampleTextArea.setCaretPosition(0);
        JComboBox<String> delimiterBox = new JComboBox<String>(new String[]{"Whitespace", "Tab", "Comma"});
        delimiterBox.setMaximumSize(delimiterBox.getPreferredSize());
        delimiterBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                String choice = (String)box.getSelectedItem();
                if ("Whitespace".equals(choice)) {
                    KnowledgeLoaderWizard.this.delimiters = " \t";
                } else if ("Tab".equals(choice)) {
                    KnowledgeLoaderWizard.this.delimiters = "\t";
                } else if ("Comma".equals(choice)) {
                    KnowledgeLoaderWizard.this.delimiters = "\t";
                }
            }
        });
        StringTextField commentIndicatorField = new StringTextField(this.getCommentIndicator(), 4);
        commentIndicatorField.setFilter(new StringTextField.Filter(){

            @Override
            public String filter(String value, String oldValue) {
                KnowledgeLoaderWizard.this.setCommentIndicator(value);
                return value;
            }
        });
        commentIndicatorField.setFont(new Font("Monospaced", 0, 12));
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("Delimiter: "));
        b1.add(delimiterBox);
        b1.add(Box.createHorizontalStrut(5));
        b1.add(new JLabel("Comment Indicator: "));
        b1.add(commentIndicatorField);
        Box b2 = Box.createHorizontalBox();
        JSplitPane splitPane = new JSplitPane(1, sampleScroll, fileScroll);
        b2.add(splitPane);
        Box b3 = Box.createVerticalBox();
        b3.add(b1);
        b3.add(Box.createVerticalStrut(10));
        b3.add(b2);
        this.add((Component)b3, "Center");
    }

    public String getText() {
        return this.fileTextArea.getText();
    }

    private static String knowledgeSampleText() {
        return "/knowledge\n0 x1 x2\n1 x3 x4\n4 x5";
    }

    private static void setText(File file, JTextArea textArea) {
        int numLines = 40;
        int numCols = 100;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            int lineNumber = 0;
            while ((line = in.readLine()) != null && ++lineNumber < numLines) {
                if (line.length() < numCols) {
                    textArea.append(line.substring(0, line.length()) + "\n");
                    continue;
                }
                textArea.append(line.substring(0, numCols) + "...\n");
            }
            textArea.append("...");
            textArea.setCaretPosition(0);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCommentIndicator() {
        return this.commentIndicator;
    }

    public void setCommentIndicator(String commentIndicator) {
        if (commentIndicator == null) {
            throw new NullPointerException();
        }
        this.commentIndicator = commentIndicator;
    }

    public String getDelimiters() {
        return this.delimiters;
    }
}

