/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetradapp.editor.CopyKnowledgeAction;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.LoadKnowledgeAction;
import edu.cmu.tetradapp.editor.PasteKnowledgeAction;
import edu.cmu.tetradapp.editor.SaveKnowledgeAction;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditor;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class KnowledgeMenu
extends JMenu {
    private KnowledgeEditable knowledgeEditable;

    public KnowledgeMenu(final KnowledgeEditable knowledgeEditable) {
        super("Knowledge");
        this.knowledgeEditable = knowledgeEditable;
        JMenuItem editKnowledge = new JMenuItem("Edit Knowledge...");
        this.add(editKnowledge);
        this.addSeparator();
        editKnowledge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Knowledge knowledge = KnowledgeMenu.this.getKnowledgeEditable().getKnowledge();
                List<String> varList = KnowledgeMenu.this.getKnowledgeEditable().getVarNames();
                Graph sourceGraph = KnowledgeMenu.this.getKnowledgeEditable().getSourceGraph();
                KnowledgeEditor knowledgeEditor = new KnowledgeEditor(knowledge, varList, sourceGraph);
                EditorWindow window = new EditorWindow(knowledgeEditor, "Knowledge Editor", "Save", true, (Component)((Object)knowledgeEditable));
                DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
                window.setVisible(true);
                window.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosed(InternalFrameEvent e) {
                        EditorWindow win = (EditorWindow)e.getSource();
                        if (!win.isCanceled()) {
                            KnowledgeEditor editor = (KnowledgeEditor)win.getEditor();
                            Knowledge knowledge = editor.getKnowledge();
                            KnowledgeMenu.this.getKnowledgeEditable().setKnowledge(knowledge);
                        }
                    }
                });
            }
        });
        this.add(new LoadKnowledgeAction(this.knowledgeEditable));
        this.add(new SaveKnowledgeAction(this.knowledgeEditable));
        this.add(new CopyKnowledgeAction(this.knowledgeEditable));
        this.add(new PasteKnowledgeAction(this.knowledgeEditable));
    }

    private KnowledgeEditable getKnowledgeEditable() {
        return this.knowledgeEditable;
    }
}

