/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Ling;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LingDisplay
extends JPanel
implements GraphEditable {
    private GraphWorkbench workbench;
    private JComboBox subsetCombo;
    private Ling.StoredGraphs storedGraphs;
    private List<Integer> subsetIndices;
    private JSpinner spinner;
    private JLabel totalLabel;

    public LingDisplay(final Ling.StoredGraphs storedGraphs) {
        this.storedGraphs = storedGraphs;
        this.workbench = storedGraphs.getNumGraphs() == 0 ? new GraphWorkbench() : new GraphWorkbench(storedGraphs.getGraph(0));
        this.subsetIndices = this.getStableIndices(storedGraphs);
        final SpinnerNumberModel model = new SpinnerNumberModel(this.subsetIndices.size() == 0 ? 0 : 1, 0, this.subsetIndices.size(), 1);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = model.getNumber().intValue();
                LingDisplay.this.workbench.setGraph(storedGraphs.getGraph((Integer)LingDisplay.this.subsetIndices.get(index - 1)));
            }
        });
        this.spinner = new JSpinner();
        this.subsetCombo = new JComboBox<String>(new String[]{"Show Stable", "Show Unstable", "Show All"});
        this.spinner.setModel(model);
        this.totalLabel = new JLabel(" of " + this.subsetIndices.size());
        this.subsetCombo.setMaximumSize(this.subsetCombo.getPreferredSize());
        this.subsetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LingDisplay.this.resetDisplay();
            }
        });
        this.spinner.setPreferredSize(new Dimension(50, 20));
        this.spinner.setMaximumSize(this.spinner.getPreferredSize());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(this.subsetCombo);
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("DAG "));
        b1.add(this.spinner);
        b1.add(this.totalLabel);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.workbench);
        graphPanel.add(jScrollPane);
        b2.add(graphPanel);
        b.add(b2);
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
    }

    private void resetDisplay() {
        String option = (String)this.subsetCombo.getSelectedItem();
        if ("Show All".equals(option)) {
            List<Integer> _subsetIndices = this.getAllIndices(this.getStoredGraphs());
            this.subsetIndices.clear();
            this.subsetIndices.addAll(_subsetIndices);
            int min = this.subsetIndices.size() == 0 ? 0 : 1;
            final SpinnerNumberModel model = new SpinnerNumberModel(min, min, this.subsetIndices.size(), 1);
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int index = model.getNumber().intValue();
                    LingDisplay.this.workbench.setGraph(LingDisplay.this.storedGraphs.getGraph((Integer)LingDisplay.this.subsetIndices.get(index - 1)));
                }
            });
            this.spinner.setModel(model);
            this.totalLabel.setText(" of " + _subsetIndices.size());
            if (this.subsetIndices.isEmpty()) {
                this.workbench.setGraph(null);
            } else {
                this.workbench.setGraph(this.storedGraphs.getGraph(this.subsetIndices.get(0)));
            }
        } else if ("Show Stable".equals(option)) {
            List<Integer> _subsetIndices = this.getStableIndices(this.getStoredGraphs());
            this.subsetIndices.clear();
            this.subsetIndices.addAll(_subsetIndices);
            int min = this.subsetIndices.size() == 0 ? 0 : 1;
            final SpinnerNumberModel model = new SpinnerNumberModel(min, min, this.subsetIndices.size(), 1);
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int index = model.getNumber().intValue();
                    LingDisplay.this.workbench.setGraph(LingDisplay.this.storedGraphs.getGraph((Integer)LingDisplay.this.subsetIndices.get(index - 1)));
                }
            });
            this.spinner.setModel(model);
            this.totalLabel.setText(" of " + _subsetIndices.size());
            if (this.subsetIndices.isEmpty()) {
                this.workbench.setGraph(new EdgeListGraph());
            } else {
                this.workbench.setGraph(this.storedGraphs.getGraph(this.subsetIndices.get(0)));
            }
        } else if ("Show Unstable".equals(option)) {
            List<Integer> _subsetIndices = this.getUnstableIndices(this.getStoredGraphs());
            this.subsetIndices.clear();
            this.subsetIndices.addAll(_subsetIndices);
            int min = this.subsetIndices.size() == 0 ? 0 : 1;
            final SpinnerNumberModel model = new SpinnerNumberModel(min, min, this.subsetIndices.size(), 1);
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int index = model.getNumber().intValue();
                    LingDisplay.this.workbench.setGraph(LingDisplay.this.storedGraphs.getGraph((Integer)LingDisplay.this.subsetIndices.get(index - 1)));
                }
            });
            this.spinner.setModel(model);
            this.totalLabel.setText(" of " + _subsetIndices.size());
            if (this.subsetIndices.isEmpty()) {
                this.workbench.setGraph(new EdgeListGraph());
            } else {
                this.workbench.setGraph(this.storedGraphs.getGraph(this.subsetIndices.get(0)));
            }
        }
    }

    public void resetGraphs(Ling.StoredGraphs storedGraphs) {
        this.storedGraphs = storedGraphs;
        this.resetDisplay();
    }

    private List<Integer> getAllIndices(Ling.StoredGraphs storedGraphs) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < storedGraphs.getNumGraphs(); ++i) {
            indices.add(i);
        }
        return indices;
    }

    private List<Integer> getStableIndices(Ling.StoredGraphs storedGraphs) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < storedGraphs.getNumGraphs(); ++i) {
            if (!storedGraphs.isStable(i)) continue;
            indices.add(i);
        }
        return indices;
    }

    private List<Integer> getUnstableIndices(Ling.StoredGraphs storedGraphs) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < storedGraphs.getNumGraphs(); ++i) {
            if (storedGraphs.isStable(i)) continue;
            indices.add(i);
        }
        return indices;
    }

    @Override
    public List getSelectedModelComponents() {
        Component[] components = this.getWorkbench().getComponents();
        ArrayList<TetradSerializable> selectedModelComponents = new ArrayList<TetradSerializable>();
        for (Component comp : components) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (int i = 0; i < sessionElements.size(); ++i) {
            Object o = sessionElements.get(i);
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public Graph getGraph() {
        return this.workbench.getGraph();
    }

    @Override
    public void setGraph(Graph graph) {
        this.workbench.setGraph(graph);
    }

    public Ling.StoredGraphs getStoredGraphs() {
        return this.storedGraphs;
    }
}

