/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.StringTextField;
import edu.cmu.tetradapp.util.TextAreaOutputStream;
import edu.cmu.tetradapp.util.WatchedProcess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

final class LoadDataDialog
extends JPanel {
    private File[] files;
    private JRadioButton tabularRadioButton;
    private JRadioButton covarianceRadioButton;
    private JRadioButton comment1RadioButton;
    private JRadioButton comment2RadioButton;
    private JRadioButton comment3RadioButton;
    private StringTextField commentStringField;
    private JRadioButton delimiter1RadioButton;
    private JRadioButton delimiter2RadioButton;
    private JRadioButton delimiter3RadioButton;
    private JRadioButton quote1RadioButton;
    private JRadioButton quote2RadioButton;
    private JCheckBox varNamesCheckBox;
    private JCheckBox idsSupplied;
    private JRadioButton id1RadioButton;
    private JRadioButton id2RadioButton;
    private StringTextField idStringField;
    private JRadioButton missing1RadioButton;
    private JRadioButton missing2RadioButton;
    private JRadioButton missing3RadioButton;
    private JCheckBox logEmptyTokens;
    private StringTextField missingStringField;
    private IntTextField maxIntegralDiscreteIntField;
    private DataModel[] dataModels;
    private JLabel maxIntegralLabel1;
    private JLabel maxIntegralLabel2;
    private int fileIndex = 0;

    public LoadDataDialog(final File ... files) {
        if (files.length == 0) {
            throw new IllegalArgumentException("Must specify at least one file.");
        }
        this.files = files;
        this.dataModels = new DataModel[files.length];
        this.tabularRadioButton = new JRadioButton("Tabular Data");
        this.covarianceRadioButton = new JRadioButton("Covariance Data");
        this.comment1RadioButton = new JRadioButton("//");
        this.comment2RadioButton = new JRadioButton("#");
        this.comment3RadioButton = new JRadioButton("Other: ");
        String otherCommentPreference = Preferences.userRoot().get("dataLoaderOtherCommentPreference", "");
        this.commentStringField = new StringTextField(otherCommentPreference, 4);
        this.delimiter1RadioButton = new JRadioButton("Whitespace");
        this.delimiter2RadioButton = new JRadioButton("Tab");
        this.delimiter3RadioButton = new JRadioButton("Comma");
        this.quote1RadioButton = new JRadioButton("\"");
        this.quote2RadioButton = new JRadioButton("'");
        this.logEmptyTokens = new JCheckBox("Log Empty Tokens");
        this.logEmptyTokens.setHorizontalTextPosition(2);
        this.varNamesCheckBox = new JCheckBox("Variable names in first row of data");
        this.varNamesCheckBox.setHorizontalTextPosition(2);
        this.idsSupplied = new JCheckBox("Case ID's provided");
        this.idsSupplied.setHorizontalTextPosition(2);
        boolean idsSuppliedPreference = Preferences.userRoot().getBoolean("dataLoaderIdsSuppliedPreference", false);
        this.idsSupplied.setSelected(idsSuppliedPreference);
        this.id1RadioButton = new JRadioButton("Unlabeled first column");
        this.id2RadioButton = new JRadioButton("Column labeled: ");
        this.idStringField = new StringTextField("", 4);
        this.id1RadioButton.setEnabled(false);
        this.id2RadioButton.setEnabled(false);
        this.idStringField.setEditable(false);
        this.idsSupplied.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox button = (JCheckBox)e.getSource();
                boolean selected = button.isSelected();
                LoadDataDialog.this.id1RadioButton.setEnabled(selected);
                LoadDataDialog.this.id2RadioButton.setEnabled(selected);
                LoadDataDialog.this.idStringField.setEditable(selected);
            }
        });
        this.missing1RadioButton = new JRadioButton("*");
        this.missing2RadioButton = new JRadioButton("?");
        this.missing3RadioButton = new JRadioButton("Other: ");
        String otherMissingPreference = Preferences.userRoot().get("dataLoaderOtherMissingPreference", "");
        this.missingStringField = new StringTextField(otherMissingPreference, 6);
        this.maxIntegralDiscreteIntField = new IntTextField(0, 3);
        final JTextArea fileTextArea = new JTextArea();
        final JTextArea anomaliesTextArea = new JTextArea();
        final JTabbedPane tabbedPane = new JTabbedPane();
        JScrollPane scroll1 = new JScrollPane(fileTextArea);
        scroll1.setPreferredSize(new Dimension(500, 400));
        tabbedPane.addTab("File", scroll1);
        JScrollPane scroll2 = new JScrollPane(anomaliesTextArea);
        scroll2.setPreferredSize(new Dimension(500, 400));
        tabbedPane.addTab("Loading Log", scroll2);
        final JLabel progressLabel = new JLabel(this.getProgressString(0, files.length, this.dataModels));
        progressLabel.setFont(new Font("Dialog", 1, 12));
        JButton previousButton = new JButton("Previous");
        JButton nextButton = new JButton("Next");
        JButton loadButton = new JButton("Load");
        JButton loadAllButton = new JButton("Load All");
        final JLabel fileNameLabel = new JLabel("File: " + files[this.fileIndex].getName());
        fileNameLabel.setFont(new Font("Dialog", 1, 12));
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.tabularRadioButton);
        group1.add(this.covarianceRadioButton);
        String tabularPreference = Preferences.userRoot().get("loadDataTabularPreference", "tabular");
        if ("tabular".equals(tabularPreference)) {
            this.tabularRadioButton.setSelected(true);
        } else if ("covariance".equals(tabularPreference)) {
            this.covarianceRadioButton.setSelected(true);
        } else {
            throw new IllegalStateException("Unexpected preference.");
        }
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.comment1RadioButton);
        group2.add(this.comment2RadioButton);
        group2.add(this.comment3RadioButton);
        String commentPreference = Preferences.userRoot().get("loadDataCommentPreference", "//");
        if ("//".equals(commentPreference)) {
            this.comment1RadioButton.setSelected(true);
        } else if ("#".equals(commentPreference)) {
            this.comment2RadioButton.setSelected(true);
        } else if ("Other".equals(commentPreference)) {
            this.comment3RadioButton.setSelected(true);
        }
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.delimiter1RadioButton);
        group3.add(this.delimiter2RadioButton);
        group3.add(this.delimiter3RadioButton);
        String delimiterPreference = Preferences.userRoot().get("loadDataDelimiterPreference", "Whitespace");
        if ("Whitespace".equals(delimiterPreference)) {
            this.delimiter1RadioButton.setSelected(true);
        } else if ("Tab".equals(delimiterPreference)) {
            this.delimiter2RadioButton.setSelected(true);
        } else if ("Comma".equals(delimiterPreference)) {
            this.delimiter3RadioButton.setSelected(true);
        } else {
            throw new IllegalStateException("Unexpected preference.");
        }
        ButtonGroup group4 = new ButtonGroup();
        group4.add(this.quote1RadioButton);
        group4.add(this.quote2RadioButton);
        this.quote1RadioButton.setSelected(true);
        ButtonGroup group5 = new ButtonGroup();
        group5.add(this.id1RadioButton);
        group5.add(this.id2RadioButton);
        this.id1RadioButton.setSelected(true);
        ButtonGroup group6 = new ButtonGroup();
        group6.add(this.missing1RadioButton);
        group6.add(this.missing2RadioButton);
        group6.add(this.missing3RadioButton);
        this.missing1RadioButton.setSelected(true);
        this.varNamesCheckBox.setSelected(true);
        this.id1RadioButton.setSelected(true);
        this.idStringField.setText("ID");
        this.commentStringField.setText("@");
        this.missingStringField.setText("Missing");
        fileTextArea.setFont(new Font("Monospaced", 0, 12));
        LoadDataDialog.setText(files[this.fileIndex], fileTextArea);
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("File Type:"));
        b1.add(Box.createHorizontalGlue());
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createRigidArea(new Dimension(20, 1)));
        b2.add(this.tabularRadioButton);
        b2.add(this.covarianceRadioButton);
        b2.add(Box.createHorizontalGlue());
        b.add(b2);
        Box b5 = Box.createHorizontalBox();
        b5.add(new JLabel("Delimiter"));
        b5.add(Box.createHorizontalGlue());
        b.add(b5);
        Box b6 = Box.createHorizontalBox();
        b6.add(Box.createRigidArea(new Dimension(20, 1)));
        b6.add(this.delimiter1RadioButton);
        b6.add(this.delimiter2RadioButton);
        b6.add(this.delimiter3RadioButton);
        b6.add(Box.createHorizontalGlue());
        b.add(b6);
        Box b9 = Box.createHorizontalBox();
        b9.add(this.varNamesCheckBox);
        b9.add(Box.createHorizontalGlue());
        b.add(b9);
        Box b10 = Box.createHorizontalBox();
        b10.add(this.idsSupplied);
        b10.add(Box.createHorizontalGlue());
        b.add(b10);
        Box b11 = Box.createHorizontalBox();
        b11.add(Box.createRigidArea(new Dimension(20, 1)));
        b11.add(this.id1RadioButton);
        b11.add(this.id2RadioButton);
        b11.add(this.idStringField);
        b11.add(Box.createHorizontalGlue());
        b.add(b11);
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Comment Marker"));
        b3.add(Box.createHorizontalGlue());
        b.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createRigidArea(new Dimension(20, 1)));
        b4.add(this.comment1RadioButton);
        b4.add(this.comment2RadioButton);
        b4.add(this.comment3RadioButton);
        b4.add(this.commentStringField);
        b4.add(Box.createHorizontalGlue());
        b.add(b4);
        Box b7 = Box.createHorizontalBox();
        b7.add(new JLabel("Quote Character"));
        b7.add(Box.createHorizontalGlue());
        b.add(b7);
        Box b8 = Box.createHorizontalBox();
        b8.add(Box.createRigidArea(new Dimension(20, 1)));
        b8.add(this.quote1RadioButton);
        b8.add(this.quote2RadioButton);
        b8.add(Box.createHorizontalGlue());
        b.add(b8);
        Box b12 = Box.createHorizontalBox();
        b12.add(new JLabel("Missing value marker (other than blank field):"));
        b12.add(Box.createHorizontalGlue());
        b.add(b12);
        Box b13 = Box.createHorizontalBox();
        b13.add(Box.createRigidArea(new Dimension(20, 1)));
        b13.add(this.missing1RadioButton);
        b13.add(this.missing2RadioButton);
        b13.add(this.missing3RadioButton);
        b13.add(this.missingStringField);
        b13.add(Box.createHorizontalGlue());
        b.add(b13);
        b.add(Box.createVerticalStrut(5));
        Box b14 = Box.createHorizontalBox();
        this.maxIntegralLabel1 = new JLabel("Integral columns with up to ");
        this.maxIntegralLabel2 = new JLabel(" values are discrete.");
        b14.add(this.maxIntegralLabel1);
        b14.add(this.maxIntegralDiscreteIntField);
        b14.add(this.maxIntegralLabel2);
        b14.add(Box.createHorizontalGlue());
        b.add(b14);
        b.add(Box.createVerticalStrut(5));
        Box b16 = Box.createHorizontalBox();
        b16.add(this.logEmptyTokens);
        b16.add(Box.createHorizontalGlue());
        b.add(b16);
        b.add(Box.createVerticalGlue());
        b.setBorder(new TitledBorder("Data Loading Parameters"));
        Box c = Box.createVerticalBox();
        Box c1 = Box.createHorizontalBox();
        c1.add(tabbedPane);
        c.add(c1);
        Box c2 = Box.createHorizontalBox();
        c2.add(Box.createHorizontalGlue());
        if (files.length > 1) {
            c2.add(progressLabel);
        }
        c2.add(Box.createHorizontalStrut(10));
        if (files.length > 1) {
            c2.add(previousButton);
            c2.add(nextButton);
        }
        c2.add(loadButton);
        if (files.length > 1) {
            c2.add(loadAllButton);
        }
        c2.setBorder(new EmptyBorder(4, 4, 4, 4));
        c.add(c2);
        c.setBorder(new TitledBorder("Source File and Loading Log"));
        Box a = Box.createHorizontalBox();
        a.add(b);
        a.add(c);
        this.setLayout(new BorderLayout());
        Box d = Box.createHorizontalBox();
        d.add(fileNameLabel);
        d.add(Box.createHorizontalGlue());
        Box e = Box.createVerticalBox();
        e.add(d);
        e.add(Box.createVerticalStrut(10));
        e.add(a);
        this.add((Component)e, "Center");
        previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileTextArea.setFont(new Font("Monospaced", 0, 12));
                if (LoadDataDialog.this.fileIndex > 0) {
                    LoadDataDialog.this.fileIndex--;
                }
                LoadDataDialog.setText(files[LoadDataDialog.this.fileIndex], fileTextArea);
                progressLabel.setText(LoadDataDialog.this.getProgressString(LoadDataDialog.this.fileIndex, files.length, LoadDataDialog.this.dataModels));
                tabbedPane.setSelectedIndex(0);
                fileNameLabel.setText("File: " + files[LoadDataDialog.this.fileIndex].getName());
            }
        });
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileTextArea.setFont(new Font("Monospaced", 0, 12));
                if (LoadDataDialog.this.fileIndex < files.length - 1) {
                    LoadDataDialog.this.fileIndex++;
                }
                LoadDataDialog.setText(files[LoadDataDialog.this.fileIndex], fileTextArea);
                progressLabel.setText(LoadDataDialog.this.getProgressString(LoadDataDialog.this.fileIndex, files.length, LoadDataDialog.this.dataModels));
                tabbedPane.setSelectedIndex(0);
                fileNameLabel.setText("File: " + files[LoadDataDialog.this.fileIndex].getName());
            }
        });
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window owner = (Window)LoadDataDialog.this.getTopLevelAncestor();
                new WatchedProcess(owner){

                    @Override
                    public void watch() {
                        Window owner = (Window)LoadDataDialog.this.getTopLevelAncestor();
                        new WatchedProcess(owner){

                            @Override
                            public void watch() {
                                anomaliesTextArea.setText("");
                                TextAreaOutputStream out1 = new TextAreaOutputStream(anomaliesTextArea);
                                PrintStream out = new PrintStream(out1);
                                TetradLogger.getInstance().addOutputStream(out);
                                TetradLogger.getInstance().setForceLog(true);
                                try {
                                    tabbedPane.setSelectedIndex(1);
                                    DataReader reader = new DataReader();
                                    reader.setLogEmptyTokens(LoadDataDialog.this.logEmptyTokens.isSelected());
                                    reader.setCommentMarker(LoadDataDialog.this.getCommentString());
                                    reader.setDelimiter(LoadDataDialog.this.getDelimiterType());
                                    reader.setQuoteChar(LoadDataDialog.this.getQuoteChar());
                                    reader.setVariablesSupplied(LoadDataDialog.this.isVarNamesFirstRow());
                                    reader.setIdsSupplied(LoadDataDialog.this.isIdsSupplied());
                                    reader.setIdLabel(LoadDataDialog.this.getIdLabel());
                                    reader.setMissingValueMarker(LoadDataDialog.this.getMissingValue());
                                    reader.setMaxIntegralDiscrete(LoadDataDialog.this.getMaxDiscrete());
                                    DataModel dataModel = LoadDataDialog.this.tabularRadioButton.isSelected() ? reader.parseTabular(files[LoadDataDialog.this.fileIndex]) : reader.parseCovariance(files[LoadDataDialog.this.fileIndex]);
                                    LoadDataDialog.this.addDataModel(dataModel, LoadDataDialog.this.fileIndex, files[LoadDataDialog.this.fileIndex].getName());
                                    anomaliesTextArea.setCaretPosition(anomaliesTextArea.getText().length());
                                    progressLabel.setText(LoadDataDialog.this.getProgressString(LoadDataDialog.this.fileIndex, files.length, LoadDataDialog.this.dataModels));
                                }
                                catch (Exception e1) {
                                    out.println(e1.getMessage());
                                    out.println("\nIf that message was unhelpful, \nplease copy and paste the (Java) \nerror below to Joe Ramsey, \njdramsey@andrew.cmu.edu, \nso a better error message \ncan be put at that location.\nThanks!");
                                    out.println();
                                    e1.printStackTrace(out);
                                }
                                TetradLogger.getInstance().removeOutputStream(out);
                                TetradLogger.getInstance().setForceLog(false);
                            }
                        };
                    }
                };
            }
        });
        loadAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window owner = (Window)LoadDataDialog.this.getTopLevelAncestor();
                new WatchedProcess(owner){

                    @Override
                    public void watch() {
                        Window owner = (Window)LoadDataDialog.this.getTopLevelAncestor();
                        new WatchedProcess(owner){

                            @Override
                            public void watch() {
                                LoadDataDialog.this.fileIndex = 0;
                                while (LoadDataDialog.this.fileIndex < files.length) {
                                    anomaliesTextArea.setText("");
                                    TextAreaOutputStream out1 = new TextAreaOutputStream(anomaliesTextArea);
                                    PrintStream out = new PrintStream(out1);
                                    TetradLogger.getInstance().addOutputStream(out);
                                    TetradLogger.getInstance().setForceLog(true);
                                    try {
                                        tabbedPane.setSelectedIndex(1);
                                        DataReader reader = new DataReader();
                                        reader.setLogEmptyTokens(LoadDataDialog.this.logEmptyTokens.isSelected());
                                        reader.setCommentMarker(LoadDataDialog.this.getCommentString());
                                        reader.setDelimiter(LoadDataDialog.this.getDelimiterType());
                                        reader.setQuoteChar(LoadDataDialog.this.getQuoteChar());
                                        reader.setVariablesSupplied(LoadDataDialog.this.isVarNamesFirstRow());
                                        reader.setIdsSupplied(LoadDataDialog.this.isIdsSupplied());
                                        reader.setIdLabel(LoadDataDialog.this.getIdLabel());
                                        reader.setMissingValueMarker(LoadDataDialog.this.getMissingValue());
                                        reader.setMaxIntegralDiscrete(LoadDataDialog.this.getMaxDiscrete());
                                        DataModel dataModel = LoadDataDialog.this.tabularRadioButton.isSelected() ? reader.parseTabular(files[LoadDataDialog.this.fileIndex]) : reader.parseCovariance(files[LoadDataDialog.this.fileIndex]);
                                        LoadDataDialog.this.addDataModel(dataModel, LoadDataDialog.this.fileIndex, files[LoadDataDialog.this.fileIndex].getName());
                                        anomaliesTextArea.setCaretPosition(anomaliesTextArea.getText().length());
                                        progressLabel.setText(LoadDataDialog.this.getProgressString(LoadDataDialog.this.fileIndex, files.length, LoadDataDialog.this.dataModels));
                                    }
                                    catch (Exception e1) {
                                        out.println(e1.getMessage());
                                        out.println("\nIf that message was unhelpful, \nplease copy and paste the (Java) \nerror below to Joe Ramsey, \njdramsey@andrew.cmu.edu, \nso a better error message \ncan be put at that location.\nThanks!");
                                        out.println();
                                        e1.printStackTrace(out);
                                    }
                                    TetradLogger.getInstance().removeOutputStream(out);
                                    TetradLogger.getInstance().setForceLog(false);
                                    LoadDataDialog.this.fileIndex++;
                                }
                            }
                        };
                    }
                };
            }
        });
        this.tabularRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadDataDialog.this.idsSupplied.setEnabled(true);
                LoadDataDialog.this.idStringField.setEditable(true);
                LoadDataDialog.this.maxIntegralLabel1.setEnabled(true);
                LoadDataDialog.this.maxIntegralLabel2.setEnabled(true);
                LoadDataDialog.this.maxIntegralDiscreteIntField.setEnabled(true);
                LoadDataDialog.this.varNamesCheckBox.setEnabled(true);
                if (LoadDataDialog.this.idsSupplied.isSelected()) {
                    LoadDataDialog.this.id1RadioButton.setEnabled(true);
                    LoadDataDialog.this.id2RadioButton.setEnabled(true);
                }
            }
        });
        this.covarianceRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadDataDialog.this.idsSupplied.setEnabled(false);
                LoadDataDialog.this.id1RadioButton.setEnabled(false);
                LoadDataDialog.this.id2RadioButton.setEnabled(false);
                LoadDataDialog.this.idStringField.setEditable(false);
                LoadDataDialog.this.maxIntegralLabel1.setEnabled(false);
                LoadDataDialog.this.maxIntegralLabel2.setEnabled(false);
                LoadDataDialog.this.maxIntegralDiscreteIntField.setEnabled(false);
                LoadDataDialog.this.varNamesCheckBox.setEnabled(false);
            }
        });
    }

    public DataModelList getDataModels() {
        DataModelList dataModelList = new DataModelList();
        for (DataModel dataModel : this.dataModels) {
            if (dataModel == null) continue;
            dataModelList.add(dataModel);
        }
        return dataModelList;
    }

    private static void setText(File file, JTextArea textArea) {
        try {
            String line;
            textArea.setText("");
            BufferedReader in = new BufferedReader(new FileReader(file));
            StringBuilder text = new StringBuilder();
            while ((line = in.readLine()) != null) {
                text.append(line.substring(0, line.length())).append("\n");
                if (text.length() <= 50000) continue;
                textArea.append("(This is a large file that begins as follows...)\n");
                textArea.setEditable(false);
                break;
            }
            textArea.append(text.toString());
            if (!textArea.isEditable()) {
                textArea.append(". . .");
            }
            textArea.setCaretPosition(0);
            in.close();
        }
        catch (IOException e) {
            textArea.append("<<<ERROR READING FILE>>>");
            textArea.setEditable(false);
        }
    }

    private String getCommentString() {
        if (this.comment1RadioButton.isSelected()) {
            return "//";
        }
        if (this.comment2RadioButton.isSelected()) {
            return "#";
        }
        return this.commentStringField.getText();
    }

    private DelimiterType getDelimiterType() {
        if (this.delimiter1RadioButton.isSelected()) {
            return DelimiterType.WHITESPACE;
        }
        if (this.delimiter2RadioButton.isSelected()) {
            return DelimiterType.TAB;
        }
        if (this.delimiter3RadioButton.isSelected()) {
            return DelimiterType.COMMA;
        }
        throw new IllegalArgumentException("Unexpected delimiter selection.");
    }

    private char getQuoteChar() {
        if (this.quote1RadioButton.isSelected()) {
            return '\"';
        }
        return '\'';
    }

    private boolean isVarNamesFirstRow() {
        return this.varNamesCheckBox.isSelected();
    }

    private boolean isIdsSupplied() {
        return this.idsSupplied.isSelected();
    }

    private String getIdLabel() {
        if (this.id1RadioButton.isSelected()) {
            return null;
        }
        return this.idStringField.getText();
    }

    private String getMissingValue() {
        if (this.missing1RadioButton.isSelected()) {
            return "*";
        }
        if (this.missing2RadioButton.isSelected()) {
            return "?";
        }
        return this.missingStringField.getText();
    }

    private int getMaxDiscrete() {
        return this.maxIntegralDiscreteIntField.getValue();
    }

    private void addDataModel(DataModel dataModel, int index, String name) {
        dataModel.setName(name);
        this.dataModels[index] = dataModel;
    }

    public String getProgressString(int fileIndex, int numFiles, DataModel[] dataModels) {
        return (dataModels[fileIndex] == null ? "" : "*") + (fileIndex + 1) + " / " + numFiles;
    }
}

