/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.ModeInterpolator;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public final class ModeInterpolatorAction
extends AbstractAction {
    private DataEditor dataEditor;

    public ModeInterpolatorAction(DataEditor editor) {
        super("Replace Missing Values with Column Mode");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            ModeInterpolator interpolator = new ModeInterpolator();
            DataSet newDataSet = interpolator.filter(dataSet);
            DataModelList list = new DataModelList();
            list.add(newDataSet);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else if (dataModel instanceof CovarianceMatrix) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Must be a tabular data set.");
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

