/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NeighborhoodsAction
extends AbstractAction
implements ClipboardOwner {
    private GraphWorkbench workbench;

    public NeighborhoodsAction(GraphWorkbench workbench) {
        super("Neighborhoods");
        this.workbench = workbench;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Box b = Box.createVerticalBox();
        Graph graph = this.workbench.getGraph();
        JTextArea textArea = new JTextArea();
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setPreferredSize(new Dimension(600, 600));
        textArea.append("Neighborhoods:");
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            Node node = graph.getNodes().get(i);
            List<Node> parents = graph.getParents(node);
            List<Node> children = graph.getChildren(node);
            List<Node> ambiguous = graph.getAdjacentNodes(node);
            ambiguous.removeAll(parents);
            ambiguous.removeAll(children);
            textArea.append("\n\nNeighborhood for " + node + ":");
            textArea.append("\n\tParents: " + this.niceList(parents));
            textArea.append("\n\tChildren: " + this.niceList(children));
            textArea.append("\n\tAmbiguous: " + this.niceList(ambiguous));
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(scroll);
        textArea.setCaretPosition(0);
        b.add(b2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(b);
        EditorWindow window = new EditorWindow(panel, "Neighborhoods", "Close", false, this.workbench);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    private String niceList(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return "--NONE--";
        }
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < nodes.size(); ++i) {
            buf.append(nodes.get(i));
            if (i >= nodes.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

