/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.NormalityTestEditorPanel;
import edu.cmu.tetradapp.editor.NormalityTests;
import edu.cmu.tetradapp.editor.QQPlot;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class NormalityTestAction
extends AbstractAction {
    private DataEditor dataEditor;

    public NormalityTestAction(DataEditor editor) {
        super("Normality Tests...");
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        if (dataSet == null || dataSet.getNumColumns() == 0) {
            JOptionPane.showMessageDialog(this.findOwner(), "Cannot run normality tests on an empty data set.");
            return;
        }
        if (DataUtils.containsMissingValue(dataSet)) {
            JOptionPane.showMessageDialog(this.findOwner(), new JLabel("<html>Data has missing values, remove all missing values before<br>running normality tests.</html>"));
            return;
        }
        JPanel panel = this.createNormalityTestDialog(null);
        EditorWindow window = new EditorWindow(panel, "Normality Tests", "Close", false, this.dataEditor);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    private void setLocation(JDialog dialog, int index) {
        Rectangle bounds = dialog.getBounds();
        JFrame frame = this.findOwner();
        Dimension dim = frame == null ? Toolkit.getDefaultToolkit().getScreenSize() : frame.getSize();
        int x = (int)(150.0 * Math.cos((double)(index * 15) * (Math.PI / 180)));
        int y = (int)(150.0 * Math.sin((double)(index * 15) * (Math.PI / 180)));
        dialog.setLocation(x += (dim.width - bounds.width) / 2, y += (dim.height - bounds.height) / 2);
    }

    private JPanel createNormalityTestDialog(Node selected) {
        DataSet dataSet = (DataSet)this.dataEditor.getSelectedDataModel();
        QQPlot qqPlot = new QQPlot(dataSet, selected);
        NormalityTestEditorPanel editorPanel = new NormalityTestEditorPanel(qqPlot, dataSet);
        JTextArea display = new JTextArea(NormalityTests.runNormalityTests(dataSet, (ContinuousVariable)qqPlot.getSelectedVariable()), 20, 65);
        display.setEditable(false);
        editorPanel.addPropertyChangeListener(new NormalityTestListener(display));
        Box box = Box.createHorizontalBox();
        box.add(display);
        box.add(Box.createHorizontalStrut(3));
        box.add(editorPanel);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(15));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)vBox, "Center");
        return panel;
    }

    private JFrame findOwner() {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.dataEditor);
    }

    private static class NormalityTestListener
    implements PropertyChangeListener {
        private JTextArea display;

        public NormalityTestListener(JTextArea display) {
            this.display = display;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("histogramChange".equals(evt.getPropertyName())) {
                this.display.setText((String)evt.getNewValue());
            }
        }
    }
}

