/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetradapp.model.NoteModel;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class NoteEditor
extends JPanel {
    private NoteModel noteModel;

    public NoteEditor(NoteModel noteModel) {
        this.noteModel = noteModel;
        this.setup();
    }

    private boolean isLegal(String text) {
        return true;
    }

    private void setup() {
        Font font = new Font("Monospaced", 0, 14);
        JTextPane textPane = new JTextPane(this.noteModel.getNote());
        StringTextField field = new StringTextField(this.noteModel.getName(), 20);
        field.setFont(font);
        textPane.setFont(font);
        textPane.setCaretPosition(textPane.getStyledDocument().getLength());
        JScrollPane scroll = new JScrollPane(textPane);
        scroll.setPreferredSize(new Dimension(400, 400));
        field.addFocusListener(new FieldListener(field));
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(10));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(" Name: "));
        box.add(field);
        box.add(Box.createHorizontalGlue());
        this.add(box);
        this.add(Box.createVerticalStrut(10));
        Box box1 = Box.createHorizontalBox();
        box1.add(new JLabel(" Note Area: "));
        box1.add(Box.createHorizontalGlue());
        this.add(box1);
        this.add(scroll);
    }

    private class FieldListener
    extends FocusAdapter {
        private String current;
        private JTextField field;

        public FieldListener(JTextField field) {
            this.field = field;
            this.current = field.getText();
        }

        @Override
        public void focusLost(FocusEvent evt) {
            this.doAction();
        }

        private void doAction() {
            String text = this.field.getText();
            if (this.current.equals(text)) {
                return;
            }
            if (NoteEditor.this.isLegal(text)) {
                this.current = text;
                NoteEditor.this.noteModel.setName(text);
                NoteEditor.this.firePropertyChange("changeNodeLabel", null, text);
            } else {
                this.field.setText(this.current);
            }
        }
    }
}

