/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.predict.ManipulatedVariable;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.model.PredictionRunner;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public final class PredictionEditor
extends JPanel {
    private final PredictionRunner predictionRunner;
    private final Map<Node, NodeInfo> input;
    private final JPanel layoutPanel;
    private final NumberFormat nf;

    public PredictionEditor(PredictionRunner predictionRunner) {
        if (predictionRunner == null) {
            throw new NullPointerException();
        }
        this.predictionRunner = predictionRunner;
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        this.add((Component)layoutPanel, "Center");
        layoutPanel.setLayout(new BorderLayout());
        this.layoutPanel = layoutPanel;
        this.input = new HashMap<Node, NodeInfo>();
        this.nf = NumberFormatUtil.getInstance().getNumberFormat();
        this.resetLayoutPanel();
    }

    private Map<Node, NodeInfo> input() {
        return this.input;
    }

    private PredictionRunner predictionRunner() {
        return this.getPredictionRunner();
    }

    private void resetLayoutPanel() {
        Box b = Box.createVerticalBox();
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        JButton predictButton = new JButton("Do Prediction Now");
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("<html>Click the 'change' button next to a variable to set it to manipulated, <br>predicted, or conditioned on.  When done, click on the <br>Do Prediction Now button to execute the prediction.</html>"));
        b.add(b0);
        List<Node> nodes = this.predictionRunner().getPag().getNodes();
        Iterator<Node> i$ = nodes.iterator();
        while (i$.hasNext()) {
            Node node;
            final Node currentNode = node = i$.next();
            Box c = Box.createHorizontalBox();
            c.add(new JLabel(currentNode.getName()){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            });
            NodeInfo nodeInfo = this.getNodeInfo(currentNode);
            char type = nodeInfo.getChar();
            if (type == 'm') {
                c.add(Box.createHorizontalStrut(10));
                String text = "Manipulated, Mean = " + this.nf.format(nodeInfo.getMean()) + ", Variance = " + this.nf.format(nodeInfo.getVariance());
                c.add(new JLabel(text));
            } else if (type == 'p') {
                c.add(Box.createHorizontalStrut(10));
                double result = this.getPredictionRunner().getResult();
                String text = Double.isNaN(result) ? "(Undefined)" : this.nf.format(result);
                c.add(new JLabel("Predicted: " + text));
            } else if (type == 'c') {
                c.add(Box.createHorizontalStrut(10));
                c.add(new JLabel("Conditioned on"));
            }
            JButton changeButton = new JButton("Change");
            changeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PredictionEditor.this.launchSelectionButton(currentNode);
                }
            });
            c.add(Box.createHorizontalGlue());
            c.add(changeButton);
            b.add(c);
        }
        Box b2 = Box.createHorizontalBox();
        b2.add(predictButton);
        b.add(b2);
        predictButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PredictionEditor.this.doClickPredictButton();
            }
        });
        this.layoutPanel.removeAll();
        this.layoutPanel.add((Component)b, "Center");
        this.layoutPanel.revalidate();
        this.layoutPanel.repaint();
    }

    private void launchSelectionButton(Node node) {
        NodeInfo nodeInfo = this.getNodeInfo(node);
        double mean = nodeInfo.getMean();
        double variance = nodeInfo.getVariance();
        final DoubleTextField meanField = new DoubleTextField(mean, 10, NumberFormatUtil.getInstance().getNumberFormat());
        final DoubleTextField varianceField = new DoubleTextField(variance, 10, NumberFormatUtil.getInstance().getNumberFormat());
        Box b = Box.createVerticalBox();
        b.setBorder(new EmptyBorder(10, 10, 10, 10));
        JRadioButton none = new JRadioButton("(none)");
        final JRadioButton manipulate = new JRadioButton("Manipulate  ");
        JRadioButton condition = new JRadioButton("Condition on");
        JRadioButton predict = new JRadioButton("Predict");
        none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PredictionEditor.this.setFieldsEnabled(meanField, manipulate, varianceField);
            }
        });
        manipulate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PredictionEditor.this.setFieldsEnabled(meanField, manipulate, varianceField);
            }
        });
        condition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PredictionEditor.this.setFieldsEnabled(meanField, manipulate, varianceField);
            }
        });
        predict.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PredictionEditor.this.setFieldsEnabled(meanField, manipulate, varianceField);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(none);
        group.add(condition);
        group.add(predict);
        group.add(manipulate);
        if (nodeInfo.getIdentifier() == 'n') {
            none.setSelected(true);
            this.setFieldsEnabled(meanField, manipulate, varianceField);
        } else if (nodeInfo.getChar() == 'm') {
            manipulate.setSelected(true);
            this.setFieldsEnabled(meanField, manipulate, varianceField);
        } else if (nodeInfo.getChar() == 'p') {
            predict.setSelected(true);
            this.setFieldsEnabled(meanField, manipulate, varianceField);
        } else if (nodeInfo.getChar() == 'c') {
            condition.setSelected(true);
            this.setFieldsEnabled(meanField, manipulate, varianceField);
        }
        JLabel nodeName = new JLabel(node.getName());
        JLabel meanLabel = new JLabel("Mean = ");
        JLabel varianceLabel = new JLabel(" Var = ");
        Box b0 = Box.createHorizontalBox();
        b0.add(nodeName);
        b0.add(Box.createHorizontalGlue());
        Box b4 = Box.createHorizontalBox();
        b4.add(none);
        b4.add(Box.createHorizontalGlue());
        Box b1 = Box.createHorizontalBox();
        b1.add(manipulate);
        b1.add(meanLabel);
        b1.add(meanField);
        b1.add(varianceLabel);
        b1.add(varianceField);
        b1.add(Box.createHorizontalGlue());
        Box b2 = Box.createHorizontalBox();
        b2.add(predict);
        b2.add(Box.createHorizontalGlue());
        Box b3 = Box.createHorizontalBox();
        b3.add(condition);
        b3.add(Box.createHorizontalGlue());
        b.add(b0);
        b.add(b4);
        b.add(b1);
        b.add(b2);
        b.add(b3);
        int ret = JOptionPane.showOptionDialog(this, b, "Select Node Properties", -1, -1, null, new String[]{"OK"}, "OK");
        if (ret == 0) {
            if (none.isSelected()) {
                nodeInfo.setIdentifier('n');
            } else if (manipulate.isSelected()) {
                nodeInfo.setIdentifier('m');
                nodeInfo.setMean(meanField.getValue());
                nodeInfo.setVar(varianceField.getValue());
            } else if (predict.isSelected()) {
                nodeInfo.setIdentifier('p');
            } else if (condition.isSelected()) {
                nodeInfo.setIdentifier('c');
            }
        }
        this.resetLayoutPanel();
    }

    private void setFieldsEnabled(DoubleTextField meanField, JRadioButton manipulate, DoubleTextField varianceField) {
        meanField.setEnabled(manipulate.isSelected());
        varianceField.setEnabled(manipulate.isSelected());
    }

    private NodeInfo getNodeInfo(Node node) {
        if (this.input().get(node) == null) {
            this.input().put(node, new NodeInfo('n'));
        }
        return this.input().get(node);
    }

    private void doClickPredictButton() {
        List<Node> nodes = this.predictionRunner().getPag().getNodes();
        ManipulatedVariable variable = null;
        Node predictedVariable = null;
        HashSet<Node> conditioningSet = new HashSet<Node>();
        Iterator<Node> i$ = nodes.iterator();
        while (i$.hasNext()) {
            Node node;
            Node currentNode = node = i$.next();
            if (!this.input().containsKey(currentNode)) continue;
            NodeInfo nodeInfo = this.getNodeInfo(currentNode);
            if (nodeInfo.getChar() == 'm') {
                variable = new ManipulatedVariable(currentNode, nodeInfo.getMean(), nodeInfo.getVariance());
                continue;
            }
            if (nodeInfo.getChar() == 'p') {
                predictedVariable = currentNode;
                continue;
            }
            if (nodeInfo.getChar() != 'c') continue;
            conditioningSet.add(currentNode);
        }
        try {
            this.predictionRunner().setManipulatedVariable(variable);
            this.predictionRunner().setPredictedVariable(predictedVariable);
            this.predictionRunner().setConditioningVariables(conditioningSet);
            this.predictionRunner().execute();
        }
        catch (Exception exc) {
            String s = exc.getMessage();
            if ("".equals(s) || s == null) {
                s = "Execution failed.";
            }
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), s);
        }
        this.resetLayoutPanel();
    }

    private PredictionRunner getPredictionRunner() {
        return this.predictionRunner;
    }

    private final class NodeInfo {
        private char identifier;
        private double mean = 0.0;
        private double var = 1.0;

        NodeInfo(char k) {
            this.identifier = k;
        }

        NodeInfo(char k, double mean, double var) {
            this.identifier = k;
            this.setMean(mean);
            this.setVar(var);
        }

        public char getChar() {
            return this.getIdentifier();
        }

        public double getMean() {
            return this.mean;
        }

        public double getVariance() {
            return this.var;
        }

        public char getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(char identifier) {
            this.identifier = identifier;
        }

        public void setMean(double mean) {
            this.mean = mean;
        }

        public void setVar(double var) {
            this.var = var;
        }
    }
}

