/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.ClusterEditor;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.MimParams;
import edu.cmu.tetradapp.model.PurifyParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PurifyParamsEditor
extends JPanel
implements ParameterEditor {
    private PurifyParams params;
    private Object[] parentModels;
    private JButton editClusters;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (PurifyParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        this.parentModels = parentModels;
    }

    @Override
    public void setup() {
        DoubleTextField alphaField = new DoubleTextField(this.params.getAlpha(), 4, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    PurifyParamsEditor.this.getParams().setAlpha(value);
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        TestType[] descriptions = TestType.getTestDescriptions();
        JComboBox<TestType> testSelector = new JComboBox<TestType>(descriptions);
        testSelector.setSelectedItem(this.params.getTetradTestType());
        testSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                TestType testType = (TestType)combo.getSelectedItem();
                PurifyParamsEditor.this.getParams().setTetradTestType(testType);
            }
        });
        boolean discreteModel = this.setVarNames(this.parentModels, this.params);
        this.editClusters = new JButton("Edit");
        this.editClusters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurifyParamsEditor.this.openClusterEditor();
            }
        });
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Alpha:"));
        b1.add(Box.createHorizontalGlue());
        b1.add(alphaField);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Cluster Assignments:"));
        b2.add(Box.createHorizontalGlue());
        b2.add(this.editClusters);
        b.add(b2);
        if (!discreteModel) {
            Box b3 = Box.createHorizontalBox();
            b3.add(new JLabel("Statistical Test:"));
            b3.add(Box.createHorizontalGlue());
            b3.add(testSelector);
            b.add(b3);
        } else {
            this.params.setTetradTestType(TestType.DISCRETE_LRT);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private boolean setVarNames(Object[] parentModels, PurifyParams params) {
        boolean discreteModel;
        DataModel dataModel = null;
        for (Object parentModel : parentModels) {
            if (!(parentModel instanceof DataWrapper)) continue;
            DataWrapper dataWrapper = (DataWrapper)parentModel;
            dataModel = dataWrapper.getSelectedDataModel();
        }
        if (dataModel instanceof CovarianceMatrix) {
            discreteModel = false;
        } else {
            DataSet dataSet = (DataSet)dataModel;
            assert (dataSet != null);
            discreteModel = dataSet.isDiscrete();
        }
        this.getParams().setVarNames(params.getVarNames());
        return discreteModel;
    }

    private void openClusterEditor() {
        ClusterEditor clusterEditor = new ClusterEditor(this.getParams().getClusters(), this.getParams().getVarNames());
        JOptionPane.showMessageDialog(this.editClusters, clusterEditor);
    }

    private MimParams getParams() {
        return this.params;
    }
}

