/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.QQPlot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPanel;

public class QQPlotDisplayPanel
extends JPanel {
    private static Color LINE_COLOR = Color.GRAY.darker();
    private static final int PADDING = 50;
    private static final int HEIGHT = 650;
    private static final int DISPLAYED_HEIGHT = 650;
    private static final int WIDTH = 650;
    private static final int SPACE = 2;
    private static final int DASH = 10;
    private Dimension size = new Dimension(654, 650);
    private NumberFormat format = NumberFormatUtil.getInstance().getNumberFormat();
    private QQPlot qqPlot;
    private String displayString;
    private int topFreq = -1;
    private Map<Rectangle, Integer> rectMap = new ConcurrentHashMap<Rectangle, Integer>();

    public QQPlotDisplayPanel(QQPlot qqPlot) {
        this.qqPlot = qqPlot;
        if (qqPlot == null) {
            throw new NullPointerException("Given q-q plot must be null");
        }
        this.addMouseMotionListener(new MouseMovementListener());
        this.setToolTipText(" ");
    }

    public synchronized void updateQQPlot(QQPlot qqPlot) {
        if (qqPlot == null) {
            throw new NullPointerException("The given q-q plot must not be null");
        }
        this.displayString = null;
        this.qqPlot = qqPlot;
        this.topFreq = -1;
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.rectMap.clear();
        Graphics2D g2d = (Graphics2D)graphics;
        int height = 600;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, 654, 650);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(50, 0, 602, height);
        g2d.setColor(LINE_COLOR);
        g2d.drawRect(50, 0, 602, height);
        g2d.setColor(LINE_COLOR);
        g2d.drawString(this.format.format(Math.floor(this.qqPlot.getMinSample())), 55, height + 15);
        g2d.drawLine(50, height + 10, 50, height);
        String maxStr = this.format.format((int)Math.ceil(this.qqPlot.getMaxSample()));
        g2d.drawString(maxStr, 650 - fontMetrics.stringWidth(maxStr), height + 15);
        g2d.drawLine(652, height + 10, 652, height);
        int size = 150;
        g2d.setColor(LINE_COLOR);
        int topY = 0;
        String top = "" + Math.ceil(this.qqPlot.getMaxSample());
        g2d.drawString(top, 50 - fontMetrics.stringWidth(top), topY + 10);
        g2d.drawLine(40, topY, 50, topY);
        g2d.drawString(Math.floor(this.qqPlot.getMinSample()) + "", 50 - fontMetrics.stringWidth(Math.floor(this.qqPlot.getMinIdeal()) + ""), height - 2);
        g2d.drawLine(40, height, 50, height);
        double idealRange = this.qqPlot.getMaxIdeal() - this.qqPlot.getMinIdeal();
        double sampleRange = this.qqPlot.getMaxSample() - this.qqPlot.getMinSample();
        double idealPerSample = idealRange / sampleRange;
        double intersectPoint = this.qqPlot.getMaxSample() * idealPerSample;
        int dataColumn = this.qqPlot.getDataSet().getColumn(this.qqPlot.getSelectedVariable());
        if (dataColumn == -1) {
            for (int i = 0; i < this.qqPlot.getDataSet().getNumColumns(); ++i) {
                if (!(this.qqPlot.getDataSet().getVariable(i) instanceof ContinuousVariable)) continue;
                this.qqPlot.setSelectedVariable((ContinuousVariable)this.qqPlot.getDataSet().getVariable(i));
                dataColumn = i;
                break;
            }
        }
        g2d.setColor(new Color(255, 0, 0));
        double originX = 48.0;
        double originY = height - 2;
        for (int i = 0; i < this.qqPlot.getDataSet().getNumRows(); ++i) {
            double x = this.qqPlot.getDataSet().getDouble(i, dataColumn);
            double y = this.qqPlot.getComparisonVariable()[i];
            if (!(x >= this.qqPlot.getMinSample()) || !(x <= this.qqPlot.getMaxSample()) || !(y >= this.qqPlot.getMinSample()) || !(y <= this.qqPlot.getMaxSample())) continue;
            double[] result = this.plotPoint(x, y, Math.floor(this.qqPlot.getMinSample()), Math.ceil(this.qqPlot.getMaxSample()));
            g2d.fill(new Ellipse2D.Double(result[0], result[1], 4.0, 4.0));
        }
        g2d.setColor(LINE_COLOR);
        g2d.drawString(this.getDisplayString(), 50, 645);
    }

    private String getDisplayString() {
        if (this.displayString == null) {
            this.displayString = "Showing: " + this.qqPlot.getSelectedVariable().getName();
        }
        return this.displayString;
    }

    public double[] plotPoint(double x, double y, double minRange, double maxRange) {
        double[] result = new double[2];
        double range = maxRange - minRange;
        result[0] = 600.0 * ((y - minRange) / range) - 2.0 + 50.0;
        result[1] = 650.0 - 600.0 * ((x - minRange) / range) - 2.0 - 50.0;
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    private static int getMax(int[] freqs) {
        int max = freqs[0];
        for (int i = 1; i < freqs.length; ++i) {
            int current = freqs[i];
            if (max >= current) continue;
            max = current;
        }
        return max;
    }

    private class MouseMovementListener
    implements MouseMotionListener {
        private MouseMovementListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle rect;
            Point point = e.getPoint();
            Iterator i$ = QQPlotDisplayPanel.this.rectMap.keySet().iterator();
            while (i$.hasNext() && !(rect = (Rectangle)i$.next()).contains(point)) {
            }
        }
    }
}

