/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class RandomGraphEditor
extends JPanel {
    private IntTextField numNodesField;
    private IntTextField numLatentsField;
    private IntTextField maxEdgesField;
    private IntTextField maxIndegreeField;
    private IntTextField maxOutdegreeField;
    private IntTextField maxDegreeField;
    private JRadioButton chooseUniform;
    private JRadioButton chooseFixed;
    private JComboBox connectedBox;
    private JComboBox addCyclesBox;
    private IntTextField minNumCyclesField;
    private IntTextField minCycleLengthField;
    private boolean cyclicAllowed = false;

    public RandomGraphEditor(boolean cyclicAllowed) {
        this(new EdgeListGraph(), cyclicAllowed);
    }

    public RandomGraphEditor(Graph oldGraph, boolean cyclicAllowed) {
        this.cyclicAllowed = cyclicAllowed;
        int oldNumMeasured = 0;
        int oldNumLatents = 0;
        for (Node node : oldGraph.getNodes()) {
            if (node.getNodeType() == NodeType.LATENT) {
                ++oldNumMeasured;
            }
            if (node.getNodeType() != NodeType.LATENT) continue;
            ++oldNumLatents;
        }
        int oldNumNodes = oldNumMeasured + oldNumLatents;
        if (oldNumNodes > 1 && oldNumMeasured == this.getNumMeasuredNodes() && oldNumLatents == this.getNumLatents()) {
            this.setNumMeasuredNodes(oldNumMeasured);
            this.setNumLatents(oldNumLatents);
            this.setMaxEdges(Math.min(this.getMaxEdges(), oldNumNodes * (oldNumNodes - 1) / 2));
        }
        this.numNodesField = new IntTextField(this.getNumMeasuredNodes(), 4);
        this.numLatentsField = new IntTextField(this.getNumLatents(), 4);
        this.maxEdgesField = new IntTextField(this.getMaxEdges(), 4);
        this.maxIndegreeField = new IntTextField(this.getMaxIndegree(), 4);
        this.maxOutdegreeField = new IntTextField(this.getMaxOutdegree(), 4);
        this.maxDegreeField = new IntTextField(this.getMaxDegree(), 4);
        this.chooseUniform = new JRadioButton("Draw uniformly from all such DAGs");
        this.chooseFixed = new JRadioButton("Guarantee maximum number of edges");
        this.connectedBox = new JComboBox<String>(new String[]{"No", "Yes"});
        this.addCyclesBox = new JComboBox<String>(new String[]{"No", "Yes"});
        this.minNumCyclesField = new IntTextField(this.getMinNumCycles(), 4);
        this.minCycleLengthField = new IntTextField(this.getMinCycleLength(), 4);
        ButtonGroup group = new ButtonGroup();
        group.add(this.chooseUniform);
        group.add(this.chooseFixed);
        this.chooseUniform.setSelected(this.isUniformlySelected());
        this.chooseFixed.setSelected(!this.isUniformlySelected());
        this.numNodesField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (value == RandomGraphEditor.this.numNodesField.getValue()) {
                    return oldValue;
                }
                try {
                    RandomGraphEditor.this.setNumMeasuredNodes(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RandomGraphEditor.this.maxEdgesField.setValue(RandomGraphEditor.this.getMaxEdges());
                return value;
            }
        });
        this.numLatentsField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (value == RandomGraphEditor.this.numLatentsField.getValue()) {
                    return oldValue;
                }
                try {
                    RandomGraphEditor.this.setNumLatents(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RandomGraphEditor.this.maxEdgesField.setValue(RandomGraphEditor.this.getMaxEdges());
                return value;
            }
        });
        this.maxEdgesField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (value == RandomGraphEditor.this.maxEdgesField.getValue()) {
                    return oldValue;
                }
                try {
                    RandomGraphEditor.this.setMaxEdges(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return value;
            }
        });
        this.maxIndegreeField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (value == RandomGraphEditor.this.maxIndegreeField.getValue()) {
                    return oldValue;
                }
                try {
                    RandomGraphEditor.this.setMaxIndegree(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RandomGraphEditor.this.maxOutdegreeField.setValue(RandomGraphEditor.this.getMaxOutdegree());
                return value;
            }
        });
        this.maxOutdegreeField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (value == RandomGraphEditor.this.maxOutdegreeField.getValue()) {
                    return oldValue;
                }
                try {
                    RandomGraphEditor.this.setMaxOutdegree(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RandomGraphEditor.this.maxIndegreeField.setValue(RandomGraphEditor.this.getMaxIndegree());
                RandomGraphEditor.this.maxDegreeField.setValue(RandomGraphEditor.this.getMaxDegree());
                return value;
            }
        });
        this.maxDegreeField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (value == RandomGraphEditor.this.maxDegreeField.getValue()) {
                    return oldValue;
                }
                try {
                    RandomGraphEditor.this.setMaxDegree(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RandomGraphEditor.this.maxIndegreeField.setValue(RandomGraphEditor.this.getMaxIndegree());
                RandomGraphEditor.this.maxOutdegreeField.setValue(RandomGraphEditor.this.getMaxOutdegree());
                return value;
            }
        });
        if (this.isConnected()) {
            this.connectedBox.setSelectedItem("Yes");
        } else {
            this.connectedBox.setSelectedItem("No");
        }
        if (this.isUniformlySelected()) {
            this.maxIndegreeField.setEnabled(true);
            this.maxOutdegreeField.setEnabled(true);
            this.maxDegreeField.setEnabled(true);
            this.connectedBox.setEnabled(true);
        } else {
            this.maxIndegreeField.setEnabled(false);
            this.maxOutdegreeField.setEnabled(false);
            this.maxDegreeField.setEnabled(false);
            this.connectedBox.setEnabled(false);
        }
        if (this.isAddCycles()) {
            this.minNumCyclesField.setEnabled(true);
            this.minCycleLengthField.setEnabled(true);
        } else {
            this.minNumCyclesField.setEnabled(false);
            this.minCycleLengthField.setEnabled(false);
        }
        this.connectedBox.setMaximumSize(this.connectedBox.getPreferredSize());
        this.connectedBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                if ("Yes".equals(box.getSelectedItem())) {
                    RandomGraphEditor.this.setConnected(true);
                } else if ("No".equals(box.getSelectedItem())) {
                    RandomGraphEditor.this.setConnected(false);
                } else {
                    throw new IllegalArgumentException();
                }
                RandomGraphEditor.this.maxIndegreeField.setValue(RandomGraphEditor.this.getMaxIndegree());
                RandomGraphEditor.this.maxOutdegreeField.setValue(RandomGraphEditor.this.getMaxOutdegree());
                RandomGraphEditor.this.maxDegreeField.setValue(RandomGraphEditor.this.getMaxDegree());
                RandomGraphEditor.this.maxEdgesField.setValue(RandomGraphEditor.this.getMaxEdges());
            }
        });
        this.chooseUniform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton button = (JRadioButton)e.getSource();
                button.setSelected(true);
                RandomGraphEditor.this.setUniformlySelected(true);
                RandomGraphEditor.this.maxIndegreeField.setEnabled(true);
                RandomGraphEditor.this.maxOutdegreeField.setEnabled(true);
                RandomGraphEditor.this.maxDegreeField.setEnabled(true);
                RandomGraphEditor.this.connectedBox.setEnabled(true);
            }
        });
        this.chooseFixed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton button = (JRadioButton)e.getSource();
                button.setSelected(true);
                RandomGraphEditor.this.setUniformlySelected(false);
                RandomGraphEditor.this.maxIndegreeField.setEnabled(false);
                RandomGraphEditor.this.maxOutdegreeField.setEnabled(false);
                RandomGraphEditor.this.maxDegreeField.setEnabled(false);
                RandomGraphEditor.this.connectedBox.setEnabled(false);
            }
        });
        if (this.isAddCycles()) {
            this.addCyclesBox.setSelectedItem("Yes");
        } else {
            this.addCyclesBox.setSelectedItem("No");
        }
        this.addCyclesBox.setMaximumSize(this.addCyclesBox.getPreferredSize());
        this.addCyclesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                if ("Yes".equals(box.getSelectedItem())) {
                    RandomGraphEditor.this.setAddCycles(true);
                    RandomGraphEditor.this.minNumCyclesField.setEnabled(true);
                    RandomGraphEditor.this.minCycleLengthField.setEnabled(true);
                } else if ("No".equals(box.getSelectedItem())) {
                    RandomGraphEditor.this.setAddCycles(false);
                    RandomGraphEditor.this.minNumCyclesField.setEnabled(false);
                    RandomGraphEditor.this.minCycleLengthField.setEnabled(false);
                } else {
                    throw new IllegalArgumentException();
                }
            }
        });
        this.minNumCyclesField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (value == RandomGraphEditor.this.minNumCyclesField.getValue()) {
                    return oldValue;
                }
                try {
                    RandomGraphEditor.this.setMinNumCycles(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return value;
            }
        });
        this.minCycleLengthField.setFilter(new IntTextField.Filter(){

            @Override
            public int filter(int value, int oldValue) {
                if (value == RandomGraphEditor.this.minCycleLengthField.getValue()) {
                    return oldValue;
                }
                try {
                    RandomGraphEditor.this.setMinCycleLength(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return value;
            }
        });
        this.setLayout(new BorderLayout());
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Parameters for Random DAG:"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b10 = Box.createHorizontalBox();
        b10.add(new JLabel("Number of measured nodes:"));
        b10.add(Box.createRigidArea(new Dimension(10, 0)));
        b10.add(Box.createHorizontalGlue());
        b10.add(this.numNodesField);
        b1.add(b10);
        Box b11 = Box.createHorizontalBox();
        b11.add(new JLabel("Number of latent nodes:"));
        b11.add(Box.createHorizontalStrut(25));
        b11.add(Box.createHorizontalGlue());
        b11.add(this.numLatentsField);
        b1.add(b11);
        b1.add(Box.createVerticalStrut(5));
        Box b12 = Box.createHorizontalBox();
        b12.add(new JLabel("Maximum number of edges:"));
        b12.add(Box.createHorizontalGlue());
        b12.add(this.maxEdgesField);
        b1.add(b12);
        b1.add(Box.createVerticalStrut(5));
        Box b14 = Box.createHorizontalBox();
        b14.add(new JLabel("Maximum indegree:"));
        b14.add(Box.createHorizontalGlue());
        b14.add(this.maxIndegreeField);
        b1.add(b14);
        Box b15 = Box.createHorizontalBox();
        b15.add(new JLabel("Maximum outdegree:"));
        b15.add(Box.createHorizontalGlue());
        b15.add(this.maxOutdegreeField);
        b1.add(b15);
        Box b13 = Box.createHorizontalBox();
        b13.add(new JLabel("Maximum degree:"));
        b13.add(Box.createHorizontalGlue());
        b13.add(this.maxDegreeField);
        b1.add(b13);
        b1.add(Box.createVerticalStrut(5));
        Box b16 = Box.createHorizontalBox();
        b16.add(new JLabel("Connected:"));
        b16.add(Box.createHorizontalGlue());
        b16.add(this.connectedBox);
        b1.add(b16);
        b1.add(Box.createVerticalStrut(5));
        Box b17 = Box.createHorizontalBox();
        b17.add(this.chooseUniform);
        b17.add(Box.createHorizontalGlue());
        b1.add(b17);
        Box b18 = Box.createHorizontalBox();
        b18.add(this.chooseFixed);
        b18.add(Box.createHorizontalGlue());
        b1.add(b18);
        Box d = Box.createVerticalBox();
        b1.setBorder(new TitledBorder(""));
        d.add(b1);
        if (this.cyclicAllowed) {
            Box c1 = Box.createVerticalBox();
            Box c2 = Box.createHorizontalBox();
            c2.add(new JLabel("Add cycles? (Adds edges)"));
            c2.add(Box.createHorizontalGlue());
            c2.add(this.addCyclesBox);
            c1.add(c2);
            c1.add(Box.createVerticalStrut(5));
            Box c3 = Box.createHorizontalBox();
            c3.add(new JLabel("Minimum number of cycles"));
            c3.add(Box.createHorizontalGlue());
            c3.add(this.minNumCyclesField);
            c1.add(c3);
            c1.add(Box.createVerticalStrut(5));
            Box c4 = Box.createHorizontalBox();
            c4.add(new JLabel("Minimum cycle length"));
            c4.add(Box.createHorizontalGlue());
            c4.add(this.minCycleLengthField);
            c1.add(c4);
            c1.setBorder(new TitledBorder(""));
            d.add(Box.createVerticalStrut(5));
            d.add(c1);
        }
        this.add((Component)d, "Center");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!this.isUniformlySelected() && enabled) {
            this.numNodesField.setEnabled(enabled);
            this.numLatentsField.setEnabled(enabled);
            this.maxEdgesField.setEnabled(enabled);
            this.maxIndegreeField.setEnabled(false);
            this.maxOutdegreeField.setEnabled(false);
            this.maxDegreeField.setEnabled(false);
            this.connectedBox.setEnabled(false);
            this.chooseUniform.setEnabled(enabled);
            this.chooseFixed.setEnabled(enabled);
        } else {
            this.numNodesField.setEnabled(enabled);
            this.numLatentsField.setEnabled(enabled);
            this.maxEdgesField.setEnabled(enabled);
            this.maxIndegreeField.setEnabled(enabled);
            this.maxOutdegreeField.setEnabled(enabled);
            this.maxDegreeField.setEnabled(enabled);
            this.connectedBox.setEnabled(enabled);
            this.chooseUniform.setEnabled(enabled);
            this.chooseFixed.setEnabled(enabled);
        }
    }

    public boolean isUniformlySelected() {
        return Preferences.userRoot().getBoolean("graphUniformlySelected", true);
    }

    public void setUniformlySelected(boolean uniformlySelected) {
        Preferences.userRoot().putBoolean("graphUniformlySelected", uniformlySelected);
    }

    public int getNumNodes() {
        return this.getNumMeasuredNodes() + this.getNumLatents();
    }

    public int getNumMeasuredNodes() {
        return Preferences.userRoot().getInt("newGraphNumMeasuredNodes", 5);
    }

    private void setNumMeasuredNodes(int numMeasuredNodes) {
        if (numMeasuredNodes + this.getNumLatents() < 2) {
            throw new IllegalArgumentException("Number of nodes must be >= 2.");
        }
        Preferences.userRoot().putInt("newGraphNumMeasuredNodes", numMeasuredNodes);
        if (this.isConnected()) {
            this.setMaxEdges(Math.max(this.getMaxEdges(), numMeasuredNodes + this.getNumLatents()));
        }
    }

    public int getNumLatents() {
        return Preferences.userRoot().getInt("newGraphNumLatents", 0);
    }

    private void setNumLatents(int numLatentNodes) {
        if (numLatentNodes < 0) {
            throw new IllegalArgumentException("Number of latent nodes must be >= 0: " + numLatentNodes);
        }
        Preferences.userRoot().putInt("newGraphNumLatents", numLatentNodes);
    }

    public int getMaxEdges() {
        return Preferences.userRoot().getInt("newGraphNumEdges", 3);
    }

    private void setMaxEdges(int numEdges) {
        if (this.isConnected() && numEdges < this.getNumNodes()) {
            throw new IllegalArgumentException("When assuming connectedness, the number of edges must be at least the number of nodes.");
        }
        if (!this.isConnected() && numEdges < 0) {
            throw new IllegalArgumentException("Number of edges must be >= 0: " + numEdges);
        }
        int maxNumEdges = this.getNumNodes() * (this.getNumNodes() - 1) / 2;
        if (numEdges > maxNumEdges) {
            numEdges = maxNumEdges;
        }
        Preferences.userRoot().putInt("newGraphNumEdges", numEdges);
    }

    public int getMaxDegree() {
        return Preferences.userRoot().getInt("randomGraphMaxDegree", 6);
    }

    private void setMaxDegree(int maxDegree) {
        if (!this.isConnected() && maxDegree < 1) {
            Preferences.userRoot().putInt("randomGraphMaxDegree", 1);
            return;
        }
        if (this.isConnected() && maxDegree < 3) {
            Preferences.userRoot().putInt("randomGraphMaxDegree", 3);
            return;
        }
        Preferences.userRoot().putInt("randomGraphMaxDegree", maxDegree);
    }

    public int getMaxIndegree() {
        return Preferences.userRoot().getInt("randomGraphMaxIndegree", 3);
    }

    private void setMaxIndegree(int maxIndegree) {
        if (!this.isConnected() && maxIndegree < 1) {
            Preferences.userRoot().putInt("randomGraphMaxIndegree", 1);
            return;
        }
        if (this.isConnected() && maxIndegree < 2) {
            Preferences.userRoot().putInt("randomGraphMaxIndegree", 2);
            return;
        }
        Preferences.userRoot().putInt("randomGraphMaxIndegree", maxIndegree);
    }

    public int getMaxOutdegree() {
        return Preferences.userRoot().getInt("randomGraphMaxOutdegree", 3);
    }

    private void setMaxOutdegree(int maxOutDegree) {
        if (!this.isConnected() && maxOutDegree < 1) {
            Preferences.userRoot().putInt("randomGraphMaxOutdegree", 1);
            return;
        }
        if (this.isConnected() && maxOutDegree < 2) {
            Preferences.userRoot().putInt("randomGraphMaxOutdegree", 2);
            return;
        }
        Preferences.userRoot().putInt("randomGraphMaxOutdegree", maxOutDegree);
    }

    private void setConnected(boolean connected) {
        Preferences.userRoot().putBoolean("randomGraphConnected", connected);
        if (connected) {
            if (this.getMaxIndegree() < 2) {
                this.setMaxIndegree(2);
            }
            if (this.getMaxOutdegree() < 2) {
                this.setMaxOutdegree(2);
            }
            if (this.getMaxDegree() < 3) {
                this.setMaxDegree(3);
            }
            if (this.getMaxEdges() < this.getNumNodes()) {
                this.setMaxEdges(this.getNumNodes());
            }
        }
    }

    public boolean isConnected() {
        return Preferences.userRoot().getBoolean("randomGraphConnected", false);
    }

    private void setAddCycles(boolean addCycles) {
        Preferences.userRoot().putBoolean("randomGraphAddCycles", addCycles);
    }

    public boolean isAddCycles() {
        return Preferences.userRoot().getBoolean("randomGraphAddCycles", false);
    }

    public int getMinNumCycles() {
        int minNumCycles = Preferences.userRoot().getInt("randomGraphMinNumCycles", 0);
        System.out.println("get min num cycles = " + minNumCycles);
        return minNumCycles;
    }

    private void setMinNumCycles(int minNumCycles) {
        System.out.println("set min num cycles = " + minNumCycles);
        if (minNumCycles < 0) {
            Preferences.userRoot().putInt("randomGraphMinNumCycles", 0);
            return;
        }
        Preferences.userRoot().putInt("randomGraphMinNumCycles", minNumCycles);
    }

    public int getMinCycleLength() {
        return Preferences.userRoot().getInt("randomGraphMinCycleLength", 2);
    }

    private void setMinCycleLength(int minCycleLength) {
        if (minCycleLength < 2) {
            Preferences.userRoot().putInt("randomGraphMinCycleLength", 2);
            return;
        }
        Preferences.userRoot().putInt("randomGraphMinCycleLength", minCycleLength);
    }
}

